/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.common;

import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.physics.box2d.common.Rotation;
import java.io.Serializable;

public final class Transform
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final Vec2 p = new Vec2();
    public final Rotation q = new Rotation();
    private static Vec2 pool = new Vec2();

    public Transform set(Transform xf) {
        this.p.set(xf.p);
        this.q.set(xf.q);
        return this;
    }

    public void set(Vec2 p, float angle) {
        this.p.set(p);
        this.q.set(angle);
    }

    public void setIdentity() {
        this.p.setZero();
        this.q.setIdentity();
    }

    public float mulX(Vec2 v) {
        return this.q.c * v.x - this.q.s * v.y + this.p.x;
    }

    public float mulY(Vec2 v) {
        return this.q.s * v.x + this.q.c * v.y + this.p.y;
    }

    public void shift(Vec2 v) {
        this.p.x -= this.q.c * v.x - this.q.s * v.y;
        this.p.y -= this.q.s * v.x + this.q.c * v.y;
    }

    public static Vec2 mul(Transform T, Vec2 v) {
        return new Vec2(T.q.c * v.x - T.q.s * v.y + T.p.x, T.q.s * v.x + T.q.c * v.y + T.p.y);
    }

    public static void mulToOut(Transform T, Vec2 v, Vec2 out) {
        float tempy = T.q.s * v.x + T.q.c * v.y + T.p.y;
        out.x = T.q.c * v.x - T.q.s * v.y + T.p.x;
        out.y = tempy;
    }

    public static void mulToOutUnsafe(Transform T, Vec2 v, Vec2 out) {
        assert (v != out);
        out.x = T.q.c * v.x - T.q.s * v.y + T.p.x;
        out.y = T.q.s * v.x + T.q.c * v.y + T.p.y;
    }

    public static void mulTransToOut(Transform T, Vec2 v, Vec2 out) {
        float px = v.x - T.p.x;
        float py = v.y - T.p.y;
        float tempy = -T.q.s * px + T.q.c * py;
        out.x = T.q.c * px + T.q.s * py;
        out.y = tempy;
    }

    public static void mulTransToOutUnsafe(Transform T, Vec2 v, Vec2 out) {
        assert (v != out);
        float px = v.x - T.p.x;
        float py = v.y - T.p.y;
        out.x = T.q.c * px + T.q.s * py;
        out.y = -T.q.s * px + T.q.c * py;
    }

    public static void mulToOut(Transform A, Transform B, Transform out) {
        assert (out != A);
        Rotation.mul(A.q, B.q, out.q);
        Rotation.mulToOut(A.q, B.p, out.p);
        out.p.addLocal(A.p);
    }

    public static void mulTransToOutUnsafe(Transform A, Transform B, Transform out) {
        assert (out != A);
        assert (out != B);
        Rotation.mulTransUnsafe(A.q, B.q, out.q);
        pool.set(B.p).subLocal(A.p);
        Rotation.mulTransUnsafe(A.q, pool, out.p);
    }

    public String toString() {
        Object s = "XForm:\n";
        s = (String)s + "Position: " + this.p + "\n";
        s = (String)s + "R: \n" + this.q + "\n";
        return s;
    }
}

