/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.collision.shapes;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.physics.box2d.collision.AABB;
import com.almasb.fxgl.physics.box2d.collision.RayCastInput;
import com.almasb.fxgl.physics.box2d.collision.RayCastOutput;
import com.almasb.fxgl.physics.box2d.collision.shapes.EdgeShape;
import com.almasb.fxgl.physics.box2d.collision.shapes.MassData;
import com.almasb.fxgl.physics.box2d.collision.shapes.Shape;
import com.almasb.fxgl.physics.box2d.collision.shapes.ShapeType;
import com.almasb.fxgl.physics.box2d.common.JBoxSettings;
import com.almasb.fxgl.physics.box2d.common.Transform;

public final class ChainShape
extends Shape {
    private Vec2[] m_vertices = null;
    private int m_count = 0;
    private final Vec2 m_prevVertex = new Vec2();
    private final Vec2 m_nextVertex = new Vec2();
    private boolean m_hasPrevVertex = false;
    private boolean m_hasNextVertex = false;
    private final EdgeShape pool0 = new EdgeShape();

    public ChainShape() {
        super(ShapeType.CHAIN, JBoxSettings.polygonRadius);
    }

    @Override
    public Shape clone() {
        ChainShape clone = new ChainShape();
        clone.createChain(this.m_vertices, this.m_count);
        clone.m_prevVertex.set(this.m_prevVertex);
        clone.m_nextVertex.set(this.m_nextVertex);
        clone.m_hasPrevVertex = this.m_hasPrevVertex;
        clone.m_hasNextVertex = this.m_hasNextVertex;
        return clone;
    }

    @Override
    public int getChildCount() {
        return this.m_count - 1;
    }

    @Override
    public float computeDistanceToOut(Transform xf, Vec2 p, int childIndex, Vec2 normalOut) {
        EdgeShape edge = this.pool0;
        this.getChildEdge(edge, childIndex);
        return edge.computeDistanceToOut(xf, p, 0, normalOut);
    }

    @Override
    public boolean containsPoint(Transform xf, Vec2 point) {
        return false;
    }

    @Override
    public boolean raycast(RayCastOutput output, RayCastInput input, Transform xf, int childIndex) {
        int i1 = childIndex;
        int i2 = childIndex + 1;
        if (i2 == this.m_count) {
            i2 = 0;
        }
        EdgeShape edgeShape = this.pool0;
        edgeShape.m_vertex1.set(this.m_vertices[i1]);
        edgeShape.m_vertex2.set(this.m_vertices[i2]);
        return edgeShape.raycast(output, input, xf, 0);
    }

    @Override
    public void computeAABB(AABB aabb, Transform transform, int childIndex) {
        Vec2 lower = aabb.lowerBound;
        Vec2 upper = aabb.upperBound;
        int i1 = childIndex;
        int i2 = childIndex + 1;
        if (i2 == this.m_count) {
            i2 = 0;
        }
        Vec2 vi1 = this.m_vertices[i1];
        Vec2 vi2 = this.m_vertices[i2];
        float v1x = transform.mulX(vi1);
        float v1y = transform.mulY(vi1);
        float v2x = transform.mulX(vi2);
        float v2y = transform.mulY(vi2);
        lower.x = FXGLMath.min((float)v1x, (float)v2x);
        lower.y = FXGLMath.min((float)v1y, (float)v2y);
        upper.x = FXGLMath.max((float)v1x, (float)v2x);
        upper.y = FXGLMath.max((float)v1y, (float)v2y);
    }

    @Override
    public void computeMass(MassData massData, float density) {
        massData.mass = 0.0f;
        massData.center.setZero();
        massData.I = 0.0f;
    }

    public void getChildEdge(EdgeShape edge, int index) {
        assert (0 <= index && index < this.m_count - 1);
        edge.setRadius(this.getRadius());
        edge.m_vertex1.set(this.m_vertices[index + 0]);
        edge.m_vertex2.set(this.m_vertices[index + 1]);
        if (index > 0) {
            edge.m_vertex0.set(this.m_vertices[index - 1]);
            edge.m_hasVertex0 = true;
        } else {
            edge.m_vertex0.set(this.m_prevVertex);
            edge.m_hasVertex0 = this.m_hasPrevVertex;
        }
        if (index < this.m_count - 2) {
            edge.m_vertex3.set(this.m_vertices[index + 2]);
            edge.m_hasVertex3 = true;
        } else {
            edge.m_vertex3.set(this.m_nextVertex);
            edge.m_hasVertex3 = this.m_hasNextVertex;
        }
    }

    public void createLoop(Vec2[] vertices, int count) {
        int i;
        assert (this.m_vertices == null && this.m_count == 0);
        assert (count >= 3);
        this.m_count = count + 1;
        this.m_vertices = new Vec2[this.m_count];
        for (i = 1; i < count; ++i) {
            Vec2 v1 = vertices[i - 1];
            Vec2 v2 = vertices[i];
            if (!(v1.distanceSquared(v2) < JBoxSettings.linearSlop * JBoxSettings.linearSlop)) continue;
            throw new RuntimeException("Vertices of chain shape are too close together");
        }
        for (i = 0; i < count; ++i) {
            this.m_vertices[i] = new Vec2(vertices[i]);
        }
        this.m_vertices[count] = new Vec2(this.m_vertices[0]);
        this.m_prevVertex.set(this.m_vertices[this.m_count - 2]);
        this.m_nextVertex.set(this.m_vertices[1]);
        this.m_hasPrevVertex = true;
        this.m_hasNextVertex = true;
    }

    public void createChain(Vec2[] vertices, int count) {
        int i;
        assert (this.m_vertices == null && this.m_count == 0);
        assert (count >= 2);
        this.m_count = count;
        this.m_vertices = new Vec2[this.m_count];
        for (i = 1; i < this.m_count; ++i) {
            Vec2 v1 = vertices[i - 1];
            Vec2 v2 = vertices[i];
            if (!(v1.distanceSquared(v2) < JBoxSettings.linearSlop * JBoxSettings.linearSlop)) continue;
            throw new RuntimeException("Vertices of chain shape are too close together");
        }
        for (i = 0; i < this.m_count; ++i) {
            this.m_vertices[i] = new Vec2(vertices[i]);
        }
        this.m_hasPrevVertex = false;
        this.m_hasNextVertex = false;
        this.m_prevVertex.setZero();
        this.m_nextVertex.setZero();
    }

    public void setPrevVertex(Vec2 prevVertex) {
        this.m_prevVertex.set(prevVertex);
        this.m_hasPrevVertex = true;
    }

    public void setNextVertex(Vec2 nextVertex) {
        this.m_nextVertex.set(nextVertex);
        this.m_hasNextVertex = true;
    }

    public int getCount() {
        return this.m_count;
    }

    public Vec2 getVertex(int index) {
        return this.m_vertices[index];
    }
}

