/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.pathfinding.astar;

import com.almasb.fxgl.pathfinding.CellState;
import com.almasb.fxgl.pathfinding.Pathfinder;
import com.almasb.fxgl.pathfinding.astar.AStarCell;
import com.almasb.fxgl.pathfinding.astar.AStarGrid;
import com.almasb.fxgl.pathfinding.astar.CacheKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class AStarPathfinder
implements Pathfinder<AStarCell> {
    private final AStarGrid grid;
    private boolean isCachingPaths = false;
    private Map<CacheKey, List<AStarCell>> cache = new HashMap<CacheKey, List<AStarCell>>();

    public AStarPathfinder(AStarGrid grid) {
        this.grid = grid;
    }

    public AStarGrid getGrid() {
        return this.grid;
    }

    public void setCachingPaths(boolean isCachingPaths) {
        this.isCachingPaths = isCachingPaths;
    }

    public boolean isCachingPaths() {
        return this.isCachingPaths;
    }

    @Override
    public List<AStarCell> findPath(int sourceX, int sourceY, int targetX, int targetY) {
        return this.findPath((AStarCell[][])this.grid.getData(), (AStarCell)this.grid.get(sourceX, sourceY), (AStarCell)this.grid.get(targetX, targetY), new AStarCell[0]);
    }

    @Override
    public List<AStarCell> findPath(int sourceX, int sourceY, int targetX, int targetY, List<AStarCell> busyCells) {
        return this.findPath((AStarCell[][])this.grid.getData(), (AStarCell)this.grid.get(sourceX, sourceY), (AStarCell)this.grid.get(targetX, targetY), busyCells.toArray(new AStarCell[0]));
    }

    public List<AStarCell> findPath(AStarCell[][] grid, AStarCell start, AStarCell target, AStarCell ... busyNodes) {
        List<AStarCell> path;
        if (start == target || target.getState() == CellState.NOT_WALKABLE) {
            return Collections.emptyList();
        }
        CacheKey cacheKey = new CacheKey(start.getX(), start.getY(), target.getX(), target.getY());
        if (this.isCachingPaths && (path = this.cache.get(cacheKey)) != null) {
            return new ArrayList<AStarCell>(path);
        }
        for (int y = 0; y < grid[0].length; ++y) {
            for (int x = 0; x < grid.length; ++x) {
                grid[x][y].setHCost(Math.abs(target.getX() - x) + Math.abs(target.getY() - y));
                grid[x][y].setParent(null);
                grid[x][y].setGCost(0);
            }
        }
        HashSet<AStarCell> open = new HashSet<AStarCell>();
        HashSet<AStarCell> closed = new HashSet<AStarCell>();
        AStarCell current = start;
        boolean found = false;
        while (!found && !closed.contains((Object)target)) {
            for (AStarCell neighbor : this.getValidNeighbors(current, busyNodes)) {
                if (neighbor == target) {
                    target.setParent(current);
                    found = true;
                    closed.add(target);
                    break;
                }
                if (closed.contains((Object)neighbor)) continue;
                if (open.contains((Object)neighbor)) {
                    int newG = current.getGCost() + 10;
                    if (newG >= neighbor.getGCost()) continue;
                    neighbor.setParent(current);
                    neighbor.setGCost(newG);
                    continue;
                }
                neighbor.setParent(current);
                neighbor.setGCost(current.getGCost() + 10);
                open.add(neighbor);
            }
            if (found) continue;
            closed.add(current);
            open.remove((Object)current);
            if (open.isEmpty()) {
                return Collections.emptyList();
            }
            AStarCell acc = null;
            for (AStarCell a : open) {
                if (acc == null) {
                    acc = a;
                    continue;
                }
                acc = a.getFCost() < acc.getFCost() ? a : acc;
            }
            current = acc;
        }
        List<AStarCell> path2 = this.buildPath(start, target);
        if (this.isCachingPaths) {
            this.cache.put(cacheKey, path2);
        }
        return new ArrayList<AStarCell>(path2);
    }

    private List<AStarCell> buildPath(AStarCell start, AStarCell target) {
        ArrayList<AStarCell> path = new ArrayList<AStarCell>();
        AStarCell tmp = target;
        do {
            path.add(tmp);
        } while ((tmp = tmp.getParent()) != start);
        Collections.reverse(path);
        return path;
    }

    private List<AStarCell> getValidNeighbors(AStarCell node, AStarCell ... busyNodes) {
        List result = this.grid.getNeighbors(node.getX(), node.getY());
        result.removeAll(Arrays.asList(busyNodes));
        result.removeIf(cell -> !cell.isWalkable());
        return result;
    }
}

