/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity;

import com.almasb.fxgl.core.collection.Array;
import com.almasb.fxgl.core.collection.PropertyMap;
import com.almasb.fxgl.core.collection.UnorderedArray;
import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.reflect.ReflectionUtils;
import com.almasb.fxgl.core.util.DSLKt;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.EntityFactory;
import com.almasb.fxgl.entity.EntityGroup;
import com.almasb.fxgl.entity.EntityPool;
import com.almasb.fxgl.entity.EntityWorldListener;
import com.almasb.fxgl.entity.GameWorld;
import com.almasb.fxgl.entity.SpawnData;
import com.almasb.fxgl.entity.Spawns;
import com.almasb.fxgl.entity.component.Component;
import com.almasb.fxgl.entity.components.IDComponent;
import com.almasb.fxgl.entity.components.IrremovableComponent;
import com.almasb.fxgl.entity.components.TimeComponent;
import com.almasb.fxgl.entity.level.Level;
import com.almasb.fxgl.logging.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0010\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 l2\u00020\u0001:\u0001lB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0005H\u0002J\u001f\u0010$\u001a\u00020\"2\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050&\"\u00020\u0005\u00a2\u0006\u0002\u0010'J\u000e\u0010(\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0005J\u000e\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020\u000fJ\u000e\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020 J\u0010\u0010-\u001a\u00020.2\u0006\u0010#\u001a\u00020\u0005H\u0002J\u0018\u0010/\u001a\u00020\"2\u0006\u0010*\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\u0010H\u0002J\b\u00101\u001a\u00020\"H\u0002J\u0016\u00102\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u0014J\"\u00104\u001a\b\u0012\u0004\u0012\u00020\u0005052\u0006\u0010#\u001a\u00020\u00052\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u000507J\u0014\u00108\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010#\u001a\u00020\u0005J\u0014\u00109\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010:\u001a\u00020;J\u001c\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u000e\u0010=\u001a\n\u0012\u0006\b\u0001\u0012\u00020?0>J*\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002HB0A\"\b\b\u0000\u0010B*\u00020?2\f\u0010=\u001a\b\u0012\u0004\u0012\u0002HB0>J-\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u001a\u0010D\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030E0&\"\u0006\u0012\u0002\b\u00030E\u00a2\u0006\u0002\u0010FJ\u001a\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u000507J\u0014\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010J\u001a\u00020KJ\u001c\u0010L\u001a\b\u0012\u0004\u0012\u00020\u0005052\u0006\u0010M\u001a\u00020\u00102\u0006\u0010N\u001a\u00020OJ'\u0010P\u001a\u00020Q2\u001a\u0010R\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030E0&\"\u0006\u0012\u0002\b\u00030E\u00a2\u0006\u0002\u0010SJ\u001a\u0010T\u001a\b\u0012\u0004\u0012\u00020\u0005052\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u000507J\u0018\u0010T\u001a\b\u0012\u0004\u0012\u00020\u0005052\n\u0010=\u001a\u0006\u0012\u0002\b\u00030EJ\u0014\u0010U\u001a\u00020\u00052\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u000507J\u0012\u0010U\u001a\u00020\u00052\n\u0010=\u001a\u0006\u0012\u0002\b\u00030EJ\u001a\u0010V\u001a\b\u0012\u0004\u0012\u00020\u0005052\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u000507J\u0018\u0010V\u001a\b\u0012\u0004\u0012\u00020\u0005052\n\u0010=\u001a\u0006\u0012\u0002\b\u00030EJ1\u0010W\u001a\u00020.2\u0006\u0010#\u001a\u00020\u00052\u001a\u0010D\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030E0&\"\u0006\u0012\u0002\b\u00030EH\u0002\u00a2\u0006\u0002\u0010XJ\u0010\u0010Y\u001a\u00020\"2\u0006\u0010Z\u001a\u00020\u0005H\u0002J\u0010\u0010[\u001a\u00020\"2\u0006\u0010Z\u001a\u00020\u0005H\u0002J\u000e\u0010\\\u001a\u00020\"2\u0006\u0010]\u001a\u00020^J\u001f\u0010_\u001a\u00020\"2\u0012\u0010`\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050&\"\u00020\u0005\u00a2\u0006\u0002\u0010'J\u0014\u0010_\u001a\u00020\"2\f\u0010`\u001a\b\u0012\u0004\u0012\u00020\u00050aJ\u000e\u0010b\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0005J\u000e\u0010c\u001a\u00020\"2\u0006\u0010*\u001a\u00020\u000fJ\u000e\u0010d\u001a\u00020\"2\u0006\u0010,\u001a\u00020 J\u0006\u0010e\u001a\u00020\"J\u000e\u0010f\u001a\u00020\"2\u0006\u0010g\u001a\u00020hJ\u000e\u0010i\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u0010J\u0016\u0010i\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u0014J\u0016\u0010i\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u00102\u0006\u0010:\u001a\u00020;J\u001e\u0010i\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u00102\u0006\u0010j\u001a\u00020^2\u0006\u0010k\u001a\u00020^R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR6\u0010\r\u001a*\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\n0\u000ej\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\n`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u0012\u001a6\u0012\u0004\u0012\u00020\u0010\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00050\u00130\u000ej\u001a\u0012\u0004\u0012\u00020\u0010\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00050\u0013`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006m"}, d2={"Lcom/almasb/fxgl/entity/GameWorld;", "", "()V", "entities", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/entity/Entity;", "Lkotlin/collections/ArrayList;", "getEntities", "()Ljava/util/ArrayList;", "entitiesCopy", "", "getEntitiesCopy", "()Ljava/util/List;", "entityFactories", "Ljava/util/HashMap;", "Lcom/almasb/fxgl/entity/EntityFactory;", "", "Lkotlin/collections/HashMap;", "entitySpawners", "Ljava/util/function/Function;", "Lcom/almasb/fxgl/entity/SpawnData;", "pool", "Lcom/almasb/fxgl/entity/EntityPool;", "properties", "Lcom/almasb/fxgl/core/collection/PropertyMap;", "getProperties", "()Lcom/almasb/fxgl/core/collection/PropertyMap;", "updateList", "Lcom/almasb/fxgl/core/collection/Array;", "waitingList", "Lcom/almasb/fxgl/core/collection/UnorderedArray;", "worldListeners", "Lcom/almasb/fxgl/entity/EntityWorldListener;", "add", "", "entity", "addEntities", "entitiesToAdd", "", "([Lcom/almasb/fxgl/entity/Entity;)V", "addEntity", "addEntityFactory", "entityFactory", "addWorldListener", "listener", "canRemove", "", "checkDuplicateSpawners", "entityName", "clearLevel", "create", "data", "getClosestEntity", "Ljava/util/Optional;", "filter", "Ljava/util/function/Predicate;", "getCollidingEntities", "getEntitiesAt", "position", "Ljavafx/geometry/Point2D;", "getEntitiesByComponent", "type", "Ljava/lang/Class;", "Lcom/almasb/fxgl/entity/component/Component;", "getEntitiesByComponentMapped", "", "T", "getEntitiesByType", "types", "", "([Ljava/lang/Enum;)Ljava/util/List;", "getEntitiesFiltered", "predicate", "getEntitiesInRange", "selection", "Ljavafx/geometry/Rectangle2D;", "getEntityByID", "name", "id", "", "getGroup", "Lcom/almasb/fxgl/entity/EntityGroup;", "entityTypes", "([Ljava/lang/Enum;)Lcom/almasb/fxgl/entity/EntityGroup;", "getRandom", "getSingleton", "getSingletonOptional", "isOneOfTypes", "(Lcom/almasb/fxgl/entity/Entity;[Ljava/lang/Enum;)Z", "notifyEntityAdded", "e", "notifyEntityRemoved", "onUpdate", "tpf", "", "removeEntities", "entitiesToRemove", "", "removeEntity", "removeEntityFactory", "removeWorldListener", "reset", "setLevel", "level", "Lcom/almasb/fxgl/entity/level/Level;", "spawn", "x", "y", "Companion", "fxgl-entity"})
@SourceDebugExtension(value={"SMAP\nGameWorld.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameWorld.kt\ncom/almasb/fxgl/entity/GameWorld\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,597:1\n1855#2,2:598\n1855#2,2:600\n1855#2,2:602\n1855#2,2:604\n1855#2,2:607\n766#2:609\n857#2,2:610\n766#2:612\n857#2,2:613\n1271#2,2:615\n1285#2,4:617\n766#2:621\n857#2,2:622\n766#2:624\n857#2,2:625\n766#2:629\n857#2,2:630\n766#2:632\n857#2,2:633\n766#2:635\n857#2,2:636\n766#2:638\n857#2,2:639\n1045#2:641\n1#3:606\n12744#4,2:627\n*S KotlinDebug\n*F\n+ 1 GameWorld.kt\ncom/almasb/fxgl/entity/GameWorld\n*L\n209#1:598,2\n233#1:600,2\n237#1:602,2\n251#1:604,2\n346#1:607,2\n476#1:609\n476#1:610,2\n484#1:612\n484#1:613,2\n484#1:615,2\n484#1:617,4\n495#1:621\n495#1:622,2\n508#1:624\n508#1:625,2\n525#1:629\n525#1:630,2\n538#1:632\n538#1:633,2\n549#1:635\n549#1:636,2\n566#1:638\n566#1:639,2\n567#1:641\n512#1:627,2\n*E\n"})
public final class GameWorld {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PropertyMap properties = new PropertyMap();
    @NotNull
    private final Array<Entity> updateList = new Array();
    @NotNull
    private final UnorderedArray<Entity> waitingList = new UnorderedArray(0, 1, null);
    @NotNull
    private final ArrayList<Entity> entities = new ArrayList();
    @NotNull
    private final EntityPool pool = new EntityPool();
    @NotNull
    private final Array<EntityWorldListener> worldListeners;
    @NotNull
    private final HashMap<EntityFactory, List<String>> entityFactories;
    @NotNull
    private final HashMap<String, Function<SpawnData, Entity>> entitySpawners;
    @NotNull
    private static final Logger log = Logger.Companion.get("GameWorld");

    public GameWorld() {
        log.debug("Game world initialized");
        this.worldListeners = new Array();
        this.entityFactories = new HashMap();
        this.entitySpawners = new HashMap();
    }

    @NotNull
    public final PropertyMap getProperties() {
        return this.properties;
    }

    @NotNull
    public final ArrayList<Entity> getEntities() {
        return this.entities;
    }

    @NotNull
    public final List<Entity> getEntitiesCopy() {
        return new ArrayList(this.entities);
    }

    public final void addEntity(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity.isActive()) {
            log.warning("Entity is already attached to world");
            return;
        }
        if (entity.isEverUpdated()) {
            this.waitingList.add((Object)entity);
        }
        this.entities.add(entity);
        this.add(entity);
    }

    public final void addEntities(Entity ... entitiesToAdd) {
        Intrinsics.checkNotNullParameter((Object)entitiesToAdd, (String)"entitiesToAdd");
        for (Entity e : entitiesToAdd) {
            this.addEntity(e);
        }
    }

    private final void add(Entity entity) {
        entity.init(this);
        this.notifyEntityAdded(entity);
    }

    public final void removeEntity(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!entity.isActive()) {
            log.warning("Attempted to remove entity which is not active");
            return;
        }
        if (!this.canRemove(entity)) {
            return;
        }
        if (entity.getWorld() != this) {
            log.warning("Attempted to remove entity not attached to this world");
            return;
        }
        this.entities.remove(entity);
        entity.markForRemoval();
        this.notifyEntityRemoved(entity);
        if (entity.isReusable()) {
            entity.getPropertyOptional("spawnName").ifPresent(arg_0 -> GameWorld.removeEntity$lambda$0((Function1)new Function1<String, Unit>(this, entity){
                final /* synthetic */ GameWorld this$0;
                final /* synthetic */ Entity $entity;
                {
                    this.this$0 = $receiver;
                    this.$entity = $entity;
                    super(1);
                }

                public final void invoke(@NotNull String spawnName) {
                    Intrinsics.checkNotNullParameter((Object)spawnName, (String)"spawnName");
                    GameWorld.access$getPool$p(this.this$0).put(spawnName, this.$entity);
                }
            }, arg_0));
        }
        if (!entity.isEverUpdated()) {
            entity.clean();
        }
    }

    public final void removeEntities(Entity ... entitiesToRemove) {
        Intrinsics.checkNotNullParameter((Object)entitiesToRemove, (String)"entitiesToRemove");
        for (Entity e : entitiesToRemove) {
            this.removeEntity(e);
        }
    }

    public final void removeEntities(@NotNull Collection<? extends Entity> entitiesToRemove) {
        Intrinsics.checkNotNullParameter(entitiesToRemove, (String)"entitiesToRemove");
        for (Entity entity : entitiesToRemove) {
            this.removeEntity(entity);
        }
    }

    private final boolean canRemove(Entity entity) {
        return !entity.hasComponent(IrremovableComponent.class);
    }

    public final void onUpdate(double tpf) {
        this.updateList.addAll((Array)this.waitingList);
        this.waitingList.clear();
        Iterator iterator = this.updateList.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"updateList.iterator()");
        Iterator it = iterator;
        while (it.hasNext()) {
            Entity e = (Entity)it.next();
            if (!e.isActive()) {
                e.clean();
                it.remove();
                continue;
            }
            Double tpfRatio2 = e.getComponentOptional(TimeComponent.class).map(arg_0 -> GameWorld.onUpdate$lambda$1(onUpdate.tpfRatio.1.INSTANCE, arg_0)).orElse(1.0);
            Intrinsics.checkNotNullExpressionValue((Object)tpfRatio2, (String)"tpfRatio");
            e.update(tpf * tpfRatio2);
        }
    }

    public final void reset() {
        Entity e;
        log.debug("Clearing game world");
        this.waitingList.clear();
        GameWorld $this$reset_u24lambda_u242 = this;
        boolean bl = false;
        Iterator iterator = $this$reset_u24lambda_u242.updateList.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"updateList.iterator()");
        Iterator it = iterator;
        while (it.hasNext()) {
            e = (Entity)it.next();
            if (!e.isActive()) {
                e.clean();
            }
            it.remove();
        }
        Iterable $this$forEach$iv = this.getEntitiesCopy();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            e = (Entity)element$iv;
            boolean bl2 = false;
            e.markForRemoval();
            this.notifyEntityRemoved(e);
            e.clean();
        }
        this.properties.clear();
        this.entities.clear();
        this.entityFactories.clear();
        this.entitySpawners.clear();
        this.worldListeners.clear();
    }

    public final void addWorldListener(@NotNull EntityWorldListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.worldListeners.add((Object)listener);
    }

    public final void removeWorldListener(@NotNull EntityWorldListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.worldListeners.removeValueByIdentity((Object)listener);
    }

    private final void notifyEntityAdded(Entity e) {
        Iterable $this$forEach$iv = (Iterable)this.worldListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityWorldListener it = (EntityWorldListener)element$iv;
            boolean bl = false;
            it.onEntityAdded(e);
        }
    }

    private final void notifyEntityRemoved(Entity e) {
        Iterable $this$forEach$iv = (Iterable)this.worldListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityWorldListener it = (EntityWorldListener)element$iv;
            boolean bl = false;
            it.onEntityRemoved(e);
        }
    }

    public final void setLevel(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        this.clearLevel();
        log.debug("Setting level: " + level);
        Iterable $this$forEach$iv = level.getEntities();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity it = (Entity)element$iv;
            boolean bl = false;
            this.addEntity(it);
        }
    }

    private final void clearLevel() {
        log.debug("Clearing removable entities");
        CollectionsKt.removeAll((Iterable)((Iterable)this.waitingList), (Function1)((Function1)new Function1<Entity, Boolean>(this){
            final /* synthetic */ GameWorld this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Entity it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return GameWorld.access$canRemove(this.this$0, it);
            }
        }));
        GameWorld $this$clearLevel_u24lambda_u247 = this;
        boolean bl = false;
        Iterator iterator = $this$clearLevel_u24lambda_u247.updateList.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"updateList.iterator()");
        Iterator it = iterator;
        while (it.hasNext()) {
            Entity e = (Entity)it.next();
            Intrinsics.checkNotNullExpressionValue((Object)e, (String)"e");
            if (!$this$clearLevel_u24lambda_u247.canRemove(e)) continue;
            if (!e.isActive()) {
                e.clean();
            }
            it.remove();
        }
        Iterator<Entity> iterator2 = this.entities.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"entities.iterator()");
        Iterator<Entity> it2 = iterator2;
        while (it2.hasNext()) {
            Entity e;
            Intrinsics.checkNotNullExpressionValue((Object)it2.next(), (String)"it.next()");
            if (!this.canRemove(e)) continue;
            e.markForRemoval();
            this.notifyEntityRemoved(e);
            e.clean();
            it2.remove();
        }
    }

    public final void addEntityFactory(@NotNull EntityFactory entityFactory) {
        Intrinsics.checkNotNullParameter((Object)entityFactory, (String)"entityFactory");
        ArrayList<String> entityNames = new ArrayList<String>();
        ReflectionUtils.findMethodsMapToFunctions((Object)entityFactory, Spawns.class).forEach((arg_0, arg_1) -> GameWorld.addEntityFactory$lambda$8((Function2)new Function2<Spawns, Function<SpawnData, Entity>, Unit>(this, entityFactory, entityNames){
            final /* synthetic */ GameWorld this$0;
            final /* synthetic */ EntityFactory $entityFactory;
            final /* synthetic */ ArrayList<String> $entityNames;
            {
                this.this$0 = $receiver;
                this.$entityFactory = $entityFactory;
                this.$entityNames = $entityNames;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(Spawns annotation, Function<SpawnData, Entity> entitySpawner) {
                void $this$forEach$iv;
                Object object = annotation.value();
                Object object2 = new Regex(",");
                int n = 0;
                List entityAliases = object2.split((CharSequence)object, n);
                object = entityAliases;
                object2 = this.this$0;
                EntityFactory entityFactory = this.$entityFactory;
                ArrayList<String> arrayList = this.$entityNames;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String entityName = (String)element$iv;
                    boolean bl = false;
                    GameWorld.access$checkDuplicateSpawners((GameWorld)object2, entityFactory, entityName);
                    GameWorld.access$getEntitySpawners$p((GameWorld)object2).put(entityName, entitySpawner);
                    arrayList.add(entityName);
                }
            }
        }, arg_0, arg_1));
        this.entityFactories.put(entityFactory, entityNames);
    }

    private final void checkDuplicateSpawners(EntityFactory entityFactory, String entityName) {
        if (this.entitySpawners.containsKey(entityName)) {
            Object v1;
            block2: {
                Set<Map.Entry<EntityFactory, List<String>>> set = this.entityFactories.entrySet();
                Intrinsics.checkNotNullExpressionValue(set, (String)"entityFactories.entries");
                Iterable iterable = set;
                for (Object t : iterable) {
                    Map.Entry it = (Map.Entry)t;
                    boolean bl = false;
                    if (!((List)it.getValue()).contains(entityName)) continue;
                    v1 = t;
                    break block2;
                }
                v1 = null;
            }
            Map.Entry factory = v1;
            throw new IllegalArgumentException("Duplicated @Spawns(" + entityName + ") in " + entityFactory + ". Already exists in " + factory);
        }
    }

    public final void removeEntityFactory(@NotNull EntityFactory entityFactory) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)entityFactory, (String)"entityFactory");
            List<String> list = this.entityFactories.remove(entityFactory);
            if (list == null) break block1;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                this.entitySpawners.remove(it);
            }
        }
    }

    @NotNull
    public final Entity spawn(@NotNull String entityName) {
        Intrinsics.checkNotNullParameter((Object)entityName, (String)"entityName");
        return this.spawn(entityName, 0.0, 0.0);
    }

    @NotNull
    public final Entity spawn(@NotNull String entityName, @NotNull Point2D position) {
        Intrinsics.checkNotNullParameter((Object)entityName, (String)"entityName");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return this.spawn(entityName, position.getX(), position.getY());
    }

    @NotNull
    public final Entity spawn(@NotNull String entityName, double x, double y) {
        Intrinsics.checkNotNullParameter((Object)entityName, (String)"entityName");
        return this.spawn(entityName, new SpawnData(x, y, 0.0, 4, null));
    }

    @NotNull
    public final Entity spawn(@NotNull String entityName, @NotNull SpawnData data) {
        Intrinsics.checkNotNullParameter((Object)entityName, (String)"entityName");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Entity entity = this.create(entityName, data);
        this.addEntity(entity);
        return entity;
    }

    @NotNull
    public final Entity create(@NotNull String entityName, @NotNull SpawnData data) {
        Intrinsics.checkNotNullParameter((Object)entityName, (String)"entityName");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!(!((Map)this.entityFactories).isEmpty())) {
            boolean $i$a$-check-GameWorld$create$22 = false;
            String $i$a$-check-GameWorld$create$22 = "No EntityFactory was added! Call gameWorld.addEntityFactory()";
            throw new IllegalStateException($i$a$-check-GameWorld$create$22.toString());
        }
        Function<SpawnData, Entity> function = this.entitySpawners.get(entityName);
        if (function == null) {
            throw new IllegalArgumentException("No EntityFactory has a method annotated @Spawns(" + entityName + ")");
        }
        Function<SpawnData, Entity> spawner = function;
        Entity pooledEntity = this.pool.take(entityName);
        if (pooledEntity != null) {
            pooledEntity.setPosition3D(data.getX(), data.getY(), data.getZ());
            return pooledEntity;
        }
        if (!data.hasKey("type")) {
            data.put("type", entityName);
        }
        data.put("spawnName", entityName);
        Object object = DSLKt.tryCatchRoot((Function0)((Function0)new Function0<Entity>(spawner, data){
            final /* synthetic */ Function<SpawnData, Entity> $spawner;
            final /* synthetic */ SpawnData $data;
            {
                this.$spawner = $spawner;
                this.$data = $data;
                super(0);
            }

            @NotNull
            public final Entity invoke() {
                return this.$spawner.apply(this.$data);
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"data: SpawnData): Entity\u2026t { spawner.apply(data) }");
        return (Entity)object;
    }

    @NotNull
    public final Entity getSingleton(@NotNull Enum<?> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return this.getSingleton(arg_0 -> GameWorld.getSingleton$lambda$12(type, arg_0));
    }

    @NotNull
    public final Entity getSingleton(@NotNull Predicate<Entity> predicate) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Iterable iterable = this.entities;
            for (Object t : iterable) {
                Entity it = (Entity)t;
                boolean bl = false;
                if (!predicate.test(it)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        Entity entity = v0;
        if (entity == null) {
            throw new NoSuchElementException("No entity found satisfying the predicate");
        }
        return entity;
    }

    @NotNull
    public final Optional<Entity> getSingletonOptional(@NotNull Enum<?> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return this.getSingletonOptional(arg_0 -> GameWorld.getSingletonOptional$lambda$14(type, arg_0));
    }

    @NotNull
    public final Optional<Entity> getSingletonOptional(@NotNull Predicate<Entity> predicate) {
        Object t;
        block1: {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Iterable iterable = this.entities;
            for (Object t2 : iterable) {
                Entity it = (Entity)t2;
                boolean bl = false;
                if (!predicate.test(it)) continue;
                t = t2;
                break block1;
            }
            t = null;
        }
        Optional<Object> optional = Optional.ofNullable(t);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(entities.find { predicate.test(it) })");
        return optional;
    }

    @NotNull
    public final Optional<Entity> getRandom(@NotNull Enum<?> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Enum[] enumArray = new Enum[]{type};
        Optional optional = FXGLMath.random(this.getEntitiesByType(enumArray));
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"random(getEntitiesByType(type))");
        return optional;
    }

    @NotNull
    public final Optional<Entity> getRandom(@NotNull Predicate<Entity> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Optional optional = FXGLMath.random(this.getEntitiesFiltered(predicate));
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"random(getEntitiesFiltered(predicate))");
        return optional;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getEntitiesByComponent(@NotNull Class<? extends Component> type) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Iterable $this$filter$iv = this.entities;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            boolean bl = false;
            if (!it.hasComponent(type)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T extends Component> Map<Entity, T> getEntitiesByComponentMapped(@NotNull Class<T> type) {
        Entity it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Iterable $this$filter$iv = this.entities;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Entity)element$iv$iv;
            boolean bl = false;
            if (!it.hasComponent(type)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associateWith$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            it = (Entity)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            T t2 = it.getComponent(type);
            map.put(t, t2);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getEntitiesFiltered(@NotNull Predicate<Entity> predicate) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Iterable $this$filter$iv = this.entities;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            boolean bl = false;
            if (!predicate.test(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getEntitiesByType(Enum<?> ... types) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(types, (String)"types");
        if (types.length == 0) {
            return this.getEntitiesCopy();
        }
        Iterable $this$filter$iv = this.entities;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            boolean bl = false;
            if (!this.isOneOfTypes(it, Arrays.copyOf(types, types.length))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isOneOfTypes(Entity entity, Enum<?> ... types) {
        boolean bl;
        block1: {
            Enum<?>[] $this$any$iv = types;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                Enum<?> element$iv;
                Enum<?> it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!entity.isType(it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getEntitiesInRange(@NotNull Rectangle2D selection) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Iterable $this$filter$iv = this.entities;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            boolean bl = false;
            if (!it.getBoundingBoxComponent().isWithin(selection)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getCollidingEntities(@NotNull Entity entity) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Iterable $this$filter$iv = this.entities;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            boolean bl = false;
            if (!(it.isColliding(entity) && it != entity)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getEntitiesAt(@NotNull Point2D position) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Iterable $this$filter$iv = this.entities;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getPosition(), (Object)position)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Optional<Entity> getClosestEntity(@NotNull Entity entity, @NotNull Predicate<Entity> filter) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        Iterable $this$filter$iv = this.entities;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            boolean bl = false;
            if (!(filter.test(it) && it != entity)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        Optional<Object> optional = Optional.ofNullable(CollectionsKt.firstOrNull((List)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(entity){
            final /* synthetic */ Entity $entity$inlined;
            {
                this.$entity$inlined = entity;
            }

            public final int compare(T a, T b) {
                Entity it = (Entity)a;
                boolean bl = false;
                Comparable comparable = Double.valueOf(this.$entity$inlined.distance(it));
                it = (Entity)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(this.$entity$inlined.distance(it)));
            }
        })));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(\n            \u2026 .firstOrNull()\n        )");
        return optional;
    }

    @NotNull
    public final Optional<Entity> getEntityByID(@NotNull String name, int id) {
        Object t;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable iterable = this.getEntitiesByComponent(IDComponent.class);
            for (Object t2 : iterable) {
                Entity it = (Entity)t2;
                boolean bl = false;
                IDComponent idComponent = it.getComponent(IDComponent.class);
                if (!(Intrinsics.areEqual((Object)idComponent.getName(), (Object)name) && idComponent.getId() == id)) continue;
                t = t2;
                break block1;
            }
            t = null;
        }
        Optional<Object> optional = Optional.ofNullable(t);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(\n            \u2026              }\n        )");
        return optional;
    }

    @NotNull
    public final EntityGroup getGroup(Enum<?> ... entityTypes) {
        Intrinsics.checkNotNullParameter(entityTypes, (String)"entityTypes");
        return new EntityGroup(this, this.getEntitiesByType(Arrays.copyOf(entityTypes, entityTypes.length)), Arrays.copyOf(entityTypes, entityTypes.length));
    }

    private static final void removeEntity$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Double onUpdate$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Double)$tmp0.invoke(p0);
    }

    private static final void addEntityFactory$lambda$8(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final boolean getSingleton$lambda$12(Enum $type, Entity it) {
        Intrinsics.checkNotNullParameter((Object)$type, (String)"$type");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isType($type);
    }

    private static final boolean getSingletonOptional$lambda$14(Enum $type, Entity it) {
        Intrinsics.checkNotNullParameter((Object)$type, (String)"$type");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isType($type);
    }

    public static final /* synthetic */ EntityPool access$getPool$p(GameWorld $this) {
        return $this.pool;
    }

    public static final /* synthetic */ boolean access$canRemove(GameWorld $this, Entity entity) {
        return $this.canRemove(entity);
    }

    public static final /* synthetic */ void access$checkDuplicateSpawners(GameWorld $this, EntityFactory entityFactory, String entityName) {
        $this.checkDuplicateSpawners(entityFactory, entityName);
    }

    public static final /* synthetic */ HashMap access$getEntitySpawners$p(GameWorld $this) {
        return $this.entitySpawners;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/almasb/fxgl/entity/GameWorld$Companion;", "", "()V", "log", "Lcom/almasb/fxgl/logging/Logger;", "fxgl-entity"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

