/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class FieldUtils {
    private static Pattern humpPattern = Pattern.compile("[A-Z]");

    public static List<String> allTableFields(Class clazz) {
        return FieldUtils.allFields(clazz).stream().map(item -> FieldUtils.humpToLine2(item.getName())).collect(Collectors.toList());
    }

    public static List<String> allNameParamsFields(Class clazz) {
        return FieldUtils.allFields(clazz).stream().map(item -> ":" + item.getName()).collect(Collectors.toList());
    }

    public static List<Field> allFields(Class clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(clazz.getSuperclass().getDeclaredFields()));
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        return fields;
    }

    public static String underlineToCamel(String name) {
        boolean allUpper = true;
        boolean allLower = true;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isLowerCase(c)) {
                allUpper = false;
                continue;
            }
            if (!Character.isUpperCase(c)) continue;
            allLower = false;
        }
        if (allUpper) {
            name = name.toLowerCase();
            allLower = true;
        }
        if (!allLower) {
            return name;
        }
        StringBuilder sb = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if ('_' == c) {
                if (++i >= name.length()) continue;
                sb.append(Character.toUpperCase(name.charAt(i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String humpToLine2(String str) {
        Matcher matcher = humpPattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

