/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.alenfive.rocketapi.entity.vo.LoginVo;
import com.github.alenfive.rocketapi.extend.IUserAuthorization;
import java.io.IOException;
import java.util.Base64;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class LoginService {
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private IUserAuthorization userAuthorization;
    private static final String rocketUserToken = "rocket-user-token";

    public String getUser(HttpServletRequest request) {
        String token = request.getHeader(rocketUserToken);
        return this.getUser(token);
    }

    public String getUser(String token) {
        if (StringUtils.isEmpty((Object)token)) {
            return null;
        }
        try {
            LoginVo loginVo = (LoginVo)this.objectMapper.readValue(Base64.getDecoder().decode(token), LoginVo.class);
            String user = this.userAuthorization.validate(loginVo.getUsername(), loginVo.getPassword());
            return user;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getToken(LoginVo loginVo) throws JsonProcessingException {
        String user = this.userAuthorization.validate(loginVo.getUsername(), loginVo.getPassword());
        if (StringUtils.isEmpty((Object)user)) {
            return null;
        }
        String token = new String(Base64.getEncoder().encode(this.objectMapper.writeValueAsBytes((Object)loginVo)));
        return token;
    }
}

