/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.alenfive.rocketapi.config.RocketApiProperties;
import com.github.alenfive.rocketapi.datasource.DataSourceDialect;
import com.github.alenfive.rocketapi.datasource.DataSourceManager;
import com.github.alenfive.rocketapi.datasource.factory.IDataSourceDialectDriver;
import com.github.alenfive.rocketapi.entity.ApiConfig;
import com.github.alenfive.rocketapi.entity.ConfigType;
import com.github.alenfive.rocketapi.entity.DBConfig;
import com.github.alenfive.rocketapi.entity.vo.NotifyEntity;
import com.github.alenfive.rocketapi.entity.vo.NotifyEventType;
import com.github.alenfive.rocketapi.entity.vo.RefreshDB;
import com.github.alenfive.rocketapi.extend.IClusterNotify;
import com.github.alenfive.rocketapi.service.ConfigService;
import com.github.alenfive.rocketapi.utils.GenerateId;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class DataSourceService {
    @Autowired
    private DataSourceManager dataSourceManager;
    @Autowired
    private RocketApiProperties rocketApiProperties;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private ConfigService configService;
    @Autowired
    @Lazy
    private IClusterNotify clusterNotify;

    public List<DBConfig> getDBConfig() {
        List<ApiConfig> configList = this.dataSourceManager.getStoreApiDataSource().listByEntity(ApiConfig.builder().service(this.rocketApiProperties.getServiceName()).type(ConfigType.DB.name()).build());
        return configList.stream().map(item -> {
            try {
                DBConfig dbConfig = (DBConfig)this.objectMapper.readValue(item.getConfigContext(), DBConfig.class);
                return dbConfig;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }).collect(Collectors.toList());
    }

    public DBConfig getDBConfigById(String id) throws IOException {
        ApiConfig apiConfig = this.configService.getConfigById(id);
        return (DBConfig)this.objectMapper.readValue(apiConfig.getConfigContext(), DBConfig.class);
    }

    private DBConfig getDBConfigByName(String name) {
        return this.getDBConfig().stream().filter(item -> item.getName().equals(name)).findFirst().orElse(null);
    }

    @Transactional
    public void deleteDBConfig(DBConfig dbConfig) throws IOException {
        dbConfig = this.getDBConfigById(dbConfig.getId());
        this.closeDBConfig(dbConfig);
        this.configService.removeConfigById(dbConfig.getId());
        RefreshDB refreshDB = RefreshDB.builder().oldDBName(dbConfig.getName()).build();
        this.clusterNotify.sendNotify(NotifyEntity.builder().eventType(NotifyEventType.RefreshDB).refreshDB(refreshDB).build());
    }

    private void assertDBConfigName(String dbName, String dbId) {
        List<DBConfig> dbList = this.getDBConfig();
        for (DBConfig dbConfig : dbList) {
            if (!dbConfig.getName().equals(dbName) || dbConfig.getId().equals(dbId)) continue;
            throw new IllegalArgumentException("name:" + dbName + " already exist");
        }
    }

    @Transactional
    public String saveDBConfig(DBConfig dbConfig) throws Exception {
        ApiConfig apiConfig = ApiConfig.builder().service(this.rocketApiProperties.getServiceName()).type(ConfigType.DB.name()).build();
        this.assertDBConfigName(dbConfig.getName(), dbConfig.getId());
        DBConfig oldDBConfig = null;
        if (StringUtils.isEmpty((Object)dbConfig.getId())) {
            dbConfig.setId(GenerateId.get().toHexString());
            apiConfig.setId(dbConfig.getId());
            apiConfig.setConfigContext(this.objectMapper.writeValueAsString((Object)dbConfig));
            this.dataSourceManager.getStoreApiDataSource().saveEntity(apiConfig);
            this.loadDBConfig(dbConfig);
        } else {
            oldDBConfig = this.getDBConfigById(dbConfig.getId());
            this.closeDBConfig(oldDBConfig);
            this.loadDBConfig(dbConfig);
            apiConfig.setId(dbConfig.getId());
            apiConfig.setConfigContext(this.objectMapper.writeValueAsString((Object)dbConfig));
            this.dataSourceManager.getStoreApiDataSource().updateEntityById(apiConfig);
        }
        RefreshDB refreshDB = RefreshDB.builder().newDBName(dbConfig.getName()).build();
        if (oldDBConfig != null) {
            refreshDB.setOldDBName(oldDBConfig.getName());
        }
        this.clusterNotify.sendNotify(NotifyEntity.builder().eventType(NotifyEventType.RefreshDB).refreshDB(refreshDB).build());
        return dbConfig.getId();
    }

    public void testDBConfig(DBConfig config) throws Exception {
        IDataSourceDialectDriver factory = (IDataSourceDialectDriver)Class.forName(config.getDriver()).newInstance();
        DataSourceDialect dialect = factory.factory(config);
        dialect.close();
    }

    private void closeDBConfig(DBConfig config) {
        DataSourceDialect dataSourceDialect = this.dataSourceManager.getDialectMap().remove(config.getName());
        if (dataSourceDialect == null) {
            return;
        }
        dataSourceDialect.close();
    }

    private void loadDBConfig(DBConfig config) throws Exception {
        if (!config.isEnabled()) {
            return;
        }
        IDataSourceDialectDriver factory = (IDataSourceDialectDriver)Class.forName(config.getDriver()).newInstance();
        DataSourceDialect dialect = factory.factory(config);
        dialect.setDynamic(true);
        this.dataSourceManager.getDialectMap().put(config.getName(), dialect);
    }

    public void reLoadDBConfig(Boolean isStart) throws Exception {
        Set<String> oldDBList = this.dataSourceManager.getDialectMap().keySet();
        for (String oldDBName : oldDBList) {
            if (!this.dataSourceManager.getDialectMap().get(oldDBName).isDynamic()) continue;
            this.closeDBConfig(DBConfig.builder().name(oldDBName).build());
            if (isStart.booleanValue()) continue;
            RefreshDB refreshDB = RefreshDB.builder().oldDBName(oldDBName).build();
            this.clusterNotify.sendNotify(NotifyEntity.builder().eventType(NotifyEventType.RefreshDB).refreshDB(refreshDB).build());
        }
        List<DBConfig> newDBList = this.getDBConfig();
        for (DBConfig dbConfig : newDBList) {
            this.loadDBConfig(dbConfig);
            if (isStart.booleanValue()) continue;
            RefreshDB refreshDB = RefreshDB.builder().newDBName(dbConfig.getName()).build();
            this.clusterNotify.sendNotify(NotifyEntity.builder().eventType(NotifyEventType.RefreshDB).refreshDB(refreshDB).build());
        }
    }

    public void refreshDB(RefreshDB refreshDB) throws Exception {
        DBConfig newDBConfig;
        if (!StringUtils.isEmpty((Object)refreshDB.getOldDBName())) {
            this.closeDBConfig(DBConfig.builder().name(refreshDB.getOldDBName()).build());
        }
        if (!StringUtils.isEmpty((Object)refreshDB.getNewDBName()) && (newDBConfig = this.getDBConfigByName(refreshDB.getNewDBName())) != null) {
            this.loadDBConfig(newDBConfig);
        }
    }
}

