/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.script;

import com.github.alenfive.rocketapi.config.RocketApiProperties;
import com.github.alenfive.rocketapi.datasource.DataSourceDialect;
import com.github.alenfive.rocketapi.datasource.DataSourceManager;
import com.github.alenfive.rocketapi.datasource.DialectTransactionManager;
import com.github.alenfive.rocketapi.entity.ApiInfo;
import com.github.alenfive.rocketapi.entity.ApiParams;
import com.github.alenfive.rocketapi.extend.ApiInfoContent;
import com.github.alenfive.rocketapi.function.IFunction;
import com.github.alenfive.rocketapi.script.IScriptParse;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class GroovyScriptParse
implements IScriptParse {
    @Autowired
    private ApiInfoContent apiInfoContent;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private RocketApiProperties rocketApiProperties;
    @Autowired(required=false)
    private TransactionDefinition transactionDefinition;
    @Autowired
    private DataSourceManager dataSourceManager;
    private Collection<IFunction> functionList;
    private ScriptEngineManager factory = new ScriptEngineManager();
    private ScriptEngine engine = null;
    private Pattern selectSqlPattern = Pattern.compile("^(\\s*select\\s+)", 2);
    private Pattern insertSqlPattern = Pattern.compile("^(\\s*(replace|insert)\\s+into\\s+)", 2);
    private Pattern updateSqlPattern = Pattern.compile("^(\\s*update\\s+[A-Za-z\\-0-9_]+\\s+set )", 2);
    private Pattern deleteSqlPattern = Pattern.compile("^(\\s*delete\\s+from\\s+[A-Za-z\\-0-9_]+)", 2);

    @PostConstruct
    public void init() {
        this.engine = this.factory.getEngineByName("groovy");
        this.functionList = this.context.getBeansOfType(IFunction.class).values();
    }

    @Override
    public Object runScript(String script, ApiInfo apiInfo, ApiParams apiParams) throws Throwable {
        DataSourceDialect dialect = this.dataSourceManager.getDialectMap().get(apiInfo.getDatasource());
        PlatformTransactionManager transactionManager = null;
        if (dialect instanceof DialectTransactionManager) {
            transactionManager = ((DialectTransactionManager)((Object)dialect)).getTransactionManager();
        }
        TransactionStatus transactionStatus = null;
        try {
            script = this.buildSQLScript(script, apiInfo);
            this.apiInfoContent.setApiInfo(apiInfo);
            this.apiInfoContent.setApiParams(apiParams);
            SimpleBindings bindings = new SimpleBindings();
            this.apiInfoContent.setEngineBindings(bindings);
            for (IFunction function : this.functionList) {
                bindings.put(function.getVarName(), (Object)function);
            }
            this.buildScriptParams(bindings, apiParams);
            if (transactionManager != null) {
                transactionStatus = transactionManager.getTransaction(this.transactionDefinition);
            }
            Object result = this.engineEval(script, bindings);
            if (transactionManager != null) {
                transactionManager.commit(transactionStatus);
            }
            return result;
        }
        catch (Exception e) {
            if (transactionStatus != null) {
                transactionManager.rollback(transactionStatus);
            }
            if (e.getCause() != null && e.getCause().getCause() != null) {
                throw e.getCause().getCause();
            }
            throw e;
        }
    }

    private String buildSQLScript(String script, ApiInfo apiInfo) {
        String func = null;
        if (this.selectSqlPattern.matcher(script = script.trim()).find()) {
            func = apiInfo.getFullPath().endsWith(this.rocketApiProperties.getSqlModel().getPagerSuffix()) ? "pager" : (apiInfo.getFullPath().endsWith(this.rocketApiProperties.getSqlModel().getFindOneSuffix()) ? "findOne" : (apiInfo.getFullPath().endsWith(this.rocketApiProperties.getSqlModel().getCountSuffix()) ? "count" : "find"));
        } else if (this.insertSqlPattern.matcher(script).find()) {
            func = "insert";
        } else if (this.deleteSqlPattern.matcher(script).find()) {
            func = "remove";
        } else if (this.updateSqlPattern.matcher(script).find()) {
            func = "update";
        }
        if (func == null) {
            return script;
        }
        StringBuilder sb = new StringBuilder("db.").append(func).append("('''").append(script).append("''');");
        return sb.toString();
    }

    @Override
    public Object engineEval(String script, Bindings bindings) throws Throwable {
        try {
            return this.engine.eval(script, bindings);
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause().getCause() != null) {
                throw e.getCause().getCause();
            }
            throw e;
        }
    }

    private void buildScriptParams(Bindings bindings, ApiParams apiParams) {
        bindings.put("pathVar", (Object)apiParams.getPathVar());
        bindings.put("param", (Object)apiParams.getParam());
        bindings.put("body", (Object)apiParams.getBody());
        bindings.put("header", (Object)apiParams.getHeader());
        bindings.put("cookie", (Object)apiParams.getCookie());
        bindings.put("session", (Object)apiParams.getSession());
        bindings.put("request", (Object)apiParams.getRequest());
        bindings.put("response", (Object)apiParams.getResponse());
        if (!CollectionUtils.isEmpty(apiParams.getSession())) {
            apiParams.getSession().forEach((key, value) -> {
                if (StringUtils.isEmpty((Object)key)) {
                    return;
                }
                bindings.put((String)key, value);
            });
        }
        if (!CollectionUtils.isEmpty(apiParams.getCookie())) {
            apiParams.getCookie().forEach((key, value) -> {
                if (StringUtils.isEmpty((Object)key)) {
                    return;
                }
                bindings.put((String)key, value);
            });
        }
        if (!CollectionUtils.isEmpty(apiParams.getHeader())) {
            apiParams.getHeader().forEach((key, value) -> {
                if (StringUtils.isEmpty((Object)key)) {
                    return;
                }
                bindings.put((String)key, value);
            });
        }
        if (!CollectionUtils.isEmpty(apiParams.getBody())) {
            apiParams.getBody().forEach((key, value) -> {
                if (StringUtils.isEmpty((Object)key)) {
                    return;
                }
                bindings.put((String)key, value);
            });
        }
        if (!CollectionUtils.isEmpty(apiParams.getParam())) {
            apiParams.getParam().forEach((key, value) -> {
                if (StringUtils.isEmpty((Object)key)) {
                    return;
                }
                bindings.put((String)key, value);
            });
        }
        if (!CollectionUtils.isEmpty(apiParams.getPathVar())) {
            apiParams.getPathVar().forEach((key, value) -> {
                if (StringUtils.isEmpty((Object)key)) {
                    return;
                }
                bindings.put((String)key, value);
            });
        }
    }
}

