/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.function;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.alenfive.rocketapi.entity.ApiInfo;
import com.github.alenfive.rocketapi.entity.ApiType;
import com.github.alenfive.rocketapi.entity.vo.IgnoreWrapper;
import com.github.alenfive.rocketapi.extend.ApiInfoContent;
import com.github.alenfive.rocketapi.extend.IApiInfoCache;
import com.github.alenfive.rocketapi.extend.IScriptEncrypt;
import com.github.alenfive.rocketapi.function.IFunction;
import com.github.alenfive.rocketapi.script.IScriptParse;
import com.github.alenfive.rocketapi.service.ScriptParseService;
import com.github.alenfive.rocketapi.utils.CsvUtils;
import com.github.alenfive.rocketapi.utils.ExcelUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

@Component
public class UtilsFunction
implements IFunction {
    @Autowired
    private ApiInfoContent apiInfoContent;
    @Autowired
    private ScriptParseService scriptParseService;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private IApiInfoCache apiInfoCache;
    @Autowired
    private IScriptEncrypt scriptEncrypt;
    @Autowired
    @Lazy
    private IScriptParse scriptParse;

    @Override
    public String getVarName() {
        return "Utils";
    }

    public Object val(String varName) {
        return this.scriptParseService.buildRequestScopeParamItem(this.apiInfoContent.getApiParams(), null, varName);
    }

    public Object val(String varName, Object defaultValue) {
        return Optional.ofNullable(this.val(varName)).orElse(defaultValue);
    }

    public IgnoreWrapper ignoreWrapper(Object data) {
        return new IgnoreWrapper(data);
    }

    public ResponseEntity<InputStreamResource> download(String fileName, InputStream inputStream) throws IOException {
        String suffix = fileName.substring(fileName.lastIndexOf("."));
        String prefix = fileName.substring(0, fileName.indexOf("."));
        HttpHeaders headers = new HttpHeaders();
        headers.setContentDisposition(ContentDisposition.parse((String)("attachment; filename=" + URLEncoder.encode(prefix, "utf-8") + suffix)));
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        InputStreamResource inputStreamResource = new InputStreamResource(inputStream);
        return new ResponseEntity((Object)inputStreamResource, (MultiValueMap)headers, HttpStatus.OK);
    }

    public ResponseEntity<InputStreamResource> preview(InputStream inputStream) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.IMAGE_JPEG);
        InputStreamResource inputStreamResource = new InputStreamResource(inputStream);
        return new ResponseEntity((Object)inputStreamResource, (MultiValueMap)headers, HttpStatus.OK);
    }

    public ResponseEntity<InputStreamResource> exportCsv(String fileName, Map<String, String> title, List<Map<String, Object>> list) throws IOException {
        ByteArrayInputStream inputStream = CsvUtils.writeCsv(title, list);
        return this.download(fileName + ".csv", inputStream);
    }

    public ResponseEntity<InputStreamResource> exportCsv(String fileName, List<Map<String, Object>> list) throws IOException {
        LinkedHashMap<String, String> title = new LinkedHashMap<String, String>();
        if (list.size() > 0) {
            list.get(0).keySet().stream().forEach(item -> title.put((String)item, (String)item));
        }
        return this.exportCsv(fileName, title, list);
    }

    public ResponseEntity<InputStreamResource> exportXls(String fileName, Map<String, String> title, List<Map<String, Object>> list) throws IOException {
        ByteArrayInputStream inputStream = ExcelUtils.writeXls(title, list);
        return this.download(fileName + ".xls", inputStream);
    }

    public ResponseEntity<InputStreamResource> exportXls(String fileName, List<Map<String, Object>> list) throws IOException {
        LinkedHashMap<String, String> title = new LinkedHashMap<String, String>();
        if (list.size() > 0) {
            list.get(0).keySet().stream().forEach(item -> title.put((String)item, (String)item));
        }
        return this.exportXls(fileName, title, list);
    }

    public List<Map<String, String>> parseXls(InputStream in) throws IOException {
        return ExcelUtils.parseXls(in);
    }

    public List<Map<String, String>> parseCsv(List<String> titles, InputStream in) throws IOException {
        return CsvUtils.parseCsv(titles, in);
    }

    public List<Map<String, String>> parseCsv(InputStream in) throws IOException {
        return CsvUtils.parseCsv(in);
    }

    public List<Map<String, String>> parseXlsx(InputStream in) throws IOException {
        return ExcelUtils.parseXlsx(in);
    }

    public ResponseEntity<InputStreamResource> exportXlsx(String fileName, Map<String, String> title, List<Map<String, Object>> list) throws IOException {
        ByteArrayInputStream inputStream = ExcelUtils.writeXlsx(title, list);
        return this.download(fileName + ".xlsx", inputStream);
    }

    public ResponseEntity<InputStreamResource> exportXlsx(String fileName, List<Map<String, Object>> list) throws IOException {
        LinkedHashMap<String, String> title = new LinkedHashMap<String, String>();
        if (list.size() > 0) {
            list.get(0).keySet().stream().forEach(item -> title.put((String)item, (String)item));
        }
        return this.exportXlsx(fileName, title, list);
    }

    public String pasreToString(Object obj) throws JsonProcessingException {
        return this.objectMapper.writeValueAsString(obj);
    }

    public Object pasreToObject(String str) throws IOException {
        return this.objectMapper.readValue(str, Object.class);
    }

    public Object loadAPI(String target) throws Throwable {
        if (StringUtils.isEmpty((Object)target)) {
            throw new IllegalArgumentException("parameter `target` is empty");
        }
        String[] targetArr = target.split(":");
        if (targetArr.length != 2) {
            throw new IllegalArgumentException("parameter `target` needs to \"GET:/test/pager\"");
        }
        String method = targetArr[0];
        String fullPath = targetArr[1];
        ApiInfo apiInfo = this.apiInfoCache.get(ApiInfo.builder().method(method).fullPath(fullPath).build());
        if (apiInfo == null || !ApiType.Ql.name().equals(apiInfo.getType())) {
            throw new IllegalArgumentException("API not found " + target);
        }
        StringBuilder script = new StringBuilder(this.scriptEncrypt.decrypt(apiInfo.getScript()));
        return this.scriptParse.engineEval(script.toString(), this.apiInfoContent.getEngineBindings());
    }
}

