/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.function;

import com.github.alenfive.rocketapi.datasource.DataSourceDialect;
import com.github.alenfive.rocketapi.datasource.DataSourceManager;
import com.github.alenfive.rocketapi.entity.vo.Page;
import com.github.alenfive.rocketapi.entity.vo.ScriptContext;
import com.github.alenfive.rocketapi.extend.ApiInfoContent;
import com.github.alenfive.rocketapi.extend.IApiPager;
import com.github.alenfive.rocketapi.extend.IDBCache;
import com.github.alenfive.rocketapi.extend.ISQLInterceptor;
import com.github.alenfive.rocketapi.function.IFunction;
import com.github.alenfive.rocketapi.function.UtilsFunction;
import com.github.alenfive.rocketapi.service.ScriptParseService;
import com.github.alenfive.rocketapi.utils.LogFormatUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class DbFunction
implements IFunction {
    private static final Logger log = LoggerFactory.getLogger(DbFunction.class);
    @Autowired
    private DataSourceManager dataSourceManager;
    @Autowired
    private ApiInfoContent apiInfoContent;
    @Autowired
    private ScriptParseService parseService;
    @Autowired
    private IApiPager apiPager;
    @Autowired
    private UtilsFunction utilsFunction;
    @Autowired
    private ISQLInterceptor sqlInterceptor;
    @Autowired
    private IDBCache dbCache;
    private String cacheKey;
    private Long cacheTime;

    public DbFunction cache(String cacheKey, Long cacheTime) {
        return new DbFunction(this.dataSourceManager, this.apiInfoContent, this.parseService, this.apiPager, this.utilsFunction, this.sqlInterceptor, this.dbCache, cacheKey, cacheTime);
    }

    public void cacheClear(String cacheKey) {
        this.dbCache.remove(cacheKey);
    }

    @Override
    public String getVarName() {
        return "db";
    }

    private String parseSql(String script) {
        if (script.startsWith("sql")) {
            script = script.substring(3);
        }
        if (script.startsWith("\n")) {
            script = script.substring(1);
        }
        if (script.endsWith("\n")) {
            script = script.substring(0, script.length() - 1);
        }
        return script;
    }

    @Deprecated
    public Long count(String script, String dataSource, Map<String, Object> params) throws Exception {
        List<Map<String, Object>> list = this.find(script = this.parseSql(script), dataSource, params);
        if (CollectionUtils.isEmpty(list)) {
            return 0L;
        }
        if (list.size() > 1) {
            return list.size();
        }
        Object[] fieldValues = list.get(0).values().toArray();
        if (fieldValues.length > 1 || !(fieldValues[0] instanceof Number)) {
            return 1L;
        }
        return Long.valueOf(fieldValues[0].toString());
    }

    @Deprecated
    public Map<String, Object> findOne(String script, String dataSource, Map<String, Object> params) throws Exception {
        List<Map<String, Object>> list = this.find(script = this.parseSql(script), dataSource, params);
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    private void dbFinal(long startTime, StringBuilder sbScript, ScriptContext scriptContext) {
        if (scriptContext == null) {
            return;
        }
        long diff = System.currentTimeMillis() - startTime;
        String logScript = LogFormatUtils.sqlParam(sbScript, this.parseService, scriptContext);
        if (this.apiInfoContent.getIsDebug().booleanValue()) {
            this.apiInfoContent.putLog(String.format("Elapsed Time:%sms , execute script: %s", diff, logScript));
        }
        log.debug("Elapsed Time:{}ms , execute script: {}", (Object)diff, (Object)logScript);
        this.sqlInterceptor.after(sbScript.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public List<Map<String, Object>> find(String script, String datasource, Map<String, Object> params) throws Exception {
        Object value;
        if (this.cacheKey != null && (value = this.dbCache.get(this.cacheKey)) != null) {
            return (List)value;
        }
        script = this.parseSql(script);
        StringBuilder sbScript = new StringBuilder(this.sqlInterceptor.before(script));
        List<Map<String, Object>> result = null;
        long startTime = System.currentTimeMillis();
        ScriptContext scriptContext = null;
        try {
            DataSourceDialect dataSourceDialect = this.dataSourceManager.getDataSourceDialect(this.apiInfoContent.getApiInfo().getDatasource(), datasource);
            scriptContext = this.dataSourceManager.buildScriptContext(sbScript, dataSourceDialect, params);
            result = dataSourceDialect.find(scriptContext);
            this.dbFinal(startTime, sbScript, scriptContext);
        }
        catch (Throwable throwable) {
            this.dbFinal(startTime, sbScript, scriptContext);
            throw throwable;
        }
        if (this.cacheKey != null) {
            this.dbCache.set(this.cacheKey, result, this.cacheTime);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Object insert(String script, String datasource, Map<String, Object> params) throws Exception {
        script = this.parseSql(script);
        StringBuilder sbScript = new StringBuilder(this.sqlInterceptor.before(script));
        Object result = null;
        long startTime = System.currentTimeMillis();
        ScriptContext scriptContext = null;
        try {
            DataSourceDialect dataSourceDialect = this.dataSourceManager.getDataSourceDialect(this.apiInfoContent.getApiInfo().getDatasource(), datasource);
            scriptContext = this.dataSourceManager.buildScriptContext(sbScript, dataSourceDialect, params);
            result = dataSourceDialect.insert(scriptContext);
            this.dbFinal(startTime, sbScript, scriptContext);
        }
        catch (Throwable throwable) {
            this.dbFinal(startTime, sbScript, scriptContext);
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Object remove(String script, String datasource, Map<String, Object> params) throws Exception {
        script = this.parseSql(script);
        StringBuilder sbScript = new StringBuilder(this.sqlInterceptor.before(script));
        Integer result = null;
        long startTime = System.currentTimeMillis();
        ScriptContext scriptContext = null;
        try {
            DataSourceDialect dataSourceDialect = this.dataSourceManager.getDataSourceDialect(this.apiInfoContent.getApiInfo().getDatasource(), datasource);
            scriptContext = this.dataSourceManager.buildScriptContext(sbScript, dataSourceDialect, params);
            result = dataSourceDialect.remove(scriptContext);
            this.dbFinal(startTime, sbScript, scriptContext);
        }
        catch (Throwable throwable) {
            this.dbFinal(startTime, sbScript, scriptContext);
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int update(String script, String datasource, Map<String, Object> params) throws Exception {
        int result;
        script = this.parseSql(script);
        StringBuilder sbScript = new StringBuilder(this.sqlInterceptor.before(script));
        long startTime = System.currentTimeMillis();
        ScriptContext scriptContext = null;
        try {
            DataSourceDialect dataSourceDialect = this.dataSourceManager.getDataSourceDialect(this.apiInfoContent.getApiInfo().getDatasource(), datasource);
            scriptContext = this.dataSourceManager.buildScriptContext(sbScript, dataSourceDialect, params);
            result = dataSourceDialect.update(scriptContext);
            this.dbFinal(startTime, sbScript, scriptContext);
        }
        catch (Throwable throwable) {
            this.dbFinal(startTime, sbScript, scriptContext);
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int[] batchUpdate(String script, String datasource, List<Map<String, Object>> params) throws Exception {
        int[] result;
        script = this.parseSql(script);
        StringBuilder sbScript = new StringBuilder(this.sqlInterceptor.before(script));
        long startTime = System.currentTimeMillis();
        ScriptContext scriptContext = null;
        try {
            DataSourceDialect dataSourceDialect = this.dataSourceManager.getDataSourceDialect(this.apiInfoContent.getApiInfo().getDatasource(), datasource);
            scriptContext = this.dataSourceManager.buildScriptContext(sbScript, dataSourceDialect, params);
            result = dataSourceDialect.batchUpdate(scriptContext);
            this.dbFinal(startTime, sbScript, scriptContext);
        }
        catch (Throwable throwable) {
            this.dbFinal(startTime, sbScript, scriptContext);
            throw throwable;
        }
        return result;
    }

    @Deprecated
    public Object pager(String script, String datasource, Map<String, Object> params) throws Exception {
        Integer pageNo = this.apiPager.getPageNo();
        Integer pageSize = this.apiPager.getPageSize();
        this.apiInfoContent.getEngineBindings().put(this.apiPager.getPageNoVarName(), (Object)pageNo);
        this.apiInfoContent.getEngineBindings().put(this.apiPager.getPageSizeVarName(), (Object)pageSize);
        this.apiInfoContent.getEngineBindings().put(this.apiPager.getOffsetVarName(), (Object)this.apiPager.getOffset(pageSize, pageNo));
        script = this.parseSql(script);
        Page page = Page.builder().pageNo(pageNo).pageSize(pageSize).build();
        DataSourceDialect dataSourceDialect = this.dataSourceManager.getDataSourceDialect(this.apiInfoContent.getApiInfo().getDatasource(), datasource);
        StringBuilder scriptBuilder = new StringBuilder(script);
        params = this.parseService.parse(scriptBuilder, dataSourceDialect, params);
        script = scriptBuilder.toString();
        String totalSql = dataSourceDialect.buildCountScript(script, this.apiPager, page);
        Long total = this.count(totalSql, datasource, params);
        List<Object> data = null;
        if (total > 0L) {
            String pageSql = dataSourceDialect.buildPageScript(script, this.apiPager, page);
            data = this.find(pageSql, datasource, params);
        } else {
            data = Collections.emptyList();
        }
        return this.apiPager.buildPager(total, data, this.apiInfoContent.getApiInfo(), this.apiInfoContent.getApiParams());
    }

    public Object pager(Long total, List list) {
        return this.apiPager.buildPager(total, list, this.apiInfoContent.getApiInfo(), this.apiInfoContent.getApiParams());
    }

    public Integer getPageNo() {
        return this.apiPager.getPageNo();
    }

    public Integer getPageSize() {
        return this.apiPager.getPageSize();
    }

    public Integer getOffset() {
        return this.apiPager.getOffset(this.apiPager.getPageSize(), this.apiPager.getPageNo());
    }

    public Object pager(String script) throws Exception {
        script = this.parseSql(script);
        return this.pager(script, null, null);
    }

    public Long count(String script) throws Exception {
        script = this.parseSql(script);
        return this.count(script, null, null);
    }

    public Map<String, Object> findOne(String script) throws Exception {
        script = this.parseSql(script);
        return this.findOne(script, null, null);
    }

    public List<Map<String, Object>> find(String script) throws Exception {
        script = this.parseSql(script);
        return this.find(script, null, null);
    }

    public Object insert(String script) throws Exception {
        script = this.parseSql(script);
        return this.insert(script, null, null);
    }

    public Object remove(String script) throws Exception {
        script = this.parseSql(script);
        return this.remove(script, null, null);
    }

    public int update(String script) throws Exception {
        script = this.parseSql(script);
        return this.update(script, null, null);
    }

    @Deprecated
    public Object pager(String script, String datasource) throws Exception {
        script = this.parseSql(script);
        return this.pager(script, datasource, null);
    }

    @Deprecated
    public Long count(String script, String datasource) throws Exception {
        script = this.parseSql(script);
        return this.count(script, datasource, null);
    }

    @Deprecated
    public Map<String, Object> findOne(String script, String datasource) throws Exception {
        script = this.parseSql(script);
        return this.findOne(script, datasource, null);
    }

    @Deprecated
    public List<Map<String, Object>> find(String script, String datasource) throws Exception {
        script = this.parseSql(script);
        return this.find(script, datasource, null);
    }

    @Deprecated
    public Object insert(String script, String datasource) throws Exception {
        script = this.parseSql(script);
        return this.insert(script, datasource, null);
    }

    @Deprecated
    public Object remove(String script, String datasource) throws Exception {
        script = this.parseSql(script);
        return this.remove(script, datasource, null);
    }

    @Deprecated
    public int update(String script, String datasource) throws Exception {
        script = this.parseSql(script);
        return this.update(script, datasource, null);
    }

    public Object pager(String script, Map<String, Object> params) throws Exception {
        script = this.parseSql(script);
        return this.pager(script, null, params);
    }

    public Long count(String script, Map<String, Object> params) throws Exception {
        script = this.parseSql(script);
        return this.count(script, null, params);
    }

    public Map<String, Object> findOne(String script, Map<String, Object> params) throws Exception {
        script = this.parseSql(script);
        return this.findOne(script, null, params);
    }

    public List<Map<String, Object>> find(String script, Map<String, Object> params) throws Exception {
        script = this.parseSql(script);
        return this.find(script, null, params);
    }

    public Object insert(String script, Map<String, Object> params) throws Exception {
        script = this.parseSql(script);
        return this.insert(script, null, params);
    }

    public Object remove(String script, Map<String, Object> params) throws Exception {
        script = this.parseSql(script);
        return this.remove(script, null, params);
    }

    public int update(String script, Map<String, Object> params) throws Exception {
        script = this.parseSql(script);
        return this.update(script, null, params);
    }

    public int[] batchUpdate(String script, List<Map<String, Object>> params) throws Exception {
        script = this.parseSql(script);
        return this.batchUpdate(script, null, params);
    }

    public DbFunction(DataSourceManager dataSourceManager, ApiInfoContent apiInfoContent, ScriptParseService parseService, IApiPager apiPager, UtilsFunction utilsFunction, ISQLInterceptor sqlInterceptor, IDBCache dbCache, String cacheKey, Long cacheTime) {
        this.dataSourceManager = dataSourceManager;
        this.apiInfoContent = apiInfoContent;
        this.parseService = parseService;
        this.apiPager = apiPager;
        this.utilsFunction = utilsFunction;
        this.sqlInterceptor = sqlInterceptor;
        this.dbCache = dbCache;
        this.cacheKey = cacheKey;
        this.cacheTime = cacheTime;
    }

    public DbFunction() {
    }
}

