/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.extend;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.alenfive.rocketapi.config.RocketApiProperties;
import com.github.alenfive.rocketapi.entity.ApiInfo;
import com.github.alenfive.rocketapi.extend.IApiInfoCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.ConvertingCursor;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;

public class RedisApiInfoCache
implements IApiInfoCache {
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private RocketApiProperties rocketApiProperties;

    private String buildPrefix() {
        return "rocket-api:" + this.rocketApiProperties.getServiceName();
    }

    private String buildApiInfoKey(ApiInfo apiInfo) {
        return this.buildPrefix() + ":" + apiInfo.getMethod() + "-" + apiInfo.getFullPath();
    }

    @Override
    public ApiInfo get(ApiInfo apiInfo) {
        String strValue = (String)this.redisTemplate.opsForValue().get((Object)this.buildApiInfoKey(apiInfo));
        try {
            return (ApiInfo)this.objectMapper.readValue(strValue, ApiInfo.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void put(ApiInfo apiInfo) {
        try {
            String strValue = this.objectMapper.writeValueAsString((Object)apiInfo);
            this.redisTemplate.opsForValue().set((Object)this.buildApiInfoKey(apiInfo), (Object)strValue);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void remove(ApiInfo apiInfo) {
        this.redisTemplate.delete((Object)this.buildApiInfoKey(apiInfo));
    }

    @Override
    public void removeAll() {
        this.redisTemplate.delete(this.getKeys());
    }

    private List<String> getKeys() {
        String patternKey = this.buildPrefix() + ":*";
        ScanOptions options = ScanOptions.scanOptions().count(10000L).match(patternKey).build();
        RedisSerializer redisSerializer = this.redisTemplate.getKeySerializer();
        Cursor cursor = (Cursor)this.redisTemplate.executeWithStickyConnection(redisConnection -> new ConvertingCursor(redisConnection.scan(options), arg_0 -> ((RedisSerializer)redisSerializer).deserialize(arg_0)));
        ArrayList<String> keys = new ArrayList<String>();
        while (cursor.hasNext()) {
            keys.add(cursor.next().toString());
        }
        try {
            cursor.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return keys;
    }

    @Override
    public Collection<ApiInfo> getAll() {
        return this.redisTemplate.opsForValue().multiGet(this.getKeys()).stream().map(item -> {
            try {
                return (ApiInfo)this.objectMapper.readValue(item, ApiInfo.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }).collect(Collectors.toList());
    }
}

