/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.extend;

import com.github.alenfive.rocketapi.config.QLRequestMappingFactory;
import com.github.alenfive.rocketapi.entity.vo.NotifyEntity;
import com.github.alenfive.rocketapi.entity.vo.NotifyEventType;
import com.github.alenfive.rocketapi.extend.IClusterNotify;
import com.github.alenfive.rocketapi.service.ApiInfoService;
import com.github.alenfive.rocketapi.service.ConfigService;
import com.github.alenfive.rocketapi.service.DataSourceService;
import com.github.alenfive.rocketapi.utils.GenerateId;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultClusterNotify
implements IClusterNotify {
    private String instanceId = GenerateId.get().toHexString();
    @Autowired
    private ApiInfoService apiInfoService;
    @Autowired
    private QLRequestMappingFactory mappingFactory;
    @Autowired
    private DataSourceService dataSourceService;
    @Autowired
    private ConfigService configService;

    @Override
    public void sendNotify(NotifyEntity notifyEntity) {
        notifyEntity.setInstanceId(this.instanceId);
    }

    @Override
    public void receiveNotify(NotifyEntity notifyEntity) {
        if (this.instanceId.equals(notifyEntity.getInstanceId())) {
            return;
        }
        if (NotifyEventType.ReInit.equals((Object)notifyEntity.getEventType())) {
            try {
                this.mappingFactory.reInit(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        if (NotifyEventType.RefreshMapping.equals((Object)notifyEntity.getEventType())) {
            try {
                this.apiInfoService.refreshMapping(notifyEntity.getRefreshMapping());
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            return;
        }
        if (NotifyEventType.RefreshDB.equals((Object)notifyEntity.getEventType())) {
            try {
                this.dataSourceService.refreshDB(notifyEntity.getRefreshDB());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (NotifyEventType.RefreshConfig.equals((Object)notifyEntity.getEventType())) {
            this.configService.refreshConfig();
        }
    }
}

