/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.extend;

import com.github.alenfive.rocketapi.entity.ApiInfo;
import com.github.alenfive.rocketapi.extend.IApiInfoCache;
import com.github.alenfive.rocketapi.utils.GenerateId;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Component;

@Component
public class DefaultApiInfoCache
implements IApiInfoCache {
    private Map<String, ApiInfo> cacheApiInfo = new ConcurrentHashMap<String, ApiInfo>();
    private String instanceId = GenerateId.get().toHexString();

    @Override
    public ApiInfo get(ApiInfo apiInfo) {
        return this.cacheApiInfo.get(this.buildApiInfoKey(apiInfo));
    }

    @Override
    public Collection<ApiInfo> getAll() {
        return this.cacheApiInfo.values();
    }

    @Override
    public void removeAll() {
        this.cacheApiInfo.clear();
    }

    @Override
    public void remove(ApiInfo apiInfo) {
        this.cacheApiInfo.remove(this.buildApiInfoKey(apiInfo));
    }

    @Override
    public void put(ApiInfo apiInfo) {
        this.cacheApiInfo.put(this.buildApiInfoKey(apiInfo), apiInfo);
    }

    private String buildApiInfoKey(ApiInfo apiInfo) {
        return apiInfo.getMethod() + " " + apiInfo.getFullPath();
    }
}

