/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.datasource;

import com.github.alenfive.rocketapi.datasource.DataSourceDialect;
import com.github.alenfive.rocketapi.datasource.JdbcDataSource;
import com.github.alenfive.rocketapi.entity.vo.ScriptContext;
import com.github.alenfive.rocketapi.service.ScriptParseService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public abstract class DataSourceManager {
    private Map<String, DataSourceDialect> dialectMap;
    private ScriptParseService parseService;
    private DataSourceDialect storeApiDataSource;

    public void setParseService(ScriptParseService parseService) {
        this.parseService = parseService;
    }

    public DataSourceDialect getStoreApiDataSource() {
        return this.storeApiDataSource;
    }

    public Map<String, DataSourceDialect> getDialectMap() {
        return this.dialectMap;
    }

    public void setDialectMap(Map<String, DataSourceDialect> dialectMap) {
        String storeApiName = dialectMap.keySet().stream().filter(key -> ((DataSourceDialect)dialectMap.get(key)).isStoreApi()).findFirst().orElseThrow(() -> new IllegalArgumentException("storeApi is not found"));
        this.storeApiDataSource = dialectMap.get(storeApiName);
        this.dialectMap = dialectMap;
    }

    public ScriptContext buildScriptContext(StringBuilder script, DataSourceDialect dataSourceDialect, Map<String, Object> params) {
        return ScriptContext.builder().script(script).dataSourceDialect(dataSourceDialect).params(new Map[]{this.parseService.parse(script, dataSourceDialect, params)}).build();
    }

    public ScriptContext buildScriptContext(StringBuilder script, DataSourceDialect dataSourceDialect, List<Map<String, Object>> params) {
        if (!(dataSourceDialect instanceof JdbcDataSource)) {
            throw new UnsupportedOperationException("Only JDBC data sources are supported");
        }
        return ScriptContext.builder().script(script).dataSourceDialect(dataSourceDialect).params(params.toArray(new HashMap[params.size()])).build();
    }

    public DataSourceDialect getDataSourceDialect(String datasource, String specifyDataSource) {
        String dataSourceKey = StringUtils.isEmpty((Object)specifyDataSource) ? datasource : specifyDataSource;
        DataSourceDialect dataSourceDialect = this.dialectMap.get(dataSourceKey);
        if (dataSourceDialect == null) {
            throw new IllegalArgumentException("unknown datasource `" + dataSourceKey + "`");
        }
        return dataSourceDialect;
    }
}

