/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.alenfive.rocketapi.config.QLRequestMappingFactory;
import com.github.alenfive.rocketapi.config.RocketApiProperties;
import com.github.alenfive.rocketapi.entity.ApiResult;
import com.github.alenfive.rocketapi.entity.vo.AcceptApiInfoSyncReq;
import com.github.alenfive.rocketapi.service.ApiInfoService;
import com.github.alenfive.rocketapi.utils.SignUtils;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${spring.rocket-api.base-register-path:/interface-ui}"})
public class RemoteController {
    private static final Logger log = LoggerFactory.getLogger(RemoteController.class);
    @Autowired
    private QLRequestMappingFactory mappingFactory;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private RocketApiProperties rocketApiProperties;
    @Autowired
    private ApiInfoService apiInfoService;

    @PostMapping(value={"/accept-sync"})
    public ApiResult apiInfoSync(@RequestBody AcceptApiInfoSyncReq syncReq) throws Exception {
        if (syncReq == null || StringUtils.isEmpty((Object)syncReq.getSign()) || syncReq.getApiInfos() == null || syncReq.getTimestamp() == null || syncReq.getIncrement() == null) {
            return ApiResult.fail("Parameter is missing");
        }
        if (!this.rocketApiProperties.isSyncEnabled()) {
            return ApiResult.fail("Accept Sync already Disabled");
        }
        HashMap<String, Object> signMap = new HashMap<String, Object>();
        signMap.put("timestamp", syncReq.getTimestamp());
        signMap.put("increment", syncReq.getIncrement());
        signMap.put("apiInfos", this.objectMapper.writeValueAsString(syncReq.getApiInfos()));
        signMap.put("directories", this.objectMapper.writeValueAsString(syncReq.getDirectories()));
        String sign = SignUtils.build(this.rocketApiProperties.getSecretKey(), signMap);
        if (!syncReq.getSign().equals(sign)) {
            return ApiResult.fail("Signature abnormal");
        }
        try {
            Object result = this.apiInfoService.apiInfoSync(syncReq.getDirectories(), syncReq.getApiInfos(), syncReq.getIncrement() == 1);
            this.apiInfoService.reLoadApiInfo(false);
            return ApiResult.success(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResult.fail(e.getMessage());
        }
    }
}

