/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.alenfive.rocketapi.config.RocketApiProperties;
import com.github.alenfive.rocketapi.entity.ApiConfig;
import com.github.alenfive.rocketapi.entity.ApiDirectory;
import com.github.alenfive.rocketapi.entity.ApiExample;
import com.github.alenfive.rocketapi.entity.ApiInfo;
import com.github.alenfive.rocketapi.entity.ApiInfoHistory;
import com.github.alenfive.rocketapi.entity.ApiParams;
import com.github.alenfive.rocketapi.entity.ApiResult;
import com.github.alenfive.rocketapi.entity.DBConfig;
import com.github.alenfive.rocketapi.entity.vo.DeleteExamleReq;
import com.github.alenfive.rocketapi.entity.vo.DocApi;
import com.github.alenfive.rocketapi.entity.vo.DocsInfo;
import com.github.alenfive.rocketapi.entity.vo.ExportReq;
import com.github.alenfive.rocketapi.entity.vo.ExportRes;
import com.github.alenfive.rocketapi.entity.vo.LoginVo;
import com.github.alenfive.rocketapi.entity.vo.ProvideCompletionReq;
import com.github.alenfive.rocketapi.entity.vo.RemoteApiInfoSyncReq;
import com.github.alenfive.rocketapi.entity.vo.RunApiReq;
import com.github.alenfive.rocketapi.entity.vo.RunApiRes;
import com.github.alenfive.rocketapi.extend.ApiInfoContent;
import com.github.alenfive.rocketapi.extend.IApiDocSync;
import com.github.alenfive.rocketapi.extend.IScriptEncrypt;
import com.github.alenfive.rocketapi.extend.IUserAuthorization;
import com.github.alenfive.rocketapi.script.IScriptParse;
import com.github.alenfive.rocketapi.service.ApiInfoService;
import com.github.alenfive.rocketapi.service.CompletionService;
import com.github.alenfive.rocketapi.service.ConfigService;
import com.github.alenfive.rocketapi.service.DataSourceService;
import com.github.alenfive.rocketapi.service.LoginService;
import com.github.alenfive.rocketapi.utils.GenerateId;
import com.github.alenfive.rocketapi.utils.RequestUtils;
import com.github.alenfive.rocketapi.utils.SignUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"${spring.rocket-api.base-register-path:/interface-ui}"})
@ConditionalOnProperty(name={"spring.rocket-api.view-enabled"}, havingValue="true", matchIfMissing=true)
public class ApiController {
    private static final Logger log = LoggerFactory.getLogger(ApiController.class);
    @Autowired
    private ApiInfoContent apiInfoContent;
    @Autowired
    @Lazy
    private IScriptParse scriptParse;
    @Autowired
    private IUserAuthorization userAuthorization;
    @Autowired
    private LoginService loginService;
    @Autowired
    private IScriptEncrypt scriptEncrypt;
    @Autowired
    private IApiDocSync apiDocSync;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private RocketApiProperties properties;
    @Autowired
    private DataSourceService dataSourceService;
    @Autowired
    private ApiInfoService apiInfoService;
    @Autowired
    private ConfigService configService;
    @Autowired
    private CompletionService completionService;

    @GetMapping(value={"/api-list"})
    public ApiResult getPathList(boolean isDb) throws Exception {
        List result = this.apiInfoService.getPathList(isDb).stream().sorted(Comparator.comparing(ApiInfo::getName).thenComparing(ApiInfo::getFullPath)).collect(Collectors.toList());
        result = result.stream().map(item -> {
            ApiInfo apiInfo = new ApiInfo();
            BeanUtils.copyProperties((Object)item, (Object)apiInfo);
            return apiInfo;
        }).collect(Collectors.toList());
        return ApiResult.success(result);
    }

    @GetMapping(value={"/api-info/{id}"})
    public ApiResult getPathList(@PathVariable String id) throws Exception {
        ApiInfo apiInfo = this.apiInfoService.getPathList(false).stream().filter(item -> item.getId().equals(id)).findFirst().orElse(null);
        if (apiInfo == null || StringUtils.isEmpty((Object)apiInfo.getScript())) {
            return ApiResult.success(apiInfo);
        }
        ApiInfo resultInfo = new ApiInfo();
        BeanUtils.copyProperties((Object)apiInfo, (Object)resultInfo);
        resultInfo.setScript(this.scriptEncrypt.decrypt(resultInfo.getScript()));
        return ApiResult.success(resultInfo);
    }

    @GetMapping(value={"/api-info/last"})
    public ApiResult lastApiInfo(String apiInfoId, Integer pageSize, Integer pageNo) throws Exception {
        if (StringUtils.isEmpty((Object)apiInfoId)) {
            return ApiResult.success(null);
        }
        List<ApiInfoHistory> historyList = this.apiInfoService.lastApiInfo(apiInfoId, pageSize, pageNo);
        for (ApiInfoHistory history : historyList) {
            history.setScript(this.scriptEncrypt.decrypt(history.getScript()));
        }
        return ApiResult.success(historyList);
    }

    @PostMapping(value={"/api-info"})
    public ApiResult saveOrUpdateApiInfo(@RequestBody ApiInfo apiInfo, HttpServletRequest request) {
        String user = this.loginService.getUser(request);
        if (StringUtils.isEmpty((Object)user)) {
            return ApiResult.fail("Permission denied");
        }
        if (StringUtils.isEmpty((Object)apiInfo.getDirectoryId())) {
            return ApiResult.fail("A directory is a must");
        }
        apiInfo.setEditor(user);
        try {
            if (!StringUtils.isEmpty((Object)apiInfo.getScript())) {
                apiInfo.setScript(this.scriptEncrypt.encrypt(apiInfo.getScript()));
            }
            String apiInfoId = this.apiInfoService.saveApiInfo(apiInfo);
            return ApiResult.success(apiInfoId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResult.fail(e.getMessage());
        }
    }

    @PostMapping(value={"/remote-sync"})
    public Object apiInfoRemoteSync(@RequestBody RemoteApiInfoSyncReq syncReq, HttpServletRequest request) throws Exception {
        if (syncReq == null || StringUtils.isEmpty((Object)syncReq.getRemoteUrl()) || StringUtils.isEmpty((Object)syncReq.getSecretKey()) || syncReq.getIncrement() == null) {
            return ApiResult.fail("Parameter is missing");
        }
        String user = this.loginService.getUser(request);
        if (StringUtils.isEmpty((Object)user)) {
            return ApiResult.fail("Permission denied");
        }
        Collection apiInfos = null;
        Collection<ApiDirectory> directories = null;
        List<ApiDirectory> dbDirectories = this.apiInfoService.loadDirectoryList();
        if (syncReq.getIncrement() == 1) {
            apiInfos = this.apiInfoService.getPathList(false).stream().filter(item -> syncReq.getApiInfoIds().contains(item.getId())).collect(Collectors.toList());
            HashSet<ApiDirectory> directorySet = new HashSet<ApiDirectory>();
            for (ApiInfo apiInfo : apiInfos) {
                ApiDirectory directory = dbDirectories.stream().filter(item -> item.getId().equals(apiInfo.getDirectoryId())).findFirst().orElse(null);
                this.apiInfoService.relationParentDirectory(directorySet, dbDirectories, directory);
            }
            directories = directorySet;
        } else {
            apiInfos = this.apiInfoService.getPathList(false);
            directories = dbDirectories;
        }
        try {
            HashMap<String, Object> signMap = new HashMap<String, Object>(4);
            signMap.put("timestamp", System.currentTimeMillis());
            signMap.put("increment", syncReq.getIncrement());
            signMap.put("apiInfos", this.objectMapper.writeValueAsString((Object)apiInfos));
            signMap.put("directories", this.objectMapper.writeValueAsString(directories));
            String sign = SignUtils.build(syncReq.getSecretKey(), signMap);
            signMap.put("apiInfos", apiInfos);
            signMap.put("directories", directories);
            signMap.put("sign", sign);
            String remoteUrl = syncReq.getRemoteUrl().endsWith("/") ? syncReq.getRemoteUrl().substring(0, syncReq.getRemoteUrl().length() - 1) : syncReq.getRemoteUrl();
            String url = remoteUrl + (this.properties.getBaseRegisterPath() + "/accept-sync").replace("//", "/");
            RestTemplate restTemplate = this.getRestTemplate();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            HttpEntity requestHttpEntity = new HttpEntity((Object)this.objectMapper.writeValueAsString(signMap), (MultiValueMap)headers);
            ResponseEntity postForEntity = restTemplate.postForEntity(url, (Object)requestHttpEntity, Object.class, new Object[0]);
            return postForEntity.getBody();
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResult.fail(e.toString());
        }
    }

    private RestTemplate getRestTemplate() {
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        factory.setConnectTimeout(60000);
        factory.setReadTimeout(60000);
        return new RestTemplate((ClientHttpRequestFactory)factory);
    }

    @DeleteMapping(value={"/api-info"})
    public ApiResult deleteApiInfo(@RequestBody ApiInfo apiInfo, HttpServletRequest request) {
        String user = this.loginService.getUser(request);
        if (StringUtils.isEmpty((Object)user)) {
            return ApiResult.fail("Permission denied");
        }
        try {
            this.apiInfoService.deleteApiInfo(apiInfo);
            return ApiResult.success(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResult.fail(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/api-info/run"})
    public ApiResult runScript(@RequestBody RunApiReq runApiReq, HttpServletRequest request) {
        String user = this.loginService.getUser(request);
        if (StringUtils.isEmpty((Object)user)) {
            return ApiResult.fail("Permission denied");
        }
        RunApiRes runApiRes = new RunApiRes();
        try {
            this.apiInfoContent.setIsDebug(runApiReq.isDebug());
            ApiInfo apiInfo = ApiInfo.builder().fullPath(runApiReq.getPattern()).options(runApiReq.getOptions()).datasource(runApiReq.getDatasource()).script(runApiReq.getScript()).build();
            ApiParams apiParams = ApiParams.builder().header(this.decodeHeaderValue(runApiReq.getHeader())).pathVar(this.getPathVar(runApiReq.getPattern(), runApiReq.getUrl())).param(this.getParam(runApiReq.getUrl())).body(this.buildBody(runApiReq.getBody())).session(RequestUtils.buildSessionParams(request)).build();
            Object value = this.scriptParse.runScript(apiInfo.getScript(), apiInfo, apiParams);
            runApiRes.setData(value);
            ApiResult apiResult = ApiResult.success(runApiRes);
            return apiResult;
        }
        catch (Throwable e) {
            e.printStackTrace();
            ApiResult apiResult = ApiResult.fail(e.getMessage(), runApiRes);
            return apiResult;
        }
        finally {
            runApiRes.setLogs(this.apiInfoContent.getLogs());
            this.apiInfoContent.removeAll();
        }
    }

    private Map<String, Object> buildBody(Object body) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (body instanceof Map) {
            params.putAll((Map)body);
        }
        params.put(this.properties.getBodyRootKey(), body);
        return params;
    }

    private Map<String, String> decodeHeaderValue(Map<String, String> header) throws UnsupportedEncodingException {
        HashMap<String, String> newHeader = new HashMap<String, String>(header.size());
        for (String key : header.keySet()) {
            newHeader.put(key.toLowerCase(), URLDecoder.decode(header.get(key), "utf-8"));
        }
        return newHeader;
    }

    private Map<String, String> getPathVar(String pattern, String url) {
        Integer beginIndex = url.indexOf("/", 8);
        if (beginIndex == -1) {
            return null;
        }
        Integer endIndex = url.indexOf("?") == -1 ? url.length() : url.indexOf("?");
        AntPathMatcher matcher = new AntPathMatcher();
        String path = url.substring(beginIndex, endIndex);
        if (matcher.match(pattern, path)) {
            return matcher.extractUriTemplateVariables(pattern, path);
        }
        return null;
    }

    private Map<String, Object> getParam(String url) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        MultiValueMap urlMvp = UriComponentsBuilder.fromHttpUrl((String)url).build().getQueryParams();
        urlMvp.forEach((key, value) -> {
            String firstValue = CollectionUtils.isEmpty((Collection)value) ? null : (String)value.get(0);
            result.put((String)key, firstValue);
        });
        return result;
    }

    @PostMapping(value={"/api-example"})
    public ApiResult saveExample(@RequestBody ApiExample apiExample, HttpServletRequest request) throws Exception {
        String user = this.loginService.getUser(request);
        if (StringUtils.isEmpty((Object)user)) {
            return ApiResult.fail("Permission denied");
        }
        if (StringUtils.isEmpty((Object)apiExample.getMethod()) || StringUtils.isEmpty((Object)apiExample.getUrl()) || StringUtils.isEmpty((Object)apiExample.getRequestHeader())) {
            return ApiResult.fail("Send, then Save");
        }
        apiExample.setEditor(user);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        apiExample.setCreateTime(sdf.format(new Date()));
        apiExample.setId(GenerateId.get().toHexString());
        if (!StringUtils.isEmpty((Object)apiExample.getResponseBody())) {
            apiExample.setResponseBody(URLEncoder.encode(apiExample.getResponseBody(), "utf-8"));
        }
        return ApiResult.success(this.apiInfoService.saveExample(apiExample));
    }

    @GetMapping(value={"/api-example/last"})
    public ApiResult lastApiExample(String apiInfoId, Integer pageSize, Integer pageNo) throws Exception {
        List<ApiExample> result = this.apiInfoService.listApiExampleScript(apiInfoId, pageSize, pageNo);
        result.forEach(item -> {
            if (!StringUtils.isEmpty((Object)item.getResponseBody())) {
                try {
                    item.setResponseBody(URLDecoder.decode(item.getResponseBody(), "utf-8"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        });
        return ApiResult.success(result);
    }

    @DeleteMapping(value={"/api-example"})
    private ApiResult deleteExampleList(@RequestBody DeleteExamleReq deleteExamleReq, HttpServletRequest request) throws Exception {
        String user = this.loginService.getUser(request);
        if (StringUtils.isEmpty((Object)user)) {
            return ApiResult.fail("Permission denied");
        }
        this.apiInfoService.deleteExampleList(deleteExamleReq.getApiExampleList());
        return ApiResult.success(null);
    }

    @PostMapping(value={"/login"})
    public ApiResult login(@RequestBody LoginVo loginVo, HttpServletRequest request, HttpServletResponse response) throws JsonProcessingException {
        String user = this.userAuthorization.validate(loginVo.getUsername(), loginVo.getPassword());
        if (!StringUtils.isEmpty((Object)user)) {
            return ApiResult.success(this.loginService.getToken(loginVo));
        }
        return ApiResult.fail("Incorrect username or password");
    }

    @PostMapping(value={"/logout"})
    public ApiResult login(HttpServletRequest request, HttpServletResponse response) {
        return ApiResult.success(null);
    }

    @GetMapping(value={"/api-doc-push"})
    public ApiResult apiDocPush(String apiInfoId) throws Exception {
        Collection<ApiInfo> apiInfos = this.apiInfoService.getPathList(false);
        String result = null;
        List<ApiDirectory> directoryList = this.apiInfoService.loadDirectoryList();
        List<DocApi> docsInfoList = null;
        if (!StringUtils.isEmpty((Object)apiInfoId)) {
            ApiInfo apiInfo = apiInfos.stream().filter(item -> item.getId().equals(apiInfoId)).findFirst().orElse(null);
            ApiExample apiExample = this.buildLastApiExample(apiInfo.getId());
            docsInfoList = Arrays.asList(new DocApi(apiInfo, apiExample));
        } else {
            docsInfoList = apiInfos.stream().map(item -> new DocApi((ApiInfo)item, this.buildLastApiExample(item.getId()))).collect(Collectors.toList());
        }
        result = this.apiDocSync.sync(new DocsInfo(directoryList, docsInfoList));
        return ApiResult.success(result);
    }

    private ApiExample buildLastApiExample(String apiInfoId) {
        List<ApiExample> result = this.apiInfoService.listApiExampleScript(apiInfoId, 1, 1);
        if (CollectionUtils.isEmpty(result)) {
            return null;
        }
        ApiExample apiExample = result.get(0);
        try {
            if (!StringUtils.isEmpty((Object)apiExample.getResponseBody())) {
                apiExample.setResponseBody(URLDecoder.decode(apiExample.getResponseBody(), "utf-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return apiExample;
    }

    @GetMapping(value={"/api-config"})
    public ApiResult getApiConfig(HttpServletRequest request) {
        String user = this.loginService.getUser(request);
        if (StringUtils.isEmpty((Object)user)) {
            return ApiResult.fail("Permission denied");
        }
        ApiConfig result = null;
        try {
            result = this.configService.getYmlConfig();
        }
        catch (Exception e) {
            return ApiResult.fail(e.getMessage());
        }
        return ApiResult.success(result);
    }

    @PostMapping(value={"/api-config"})
    public ApiResult saveApiConfig(@RequestBody(required=false) String configContext, HttpServletRequest request) {
        String user = this.loginService.getUser(request);
        if (StringUtils.isEmpty((Object)user)) {
            return ApiResult.fail("Permission denied");
        }
        try {
            this.configService.saveYmlConfig(configContext);
        }
        catch (Exception e) {
            return ApiResult.fail(e.getMessage());
        }
        return ApiResult.success(null);
    }

    @GetMapping(value={"/directory/list"})
    public ApiResult directoryList() {
        return ApiResult.success(this.apiInfoService.loadDirectoryList().stream().sorted(Comparator.comparing(ApiDirectory::getName).thenComparing(ApiDirectory::getPath)).collect(Collectors.toList()));
    }

    @PostMapping(value={"/directory"})
    public ApiResult saveDirectory(@RequestBody ApiDirectory directory, HttpServletRequest request) {
        String user = this.loginService.getUser(request);
        if (StringUtils.isEmpty((Object)user)) {
            return ApiResult.fail("Permission denied");
        }
        try {
            this.apiInfoService.saveDirectory(directory);
        }
        catch (Exception e) {
            return ApiResult.fail(e.getMessage());
        }
        return ApiResult.success(directory.getId());
    }

    @DeleteMapping(value={"/directory"})
    public ApiResult removeDirectory(@RequestBody ApiDirectory directory, HttpServletRequest request) {
        String user = this.loginService.getUser(request);
        if (StringUtils.isEmpty((Object)user)) {
            return ApiResult.fail("Permission denied");
        }
        try {
            this.apiInfoService.removeDirectory(directory);
        }
        catch (Exception e) {
            return ApiResult.fail(e.getMessage());
        }
        return ApiResult.success(null);
    }

    @PostMapping(value={"/export"})
    public void exportApi(ExportReq exportReq, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String user = this.loginService.getUser(exportReq.getToken());
        String resStr = null;
        if (StringUtils.isEmpty((Object)user)) {
            resStr = this.objectMapper.writeValueAsString((Object)ApiResult.fail("Permission denied"));
            response.getOutputStream().write(resStr.getBytes());
            return;
        }
        ExportRes exportRes = this.apiInfoService.exportApi(exportReq);
        response.setCharacterEncoding("UTF-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(exportReq.getFileName(), "UTF-8") + ".json");
        response.addHeader("Content-Type", "application/octet-stream");
        resStr = this.objectMapper.writeValueAsString((Object)exportRes);
        response.getOutputStream().write(resStr.getBytes());
    }

    @PostMapping(value={"/import"})
    public ApiResult importApiInfo(MultipartFile file, Integer override, HttpServletRequest request) {
        String user = this.loginService.getUser(request);
        if (StringUtils.isEmpty((Object)user)) {
            return ApiResult.fail("Permission denied");
        }
        if (file == null) {
            return ApiResult.fail("file is null");
        }
        try {
            ExportRes exportRes = (ExportRes)this.objectMapper.readValue(file.getBytes(), ExportRes.class);
            Object result = this.apiInfoService.importAPI(exportRes.getDirectories(), exportRes.getApiInfos(), override == 1);
            return ApiResult.success(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResult.fail(e.getMessage());
        }
    }

    @GetMapping(value={"/completion-items"})
    public ApiResult provideCompletionTypes() throws Exception {
        return ApiResult.success(this.completionService.provideCompletionTypes());
    }

    @PostMapping(value={"/completion-clazz"})
    public ApiResult provideCompletionItems(@RequestBody ProvideCompletionReq completionReq) {
        try {
            Class<?> clazz = Class.forName(completionReq.getClazz());
            return ApiResult.success(this.completionService.buildMethod(clazz));
        }
        catch (Throwable throwable) {
            return ApiResult.success(Collections.emptyList());
        }
    }

    @GetMapping(value={"/db-config/list"})
    public ApiResult listDbConfig() {
        try {
            List<DBConfig> dbConfigs = this.dataSourceService.getDBConfig();
            return ApiResult.success(dbConfigs);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResult.fail(e.getMessage());
        }
    }

    @PostMapping(value={"/db-config"})
    public ApiResult saveDBConfig(@RequestBody DBConfig config, HttpServletRequest request) {
        String user = this.loginService.getUser(request);
        if (StringUtils.isEmpty((Object)user)) {
            return ApiResult.fail("Permission denied");
        }
        try {
            return ApiResult.success(this.dataSourceService.saveDBConfig(config));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResult.fail(e.getMessage());
        }
    }

    @DeleteMapping(value={"/db-config"})
    public ApiResult deleteDBConfig(@RequestBody DBConfig config, HttpServletRequest request) throws IOException {
        String user = this.loginService.getUser(request);
        if (StringUtils.isEmpty((Object)user)) {
            return ApiResult.fail("Permission denied");
        }
        try {
            this.dataSourceService.deleteDBConfig(config);
            return ApiResult.success(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResult.fail(e.getMessage());
        }
    }

    @GetMapping(value={"/db-driver/list"})
    public ApiResult listDbDriver() {
        try {
            return ApiResult.success(this.completionService.getDriver());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResult.fail(e.getMessage());
        }
    }

    @PostMapping(value={"/db-test"})
    public ApiResult testDBConfig(@RequestBody DBConfig config, HttpServletRequest request) {
        String user = this.loginService.getUser(request);
        if (StringUtils.isEmpty((Object)user)) {
            return ApiResult.fail("Permission denied");
        }
        try {
            this.dataSourceService.testDBConfig(config);
            return ApiResult.success(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResult.fail(e.getMessage());
        }
    }

    @GetMapping(value={"/check-version"})
    public ApiResult checkVersion() {
        try {
            String urlStr = "https://img.shields.io/maven-metadata/v.json?label=maven-central&metadataUrl=https://repo1.maven.org/maven2/com/github/alenfive/rocket-api-boot-starter/maven-metadata.xml";
            HttpHeaders headers = new HttpHeaders();
            headers.add("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.99 Safari/537.36");
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
            SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
            factory.setConnectTimeout(60000);
            factory.setReadTimeout(60000);
            RestTemplate restTemplate = new RestTemplate();
            ResponseEntity response = restTemplate.exchange(urlStr, HttpMethod.GET, httpEntity, Object.class, new Object[0]);
            return ApiResult.success(response.getBody());
        }
        catch (Exception e) {
            return ApiResult.fail(e.getMessage());
        }
    }
}

