/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.config;

import com.github.alenfive.rocketapi.datasource.DataSourceDialect;
import com.github.alenfive.rocketapi.datasource.DataSourceManager;
import com.github.alenfive.rocketapi.datasource.MongoDataSource;
import com.github.alenfive.rocketapi.datasource.MySQLDataSource;
import java.util.LinkedHashMap;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@Component
public class DefaultDataSourceManager
extends DataSourceManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultDataSourceManager.class);
    @Autowired
    private DataSource dataSource;
    @Autowired
    private MongoTemplate mongoTemplate;

    @PostConstruct
    public void init() {
        log.warn("\n--------------------------------------\n !!! \u4e0d\u8981\u542f\u52a8\u6211\uff0c\u6211\u53ea\u4e3a\u7f16\u8bd1\u8c03\u8bd5\u6e90\u7801\u800c\u751f\uff0c\u8c03\u8bd5\u6210\u529f\u540emvn package \u4f1a\u8f93\u51fa 'rocket-api-boot-starter',\u5173\u4e8e\u5982\u4f55\u4f7f\u7528stater,\u8bf7\u770b\u4e1a\u52a1\u96c6\u6210demo:https://gitee.com/alenfive/rocket-api-demo\n--------------------------------------\n");
        LinkedHashMap<String, DataSourceDialect> dialectMap = new LinkedHashMap<String, DataSourceDialect>();
        dialectMap.put("mysql", new MySQLDataSource(this.dataSource, true));
        dialectMap.put("mongodb", new MongoDataSource(this.mongoTemplate));
        super.setDialectMap(dialectMap);
    }
}

