/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataset.service.impl.dataset;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gccloud.common.exception.GlobalException;
import com.gccloud.common.utils.JSON;
import com.gccloud.common.vo.PageVO;
import com.gccloud.dataset.constant.DatasetConstant;
import com.gccloud.dataset.dao.DatasetDao;
import com.gccloud.dataset.dto.DatasetParamDTO;
import com.gccloud.dataset.dto.TestExecuteDTO;
import com.gccloud.dataset.entity.DatasetEntity;
import com.gccloud.dataset.entity.DatasourceEntity;
import com.gccloud.dataset.entity.config.StoredProcedureDataSetConfig;
import com.gccloud.dataset.extend.dataset.DatasetExtendClient;
import com.gccloud.dataset.params.ParamsClient;
import com.gccloud.dataset.permission.DatasetPermissionClient;
import com.gccloud.dataset.service.IBaseDataSetService;
import com.gccloud.dataset.service.IBaseDatasourceService;
import com.gccloud.dataset.service.factory.DatasourceServiceFactory;
import com.gccloud.dataset.service.impl.datasource.BaseDatasourceServiceImpl;
import com.gccloud.dataset.utils.DBUtils;
import com.gccloud.dataset.vo.DataVO;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="storedProcedure")
public class StoredProcedureDataSetServiceImpl
extends ServiceImpl<DatasetDao, DatasetEntity>
implements IBaseDataSetService {
    private static final Logger log = LoggerFactory.getLogger(StoredProcedureDataSetServiceImpl.class);
    @Resource
    private ParamsClient paramsClient;
    @Resource
    private DatasourceServiceFactory datasourceServiceFactory;
    @Resource
    private BaseDatasourceServiceImpl datasourceService;
    @Resource
    private DatasetPermissionClient datasetPermissionClient;
    @Resource
    private DatasetExtendClient datasetExtendClient;

    @Override
    public String add(DatasetEntity entity) {
        String id = IBaseDataSetService.super.add(entity);
        if (this.datasetPermissionClient.hasPermissionService()) {
            this.datasetPermissionClient.addPermission(id);
        }
        return id;
    }

    @Override
    public void delete(String id) {
        IBaseDataSetService.super.delete(id);
        if (this.datasetPermissionClient.hasPermissionService()) {
            this.datasetPermissionClient.deletePermission(id);
        }
    }

    public PageVO execute(String id, List<DatasetParamDTO> params, int current, int size) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new GlobalException("\u6570\u636e\u96c6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        long startTime = System.currentTimeMillis();
        DatasetEntity dataset = this.getByIdFromCache(id);
        StoredProcedureDataSetConfig config = (StoredProcedureDataSetConfig)dataset.getConfig();
        String sqlProcess = config.getSqlProcess();
        sqlProcess = this.paramsClient.handleScript(dataset.getDatasetType(), sqlProcess);
        params = this.paramsClient.handleParams(params);
        sqlProcess = DBUtils.updateParamsConfig(sqlProcess, params);
        DatasourceEntity datasource = this.datasourceService.getInfoById(config.getSourceId());
        IBaseDatasourceService buildService = this.datasourceServiceFactory.build(datasource.getSourceType());
        log.info("\u6267\u884c\u3010{}\u3011\u6570\u636e\u96c6\uff08\u7c7b\u578b\uff1a\u3010\u5b58\u50a8\u8fc7\u7a0b\u3011\uff0cID:\u3010{}\u3011\uff09\uff0c \u53c2\u6570\uff1a\u3010{}\u3011\uff0c URL\uff1a\u3010{}\u3011\uff0c \u6267\u884cSQL\uff1a\u3010{}\u3011", new Object[]{dataset.getName(), dataset.getId(), JSON.toJSONString(params), datasource.getUrl(), sqlProcess});
        DataVO dataVO = buildService.executeProcedure(datasource, sqlProcess, current, size);
        PageVO data = (PageVO)dataVO.getData();
        List<Map<String, Object>> list = data.getList();
        list = this.datasetExtendClient.handleData(list, dataset);
        data.setList(list);
        long endTime = System.currentTimeMillis();
        log.info("\u6267\u884c\u3010{}\u3011\u6570\u636e\u96c6\uff08\u7c7b\u578b\uff1a\u3010\u5b58\u50a8\u8fc7\u7a0b\u3011\uff0cID:\u3010{}\u3011\uff09\u7ed3\u675f\uff0c\u8017\u65f6\uff1a\u3010{}\u3011\u6beb\u79d2", new Object[]{dataset.getName(), dataset.getId(), endTime - startTime});
        return data;
    }

    @Override
    public Object execute(String id, List<DatasetParamDTO> params) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new GlobalException("\u6570\u636e\u96c6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<DatasetParamDTO> finalParams = params;
        DatasetEntity dataset = this.getByIdFromCache(id);
        if (dataset == null) {
            throw new GlobalException("\u6570\u636e\u96c6\u4e0d\u5b58\u5728");
        }
        if (DatasetConstant.DatasetCache.OPEN.equals(dataset.getCache())) {
            CompletableFuture future = DATASET_CACHE.get((Object)id, key -> this.getData(finalParams, dataset));
            try {
                return future.get();
            }
            catch (Exception e) {
                log.error("\u6570\u636e\u96c6\u7f13\u5b58\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return this.getData(finalParams, dataset);
    }

    private Object getData(List<DatasetParamDTO> finalParams, DatasetEntity dataset) {
        long startTime = System.currentTimeMillis();
        StoredProcedureDataSetConfig config = (StoredProcedureDataSetConfig)dataset.getConfig();
        String sqlProcess = config.getSqlProcess();
        sqlProcess = this.paramsClient.handleScript(dataset.getDatasetType(), sqlProcess);
        List<DatasetParamDTO> paramsList = this.paramsClient.handleParams(finalParams);
        sqlProcess = DBUtils.updateParamsConfig(sqlProcess, paramsList);
        DatasourceEntity datasource = this.datasourceService.getInfoById(config.getSourceId());
        IBaseDatasourceService buildService = this.datasourceServiceFactory.build(datasource.getSourceType());
        log.info("\u6267\u884c\u3010{}\u3011\u6570\u636e\u96c6\uff08\u7c7b\u578b\uff1a\u3010\u5b58\u50a8\u8fc7\u7a0b\u3011\uff0cID:\u3010{}\u3011\uff09\uff0c \u53c2\u6570\uff1a\u3010{}\u3011\uff0c URL\uff1a\u3010{}\u3011\uff0c \u6267\u884cSQL\uff1a\u3010{}\u3011", new Object[]{dataset.getName(), dataset.getId(), JSON.toJSONString(finalParams), datasource.getUrl(), sqlProcess});
        DataVO dataVO = buildService.executeProcedure(datasource, sqlProcess, null, null);
        List<Map<String, Object>> list = (List<Map<String, Object>>)dataVO.getData();
        list = this.datasetExtendClient.handleData(list, dataset);
        long endTime = System.currentTimeMillis();
        log.info("\u6267\u884c\u3010{}\u3011\u6570\u636e\u96c6\uff08\u7c7b\u578b\uff1a\u3010\u5b58\u50a8\u8fc7\u7a0b\u3011\uff0cID:\u3010{}\u3011\uff09\u7ed3\u675f\uff0c\u8017\u65f6\uff1a\u3010{}\u3011\u6beb\u79d2", new Object[]{dataset.getName(), dataset.getId(), endTime - startTime});
        return list;
    }

    @Override
    public DataVO execute(TestExecuteDTO executeDTO) {
        String sqlProcess = executeDTO.getScript();
        if (StringUtils.isBlank((CharSequence)sqlProcess)) {
            throw new GlobalException("\u5b58\u50a8\u8fc7\u7a0b\u6267\u884c\u8bed\u53e5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        long startTime = System.currentTimeMillis();
        List<DatasetParamDTO> params = executeDTO.getParams();
        sqlProcess = this.paramsClient.handleScript(executeDTO.getDataSetType(), sqlProcess);
        params = this.paramsClient.handleParams(params);
        sqlProcess = DBUtils.updateParamsConfig(sqlProcess, params);
        DatasourceEntity datasource = this.datasourceService.getInfoById(executeDTO.getDataSourceId());
        IBaseDatasourceService buildService = this.datasourceServiceFactory.build(datasource.getSourceType());
        Integer current = executeDTO.getCurrent();
        Integer size = executeDTO.getSize();
        log.info("\u6d4b\u8bd5\u6570\u636e\u96c6\uff08\u7c7b\u578b\uff1a\u3010\u5b58\u50a8\u8fc7\u7a0b\u3011\uff09\uff0c\u53c2\u6570\uff1a\u3010{}\u3011\uff0c URL\uff1a\u3010{}\u3011\uff0c \u6267\u884cSQL\uff1a\u3010{}\u3011", new Object[]{JSON.toJSONString(params), datasource.getUrl(), sqlProcess});
        DataVO dataVO = current != null && size != null ? buildService.executeProcedure(datasource, sqlProcess, current, size) : buildService.executeProcedure(datasource, sqlProcess, null, null);
        long endTime = System.currentTimeMillis();
        log.info("\u6d4b\u8bd5\u6570\u636e\u96c6\uff08\u7c7b\u578b\uff1a\u3010\u5b58\u50a8\u8fc7\u7a0b\u3011\uff09\u7ed3\u675f\uff0c\u8017\u65f6\uff1a\u3010{}\u3011\u6beb\u79d2", (Object)(endTime - startTime));
        return dataVO;
    }
}

