/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataset.utils;

import com.gccloud.common.exception.GlobalException;
import com.gccloud.dataset.constant.DatasetConstant;
import com.gccloud.dataset.dto.DatasetParamDTO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.ibatis.builder.StaticSqlSource;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MybatisParameterUtils {
    private static final Logger log = LoggerFactory.getLogger(MybatisParameterUtils.class);
    @Resource
    private SqlSessionFactory sqlSessionFactory;
    private SqlBuilderStatement sqlBuilderStatement;
    public static final List<String> MYBATIS_KEYWORDS = Lists.newArrayList((Object[])new String[]{"where", "set", "choose", "when", "otherwise", "if", "trim", "foreach", "bind", "sql", "include"});

    @PostConstruct
    public void init() {
        this.sqlBuilderStatement = new SqlBuilderStatement(this.sqlSessionFactory.getConfiguration());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String updateParamsConfig(String sql, List<DatasetParamDTO> params) {
        void var7_13;
        if (params == null) {
            params = new ArrayList<DatasetParamDTO>();
        }
        boolean hasMybatisKeyword = sql.contains("${") || sql.contains("#{");
        for (String keyword : MYBATIS_KEYWORDS) {
            if (!sql.contains("<" + keyword) && !sql.contains("</" + keyword)) continue;
            hasMybatisKeyword = true;
            break;
        }
        for (DatasetParamDTO param : params) {
            Iterator name = param.getName();
            if (!sql.contains("<" + (String)((Object)name) + ">") || !sql.contains("</" + (String)((Object)name) + ">")) continue;
            hasMybatisKeyword = true;
            sql = param.getType().equals("String") || param.getType().equals("Date") ? sql.replace("<" + name + ">", "<if test=\"" + name + " != null and " + name + " != ''\">") : sql.replace("<" + name + ">", "<if test=\"" + name + " != null\">");
            sql = sql.replace("</" + name + ">", "</if>");
        }
        if (!hasMybatisKeyword) {
            return sql;
        }
        log.info("\u5f00\u59cb\u8fdb\u884c\u52a8\u6001sql\u6784\u9020\uff1a{}", (Object)sql);
        HashMap<String, String> labelMap = new HashMap<String, String>();
        int index = 0;
        for (String string : MYBATIS_KEYWORDS) {
            String key;
            String group;
            String regex = "<" + string + "[^>]*>";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(sql);
            while (matcher.find()) {
                group = matcher.group();
                key = "[mybatisLabel" + ++index + "]";
                labelMap.put(key, group);
                sql = sql.replace(group, key);
            }
            regex = "</" + string + ">";
            pattern = Pattern.compile(regex);
            matcher = pattern.matcher(sql);
            while (matcher.find()) {
                group = matcher.group();
                key = "[mybatisLabel" + ++index + "]";
                labelMap.put(key, group);
                sql = sql.replace(group, key);
            }
        }
        sql = sql.replace("<", "&lt;").replace(">", "&gt;");
        for (Map.Entry entry : labelMap.entrySet()) {
            sql = sql.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        if (!sql.startsWith("<script>")) {
            sql = "<script>" + sql;
        }
        if (!sql.endsWith("</script>")) {
            sql = sql + "</script>";
        }
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        for (DatasetParamDTO param : params) {
            Object value;
            String type;
            if (null == param.getStatus() || !DatasetConstant.SqlParamsStatus.VARIABLE.equals(param.getStatus())) continue;
            switch (type = param.getType()) {
                case "Integer": {
                    try {
                        value = Integer.parseInt(param.getValue());
                    }
                    catch (NumberFormatException e) {
                        log.error("\u53c2\u6570{}\u8f6c\u6362\u6210Integer\u7c7b\u578b\u5931\u8d25", (Object)param.getName());
                        value = param.getValue();
                    }
                    break;
                }
                case "Long": {
                    try {
                        value = Long.parseLong(param.getValue());
                    }
                    catch (NumberFormatException e) {
                        log.error("\u53c2\u6570{}\u8f6c\u6362\u6210Long\u7c7b\u578b\u5931\u8d25", (Object)param.getName());
                        value = param.getValue();
                    }
                    break;
                }
                case "Double": {
                    try {
                        value = Double.parseDouble(param.getValue());
                    }
                    catch (NumberFormatException e) {
                        log.error("\u53c2\u6570{}\u8f6c\u6362\u6210Double\u7c7b\u578b\u5931\u8d25", (Object)param.getName());
                        value = param.getValue();
                    }
                    break;
                }
                default: {
                    value = param.getValue();
                }
            }
            parameterMap.put(param.getName(), value);
        }
        Class<?> parameterType = parameterMap.getClass();
        String msId = this.sqlBuilderStatement.selectDynamic(sql, parameterType);
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession(true);){
            MappedStatement mappedStatement = sqlSession.getConfiguration().getMappedStatement(msId);
            SqlSource sqlSource = mappedStatement.getSqlSource();
            String string = sqlSource.getBoundSql(parameterMap).getSql();
            List parameterMappings = sqlSource.getBoundSql(parameterMap).getParameterMappings();
            Map parameterObject = (Map)sqlSource.getBoundSql(parameterMap).getParameterObject();
            if (parameterMappings == null) {
                log.info("\u6784\u9020\u540e\u7684sql:{}", (Object)string);
                String string2 = string;
                return string2;
            }
            for (ParameterMapping mapping : parameterMappings) {
                String property = mapping.getProperty();
                Object o = parameterObject.get(property);
                if (o instanceof String) {
                    String string3 = var7_13.replaceFirst("\\?", "'" + o + "'");
                    continue;
                }
                String string4 = var7_13.replaceFirst("\\?", o.toString());
            }
        }
        catch (Exception e) {
            log.error("\u6784\u9020sql\u5931\u8d25:{}", (Object)sql);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new GlobalException("\u6784\u9020sql\u5931\u8d25");
        }
        String string = this.removeExtraWhitespaces((String)var7_13);
        log.info("\u6784\u9020\u540e\u7684sql:{}", (Object)string);
        return string;
    }

    public String removeExtraWhitespaces(String original) {
        StringTokenizer tokenizer = new StringTokenizer(original);
        StringBuilder builder = new StringBuilder();
        boolean hasMoreTokens = tokenizer.hasMoreTokens();
        while (hasMoreTokens) {
            builder.append(tokenizer.nextToken());
            hasMoreTokens = tokenizer.hasMoreTokens();
            if (!hasMoreTokens) continue;
            builder.append(' ');
        }
        return builder.toString();
    }

    private static class SqlBuilderStatement {
        private final Configuration configuration;
        private final LanguageDriver languageDriver;

        private SqlBuilderStatement(Configuration configuration) {
            this.configuration = configuration;
            this.languageDriver = configuration.getDefaultScriptingLanguageInstance();
        }

        private String newMsId(String sql, SqlCommandType sqlCommandType) {
            return sqlCommandType.toString() + "." + sql.hashCode();
        }

        private boolean hasMappedStatement(String msId) {
            return this.configuration.hasStatement(msId, false);
        }

        private void newSelectMappedStatement(String msId, SqlSource sqlSource, final Class<?> resultType) {
            MappedStatement ms = new MappedStatement.Builder(this.configuration, msId, sqlSource, SqlCommandType.SELECT).resultMaps((List)new ArrayList<ResultMap>(){
                {
                    this.add(new ResultMap.Builder(configuration, "defaultResultMap", resultType, new ArrayList(0)).build());
                }
            }).build();
            this.configuration.addMappedStatement(ms);
        }

        private String select(String sql, Class<?> resultType) {
            String msId = this.newMsId(resultType + sql, SqlCommandType.SELECT);
            if (!this.hasMappedStatement(msId)) {
                StaticSqlSource sqlSource = new StaticSqlSource(this.configuration, sql);
                this.newSelectMappedStatement(msId, (SqlSource)sqlSource, resultType);
            }
            return msId;
        }

        private String select(String sql) {
            String msId = this.newMsId(sql, SqlCommandType.SELECT);
            if (!this.hasMappedStatement(msId)) {
                StaticSqlSource sqlSource = new StaticSqlSource(this.configuration, sql);
                this.newSelectMappedStatement(msId, (SqlSource)sqlSource, Map.class);
            }
            return msId;
        }

        private String selectDynamic(String sql, Class<?> parameterType) {
            String msId = this.newMsId(sql + parameterType, SqlCommandType.SELECT);
            if (!this.hasMappedStatement(msId)) {
                SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, parameterType);
                this.newSelectMappedStatement(msId, sqlSource, Map.class);
            }
            return msId;
        }

        private String selectDynamic(String sql, Class<?> parameterType, Class<?> resultType) {
            String msId = this.newMsId(resultType + sql + parameterType, SqlCommandType.SELECT);
            if (!this.hasMappedStatement(msId)) {
                SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, parameterType);
                this.newSelectMappedStatement(msId, sqlSource, resultType);
            }
            return msId;
        }
    }
}

