/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataset.service.impl.dataset;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gccloud.common.exception.GlobalException;
import com.gccloud.common.utils.JSON;
import com.gccloud.dataset.dao.DatasetDao;
import com.gccloud.dataset.dto.DatasetParamDTO;
import com.gccloud.dataset.dto.TestExecuteDTO;
import com.gccloud.dataset.entity.DatasetEntity;
import com.gccloud.dataset.entity.config.JsonDataSetConfig;
import com.gccloud.dataset.permission.DatasetPermissionClient;
import com.gccloud.dataset.service.IBaseDataSetService;
import com.gccloud.dataset.vo.DataVO;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="json")
public class JsonDataSetServiceImpl
extends ServiceImpl<DatasetDao, DatasetEntity>
implements IBaseDataSetService {
    private static final Logger log = LoggerFactory.getLogger(JsonDataSetServiceImpl.class);
    @Resource
    private DatasetPermissionClient datasetPermissionClient;

    @Override
    public String add(DatasetEntity entity) {
        String id = IBaseDataSetService.super.add(entity);
        if (this.datasetPermissionClient.hasPermissionService()) {
            this.datasetPermissionClient.addPermission(id);
        }
        return id;
    }

    @Override
    public void delete(String id) {
        IBaseDataSetService.super.delete(id);
        if (this.datasetPermissionClient.hasPermissionService()) {
            this.datasetPermissionClient.deletePermission(id);
        }
    }

    @Override
    public Object execute(String id, List<DatasetParamDTO> params) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new GlobalException("\u6570\u636e\u96c6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DatasetEntity datasetEntity = this.getByIdFromCache(id);
        if (datasetEntity == null) {
            throw new GlobalException("\u6570\u636e\u96c6\u4e0d\u5b58\u5728");
        }
        log.info("\u6267\u884c\u3010{}\u3011\u6570\u636e\u96c6\uff08\u7c7b\u578b\uff1a\u3010JSON\u3011\uff0cID:\u3010{}\u3011\uff09", (Object)datasetEntity.getName(), (Object)datasetEntity.getId());
        JsonDataSetConfig config = (JsonDataSetConfig)datasetEntity.getConfig();
        String json = config.getJson();
        Object object = null;
        object = json.startsWith("[") ? JSON.parseArray((String)json) : JSON.parseObject((String)json);
        if (object == null) {
            throw new GlobalException("json\u683c\u5f0f\u9519\u8bef");
        }
        return object;
    }

    @Override
    public DataVO execute(TestExecuteDTO executeDTO) {
        String json = executeDTO.getScript();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new GlobalException("json\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Object object = null;
        object = json.startsWith("[") ? JSON.parseArray((String)json) : JSON.parseObject((String)json);
        if (object == null) {
            throw new GlobalException("json\u683c\u5f0f\u9519\u8bef");
        }
        DataVO dataVO = new DataVO();
        dataVO.setData(object);
        return dataVO;
    }
}

