/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataset.extend.dataset;

import com.gccloud.dataset.entity.DatasetEntity;
import com.gccloud.dataset.extend.dataset.IDatasetExtendService;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
public class DatasetExtendClient {
    @Autowired(required=false)
    @Lazy
    private List<IDatasetExtendService> extendServiceList;

    public Map<String, String> deleteCheck(String datasetId) {
        if (this.extendServiceList == null || this.extendServiceList.isEmpty()) {
            return new HashMap<String, String>();
        }
        HashMap reasons = Maps.newHashMap();
        this.extendServiceList.sort((o1, o2) -> {
            int order1 = this.getOrderValue(o1.getClass());
            int order2 = this.getOrderValue(o2.getClass());
            return order1 - order2;
        });
        for (IDatasetExtendService service : this.extendServiceList) {
            String checkResult = service.deleteCheck(datasetId);
            if (checkResult == null || "".equals(checkResult)) continue;
            String serviceType = service.getServiceType();
            if (StringUtils.isBlank((CharSequence)serviceType)) {
                serviceType = "\u4e1a\u52a1\u7cfb\u7edf";
            }
            if (reasons.containsKey(serviceType)) {
                checkResult = (String)reasons.get(serviceType) + "\n" + checkResult;
            }
            reasons.put(serviceType, checkResult);
        }
        return reasons;
    }

    private int getOrderValue(Class<?> clazz) {
        int order = Integer.MAX_VALUE;
        if (clazz.isAnnotationPresent(Order.class)) {
            order = clazz.getAnnotation(Order.class).value();
        }
        return order;
    }

    public List<Map<String, Object>> handleData(List<Map<String, Object>> data, DatasetEntity datasetEntity) {
        if (this.extendServiceList == null || this.extendServiceList.isEmpty()) {
            return data;
        }
        this.extendServiceList.sort((o1, o2) -> {
            int order1 = this.getOrderValue(o1.getClass());
            int order2 = this.getOrderValue(o2.getClass());
            return order1 - order2;
        });
        for (IDatasetExtendService service : this.extendServiceList) {
            data = service.handleData(data, datasetEntity);
        }
        return data;
    }
}

