/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataset.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.exception.ExcelAnalysisStopException;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.gccloud.common.permission.ApiPermission;
import com.gccloud.common.vo.PageVO;
import com.gccloud.common.vo.R;
import com.gccloud.dataset.dto.DatasetSearchDTO;
import com.gccloud.dataset.dto.DatasourceDTO;
import com.gccloud.dataset.dto.DatasourceSearchDTO;
import com.gccloud.dataset.dto.ExcelParseDTO;
import com.gccloud.dataset.entity.DatasetEntity;
import com.gccloud.dataset.entity.DatasourceEntity;
import com.gccloud.dataset.entity.config.OriginalDataSetConfig;
import com.gccloud.dataset.service.IBaseDatasourceService;
import com.gccloud.dataset.service.factory.DatasourceServiceFactory;
import com.gccloud.dataset.service.impl.dataset.BaseDatasetServiceImpl;
import com.gccloud.dataset.service.impl.datasource.BaseDatasourceServiceImpl;
import com.gccloud.dataset.vo.DeleteCheckVO;
import com.gccloud.dataset.vo.ExcelParseVO;
import com.gccloud.dataset.vo.FieldInfoVO;
import com.gccloud.dataset.vo.TableInfoVO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u6570\u636e\u6e90"})
@RestController
@RequestMapping(value={"/datasource"})
public class DatasourceController {
    private static final Logger log = LoggerFactory.getLogger(DatasourceController.class);
    @Resource
    private BaseDatasourceServiceImpl baseDatasourceService;
    @Resource
    private DatasourceServiceFactory datasourceServiceFactory;
    @Resource
    private BaseDatasetServiceImpl datasetService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/page"})
    @ApiPermission(permissions={"datasource:view"})
    public R<PageVO<DatasourceEntity>> getPage(DatasourceSearchDTO searchDTO) {
        PageVO page = this.baseDatasourceService.getPage(searchDTO);
        return R.success((Object)page);
    }

    @ApiOperation(value="\u5217\u8868")
    @GetMapping(value={"/list"})
    @ApiPermission(permissions={"datasource:view"})
    public R<List<DatasourceEntity>> getList(DatasourceSearchDTO searchDTO) {
        List list = this.baseDatasourceService.getList(searchDTO);
        return R.success((Object)list);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/add"})
    @ApiPermission(permissions={"datasource:add"})
    public R<String> add(@RequestBody DatasourceDTO datasource) {
        IBaseDatasourceService datasourceService = this.datasourceServiceFactory.build(datasource.getSourceType());
        String id = datasourceService.add(datasource);
        return R.success((Object)id);
    }

    @ApiOperation(value="\u4fee\u6539")
    @PostMapping(value={"/update"})
    @ApiPermission(permissions={"datasource:update"})
    public R<Void> update(@RequestBody DatasourceDTO datasource) {
        IBaseDatasourceService datasourceService = this.datasourceServiceFactory.build(datasource.getSourceType());
        datasourceService.update(datasource);
        return R.success();
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete/{id}"})
    @ApiPermission(permissions={"datasource:delete"})
    public R<Void> delete(@PathVariable String id) {
        this.baseDatasourceService.delete(id);
        return R.success();
    }

    @ApiOperation(value="\u5220\u9664\u524d\u68c0\u67e5")
    @PostMapping(value={"/deleteCheck/{id}"})
    @ApiPermission(permissions={"datasource:delete"})
    public R<DeleteCheckVO> deleteCheck(@PathVariable String id) {
        DeleteCheckVO deleteCheckVO = this.baseDatasourceService.deleteCheck(id);
        return R.success((Object)deleteCheckVO);
    }

    @ApiOperation(value="\u6d4b\u8bd5\u8fde\u63a5")
    @PostMapping(value={"/testConnect"})
    @ApiPermission(permissions={"datasource:test"})
    public R<String> testConnect(@RequestBody DatasourceEntity datasourceEntity) {
        if (StringUtils.isBlank((CharSequence)datasourceEntity.getSourceType())) {
            return R.error((String)"\u6570\u636e\u6e90\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        IBaseDatasourceService datasourceService = this.datasourceServiceFactory.build(datasourceEntity.getSourceType());
        String info = datasourceService.sourceLinkTest(datasourceEntity);
        return R.success((Object)info);
    }

    @ApiOperation(value="\u6570\u636e\u6e90\u540d\u79f0\u91cd\u590d\u5224\u65ad")
    @PostMapping(value={"/checkRepeat"})
    @ApiPermission(permissions={"datasource:view"})
    public R<Boolean> checkRepeat(@RequestBody DatasourceEntity datasource) {
        Boolean flag = this.baseDatasourceService.checkNameRepeat(datasource.getId(), datasource.getSourceName(), datasource.getModuleCode());
        return R.success((Object)flag);
    }

    @ApiOperation(value="\u67e5\u8be2\u6570\u636e\u6e90\u4e0b\u7684\u8868")
    @GetMapping(value={"/getTableList/{sourceId}"})
    @ApiPermission(permissions={"datasource:view"})
    public R<List<TableInfoVO>> getTableList(@PathVariable String sourceId) {
        DatasourceEntity datasourceEntity = (DatasourceEntity)((Object)this.baseDatasourceService.getById((Serializable)((Object)sourceId)));
        if (datasourceEntity == null) {
            return R.error((String)"\u6570\u636e\u6e90\u4e0d\u5b58\u5728");
        }
        IBaseDatasourceService datasourceService = this.datasourceServiceFactory.build(datasourceEntity.getSourceType());
        List<TableInfoVO> tableList = datasourceService.getTableList(datasourceEntity);
        DatasetSearchDTO searchDTO = new DatasetSearchDTO();
        searchDTO.setDatasetType(Lists.newArrayList((Object[])new String[]{"original"}));
        searchDTO.setSourceId(sourceId);
        List<DatasetEntity> originalList = this.datasetService.getList(searchDTO);
        List tableNameList = originalList.stream().map(dataset -> {
            OriginalDataSetConfig config = (OriginalDataSetConfig)dataset.getConfig();
            return config.getTableName();
        }).collect(Collectors.toList());
        tableList.forEach(table -> {
            if (tableNameList.contains(table.getName())) {
                table.setStatus(1);
            }
        });
        return R.success(tableList);
    }

    @ApiOperation(value="\u67e5\u8be2\u6570\u636e\u6e90\u4e0b\u7684\u89c6\u56fe")
    @GetMapping(value={"/getViewList/{sourceId}"})
    @ApiPermission(permissions={"datasource:view"})
    public R<List<TableInfoVO>> getViewList(@PathVariable String sourceId) {
        DatasourceEntity datasourceEntity = (DatasourceEntity)((Object)this.baseDatasourceService.getById((Serializable)((Object)sourceId)));
        if (datasourceEntity == null) {
            return R.error((String)"\u6570\u636e\u6e90\u4e0d\u5b58\u5728");
        }
        IBaseDatasourceService datasourceService = this.datasourceServiceFactory.build(datasourceEntity.getSourceType());
        List<TableInfoVO> viewList = datasourceService.getViewList(datasourceEntity);
        DatasetSearchDTO searchDTO = new DatasetSearchDTO();
        searchDTO.setDatasetType(Lists.newArrayList((Object[])new String[]{"original"}));
        searchDTO.setSourceId(sourceId);
        List<DatasetEntity> originalList = this.datasetService.getList(searchDTO);
        List tableNameList = originalList.stream().map(dataset -> {
            OriginalDataSetConfig config = (OriginalDataSetConfig)dataset.getConfig();
            return config.getTableName();
        }).collect(Collectors.toList());
        viewList.forEach(view -> {
            if (tableNameList.contains(view.getName())) {
                view.setStatus(1);
            }
        });
        return R.success(viewList);
    }

    @ApiOperation(value="\u67e5\u8be2\u6570\u636e\u6e90\u4e0b\u8868\u7684\u5b57\u6bb5\u4fe1\u606f")
    @GetMapping(value={"/getFieldList/table/{sourceId}/{tableName}"})
    @ApiPermission(permissions={"datasource:view"})
    public R<List<FieldInfoVO>> getTableFieldList(@PathVariable String sourceId, @PathVariable String tableName) {
        DatasourceEntity datasourceEntity = (DatasourceEntity)((Object)this.baseDatasourceService.getById((Serializable)((Object)sourceId)));
        if (datasourceEntity == null) {
            return R.error((String)"\u6570\u636e\u6e90\u4e0d\u5b58\u5728");
        }
        IBaseDatasourceService datasourceService = this.datasourceServiceFactory.build(datasourceEntity.getSourceType());
        List<FieldInfoVO> fieldList = datasourceService.getTableColumnList(datasourceEntity, tableName);
        return R.success(fieldList);
    }

    @ApiOperation(value="\u67e5\u8be2\u6570\u636e\u6e90\u4e0b\u8868\u7684\u5b57\u6bb5\u4fe1\u606f")
    @GetMapping(value={"/getFieldList/view/{sourceId}/{tableName}"})
    @ApiPermission(permissions={"datasource:view"})
    public R<List<FieldInfoVO>> getViewFieldList(@PathVariable String sourceId, @PathVariable String tableName) {
        DatasourceEntity datasourceEntity = (DatasourceEntity)((Object)this.baseDatasourceService.getById((Serializable)((Object)sourceId)));
        if (datasourceEntity == null) {
            return R.error((String)"\u6570\u636e\u6e90\u4e0d\u5b58\u5728");
        }
        IBaseDatasourceService datasourceService = this.datasourceServiceFactory.build(datasourceEntity.getSourceType());
        List<FieldInfoVO> fieldList = datasourceService.getViewColumnList(datasourceEntity, tableName);
        return R.success(fieldList);
    }

    @ApiOperation(value="Excel\u6587\u4ef6\u4e0a\u4f20")
    @PostMapping(value={"/uploadExcel"})
    public R<String> uploadExcel(@RequestParam(value="file") MultipartFile file) {
        File[] files;
        File dir = new File(System.getProperty("java.io.tmpdir") + File.separator + "datasourceFile");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((files = dir.listFiles()) != null) {
            for (File f : files) {
                if (f.lastModified() >= System.currentTimeMillis() - 86400000L) continue;
                f.delete();
            }
        }
        String fileName = System.currentTimeMillis() + RandomStringUtils.randomAlphanumeric((int)6) + ".xlsx";
        String filePath = System.getProperty("java.io.tmpdir") + File.separator + "datasourceFile" + File.separator + fileName;
        try {
            file.transferTo(new File(filePath));
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            return R.error((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
        }
        return R.success((Object)fileName);
    }

    @ApiOperation(value="Excel\u6587\u4ef6\u89e3\u6790")
    @PostMapping(value={"/parseExcel"})
    public R<ExcelParseVO> parseExcel(@RequestBody ExcelParseDTO parseDTO) {
        String filePath = System.getProperty("java.io.tmpdir") + File.separator + "datasourceFile" + File.separator + parseDTO.getFileName();
        File file = new File(filePath);
        if (!file.exists()) {
            return R.error((String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        final ArrayList dataList = Lists.newArrayList();
        final Map[] headInfo = new Map[]{Maps.newLinkedHashMap()};
        String suffix = FilenameUtils.getExtension((String)filePath);
        ArrayList suffixList = Lists.newArrayList((Object[])new String[]{"xls", "xlsx"});
        if (!suffixList.contains(suffix)) {
            return R.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        ((ExcelReaderBuilder)EasyExcel.read((File)file, (ReadListener)new AnalysisEventListener<Map<Integer, Object>>(){

            public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
                headInfo[0] = headMap;
            }

            public void invoke(Map<Integer, Object> data, AnalysisContext context) {
                if (dataList.size() > 10) {
                    throw new ExcelAnalysisStopException();
                }
                dataList.add(data);
            }

            public void doAfterAllAnalysed(AnalysisContext context) {
            }
        }).headRowNumber(parseDTO.getHeadRowNum())).sheet().doRead();
        ArrayList previewList = Lists.newArrayList();
        for (Object dataMap : dataList) {
            LinkedHashMap previewMap = Maps.newLinkedHashMap();
            for (Integer index : dataMap.keySet()) {
                String headName = (String)headInfo[0].get(index);
                Object value = dataMap.get(index);
                previewMap.put(headName, value);
                previewList.add(previewMap);
            }
        }
        ArrayList headInfoList = Lists.newArrayList();
        for (Integer index : headInfo[0].keySet()) {
            LinkedHashMap headerConfig = Maps.newLinkedHashMap();
            headerConfig.put("index", index);
            headerConfig.put("title", headInfo[0].get(index));
            headerConfig.put("field", "column" + index);
            headInfoList.add(headerConfig);
        }
        ExcelParseVO parseVO = new ExcelParseVO();
        parseVO.setHeadMap(headInfoList);
        parseVO.setDataList(previewList);
        return R.success((Object)parseVO);
    }
}

