/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataroom.core.utils;

import com.gccloud.dataroom.core.config.bean.DataRoomFtpConfig;
import com.gccloud.dataroom.core.module.file.service.pool.ftp.FtpPoolServiceImpl;
import com.gccloud.dataroom.core.utils.PathUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="gc.starter.file", name={"type"}, havingValue="ftp")
public class FtpClientUtil {
    private static final Logger log = LoggerFactory.getLogger(FtpClientUtil.class);
    @Resource
    private DataRoomFtpConfig config;
    @Resource
    private FtpPoolServiceImpl ftpPoolService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upload(String uploadPath, String fileName, InputStream input) {
        String[] paths = PathUtils.handlePath(uploadPath, fileName);
        uploadPath = paths[0];
        fileName = paths[1];
        boolean success = false;
        FTPClient ftpClient = this.ftpPoolService.borrowObject();
        try {
            boolean changeSuccess = this.changeWorkingDirectory(uploadPath, ftpClient);
            if (!changeSuccess) {
                log.info("\u5207\u6362\u76ee\u5f55\u5931\u8d25,\u76ee\u5f55:{}", (Object)uploadPath);
                boolean bl = false;
                return bl;
            }
            String workingDir = ftpClient.printWorkingDirectory();
            log.info("\u5f53\u524d\u5de5\u4f5c\u76ee\u5f55:{}", (Object)workingDir);
            ftpClient.enterLocalPassiveMode();
            ftpClient.setControlEncoding("UTF-8");
            ftpClient.setBufferSize(this.config.getBufferSize());
            ftpClient.setFileType(2);
            ftpClient.setFileTransferMode(10);
            success = ftpClient.storeFile(fileName, input);
            if (success) {
                log.info("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f:{}", (Object)(uploadPath + "/" + fileName));
            } else {
                log.info("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25:{}", (Object)(uploadPath + "/" + fileName));
            }
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            if (null != input) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    log.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
            this.ftpPoolService.returnObject(ftpClient);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean download(String ftpPath, String ftpFileName, OutputStream outputStream) {
        String[] paths = PathUtils.handlePath(ftpPath, ftpFileName);
        ftpPath = paths[0] + "/";
        ftpFileName = paths[1];
        FTPClient ftpClient = this.ftpPoolService.borrowObject();
        try {
            String finalFtpFileName = ftpFileName;
            FTPFile[] ftpFiles = ftpClient.listFiles(ftpPath, file -> file.isFile() && file.getName().equals(finalFtpFileName));
            if (ftpFiles == null || ftpFiles.length == 0) {
                log.info("FTP\u670d\u52a1\u5668\u6587\u4ef6\u4e0d\u5b58\u5728:{}", (Object)(ftpPath + ftpFileName));
                boolean bl = false;
                return bl;
            }
            ftpClient.setControlEncoding("UTF-8");
            ftpClient.setFileType(2);
            ftpClient.enterLocalPassiveMode();
            ftpClient.changeWorkingDirectory(ftpPath);
            boolean success = ftpClient.retrieveFile(finalFtpFileName, outputStream);
            if (!success) {
                log.info("FTP\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25:{}", (Object)(ftpPath + ftpFileName));
                boolean bl = false;
                return bl;
            }
            log.info("FTP\u6587\u4ef6\u4e0b\u8f7d\u6210\u529f:{}", (Object)(ftpPath + ftpFileName));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.info("FTP\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25:{}", (Object)(ftpPath + ftpFileName));
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
            this.ftpPoolService.returnObject(ftpClient);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String ftpPath, String fileName) {
        String[] paths = PathUtils.handlePath(ftpPath, fileName);
        ftpPath = paths[0] + "/";
        fileName = paths[1];
        FTPClient ftpClient = this.ftpPoolService.borrowObject();
        try {
            String finalFileName = fileName;
            FTPFile[] ftpFiles = ftpClient.listFiles(ftpPath, file -> file.isFile() && file.getName().equals(finalFileName));
            if (ftpFiles == null || ftpFiles.length == 0) {
                log.error("FTP\u670d\u52a1\u5668\u6587\u4ef6\u4e0d\u5b58\u5728:{},", (Object)(ftpPath + fileName));
                boolean bl = false;
                return bl;
            }
            ftpClient.changeWorkingDirectory(ftpPath);
            boolean del = ftpClient.deleteFile(finalFileName);
            log.info(del ? "\u6587\u4ef6:{}\u5220\u9664\u6210\u529f" : "\u6587\u4ef6:{}\u5220\u9664\u5931\u8d25", (Object)(ftpPath + fileName));
            boolean bl = del;
            return bl;
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            this.ftpPoolService.returnObject(ftpClient);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copy(String sourcePath, String targetPath) {
        sourcePath = PathUtils.normalizePath(sourcePath);
        targetPath = PathUtils.normalizePath(targetPath);
        String[] sourceSplit = sourcePath.split("/");
        String[] targetSplit = targetPath.split("/");
        sourcePath = sourcePath.substring(0, sourcePath.length() - sourceSplit[sourceSplit.length - 1].length());
        targetPath = targetPath.substring(0, targetPath.length() - targetSplit[targetSplit.length - 1].length());
        String sourceFileName = sourceSplit[sourceSplit.length - 1];
        String targetFileName = targetSplit[targetSplit.length - 1];
        FTPClient ftpClient = this.ftpPoolService.borrowObject();
        try {
            FTPFile[] ftpFiles = ftpClient.listFiles(sourcePath, file -> file.isFile() && file.getName().equals(sourceFileName));
            if (ftpFiles == null || ftpFiles.length == 0) {
                log.error("FTP\u670d\u52a1\u5668\u6587\u4ef6\u4e0d\u5b58\u5728:{}", (Object)(sourcePath + sourceFileName));
                boolean bl = false;
                return bl;
            }
            ftpClient.setControlEncoding("UTF-8");
            ftpClient.setFileType(2);
            ftpClient.enterLocalPassiveMode();
            ftpClient.changeWorkingDirectory(sourcePath);
            boolean success = ftpClient.retrieveFile(sourceFileName, (OutputStream)new FileOutputStream(targetPath + targetFileName));
            if (!success) {
                log.error("FTP\u6587\u4ef6\u590d\u5236\u5931\u8d25:{}", (Object)(sourcePath + sourceFileName));
                boolean bl = false;
                return bl;
            }
            log.info("FTP\u6587\u4ef6\u590d\u5236\u6210\u529f:{}", (Object)(targetPath + targetFileName));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.info("FTP\u6587\u4ef6\u590d\u5236\u5931\u8d25:{}", (Object)(sourcePath + sourceFileName));
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            this.ftpPoolService.returnObject(ftpClient);
        }
        return false;
    }

    private boolean changeWorkingDirectory(String workPath, FTPClient ftpClient) throws IOException {
        boolean success = ftpClient.changeWorkingDirectory(workPath);
        if (!success) {
            String[] dirs;
            for (String str : dirs = workPath.split("/")) {
                if (StringUtils.isBlank((CharSequence)str) || ftpClient.changeWorkingDirectory(str)) continue;
                boolean makeDirectory = ftpClient.makeDirectory(str);
                log.info("\u521b\u5efa\u76ee\u5f55:{}, \u7ed3\u679c: {}", (Object)str, (Object)(makeDirectory ? "\u6210\u529f" : "\u5931\u8d25"));
                success = ftpClient.changeWorkingDirectory(str);
            }
        }
        return success;
    }
}

