/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataroom.core.module.type.controller;

import com.gccloud.common.utils.BeanConvertUtils;
import com.gccloud.common.validator.ValidatorUtils;
import com.gccloud.common.validator.group.Insert;
import com.gccloud.common.validator.group.Update;
import com.gccloud.common.vo.R;
import com.gccloud.dataroom.core.module.type.dto.TypeDTO;
import com.gccloud.dataroom.core.module.type.entity.TypeEntity;
import com.gccloud.dataroom.core.module.type.service.ITypeService;
import com.gccloud.dataroom.core.module.type.vo.TypeVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="dataRoomTypeController")
@RequestMapping(value={"/bigScreen/type"})
@Api(tags={"\u5206\u7c7b\u7ba1\u7406"})
public class TypeController {
    private static final Logger log = LoggerFactory.getLogger(TypeController.class);
    @Resource
    private ITypeService typeService;

    @GetMapping(value={"/list/{type}"})
    @ApiOperation(value="\u5206\u7c7b\u5217\u8868", position=10, produces="application/json")
    public R<List<TypeVO>> list(@PathVariable(value="type") String type) {
        List<TypeEntity> entityList = this.typeService.listByType(type);
        List typeVOList = BeanConvertUtils.convert(entityList, TypeVO.class);
        return R.success((Object)typeVOList);
    }

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u65b0\u589e\u5206\u7c7b", position=10, produces="application/json")
    public R<String> add(@RequestBody TypeDTO typeDTO) {
        ValidatorUtils.validateEntity((Object)typeDTO, (Class[])new Class[]{Insert.class});
        String id = this.typeService.add(typeDTO);
        return R.success((Object)id);
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u5206\u7c7b", position=20, produces="application/json")
    public R<String> update(@RequestBody TypeDTO typeDTO) {
        ValidatorUtils.validateEntity((Object)typeDTO, (Class[])new Class[]{Update.class});
        this.typeService.update(typeDTO);
        return R.success();
    }

    @PostMapping(value={"/delete/{id}"})
    @ApiOperation(value="\u5220\u9664\u5206\u7c7b", position=30, produces="application/json")
    public R<String> delete(@PathVariable(value="id") String id) {
        this.typeService.deleteById(id);
        return R.success();
    }

    @PostMapping(value={"/nameRepeat"})
    @ApiOperation(value="\u5206\u7c7b\u540d\u79f0\u91cd\u590d\u6821\u9a8c", position=40, produces="application/json")
    public R<Boolean> nameRepeat(@RequestBody TypeDTO typeDTO) {
        Boolean flag = this.typeService.checkNameRepeat(typeDTO.getId(), typeDTO.getType(), typeDTO.getName());
        return R.success((Object)flag);
    }
}

