/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataroom.core.module.template.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gccloud.common.exception.GlobalException;
import com.gccloud.common.vo.PageVO;
import com.gccloud.dataroom.core.module.basic.dto.BasePageDTO;
import com.gccloud.dataroom.core.module.chart.components.datasource.DataSetDataSource;
import com.gccloud.dataroom.core.module.manage.dto.DataRoomPageDTO;
import com.gccloud.dataroom.core.module.template.dao.DataRoomPageTemplateDao;
import com.gccloud.dataroom.core.module.template.dto.PageTemplateSearchDTO;
import com.gccloud.dataroom.core.module.template.entity.PageTemplateEntity;
import com.gccloud.dataroom.core.module.template.service.IPageTemplateService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="dataRoomPageTemplateService")
public class PageTemplateServiceImpl
extends ServiceImpl<DataRoomPageTemplateDao, PageTemplateEntity>
implements IPageTemplateService {
    @Override
    public PageVO<PageTemplateEntity> getPage(PageTemplateSearchDTO searchDTO) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)searchDTO.getType()), PageTemplateEntity::getType, (Object)searchDTO.getType());
        return this.page(searchDTO, queryWrapper);
    }

    @Override
    public List<PageTemplateEntity> getList(PageTemplateSearchDTO searchDTO) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)searchDTO.getType()), PageTemplateEntity::getType, (Object)searchDTO.getType());
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public String add(PageTemplateEntity pageTemplate) {
        BasePageDTO config = pageTemplate.getConfig();
        ((DataRoomPageDTO)config).setId(null);
        ((DataRoomPageDTO)config).getChartList().forEach(chart -> {
            chart.setDataSource(new DataSetDataSource());
            chart.setCode(null);
        });
        this.save((Object)pageTemplate);
        return pageTemplate.getId();
    }

    @Override
    public void deleteByIds(List<String> ids) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        this.removeByIds(ids);
    }

    @Override
    public void update(PageTemplateEntity pageTemplate) {
        if (StringUtils.isBlank((CharSequence)pageTemplate.getId())) {
            throw new GlobalException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.updateById((Object)pageTemplate);
    }
}

