/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataroom.core.module.map.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gccloud.common.entity.SuperEntity;
import com.gccloud.common.exception.GlobalException;
import com.gccloud.common.utils.BeanConvertUtils;
import com.gccloud.common.utils.JSON;
import com.gccloud.common.utils.QueryWrapperUtils;
import com.gccloud.dataroom.core.module.map.dao.DataRoomMapDao;
import com.gccloud.dataroom.core.module.map.dto.DataRoomMapDTO;
import com.gccloud.dataroom.core.module.map.dto.DataRoomMapRepeatDTO;
import com.gccloud.dataroom.core.module.map.dto.MapSearchDTO;
import com.gccloud.dataroom.core.module.map.entity.DataRoomMapEntity;
import com.gccloud.dataroom.core.module.map.service.IDataRoomMapService;
import com.gccloud.dataroom.core.module.map.vo.DataRoomMapVO;
import com.gccloud.dataroom.core.module.map.vo.MapChildVO;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Service;

@Service
public class DataRoomMapServiceImpl
extends ServiceImpl<DataRoomMapDao, DataRoomMapEntity>
implements IDataRoomMapService {
    public static final int YES = 1;
    public static final int NO = 0;

    @Override
    public List<DataRoomMapVO> getList(MapSearchDTO searchDTO) {
        if (StringUtils.isNotBlank((CharSequence)searchDTO.getSearchKey())) {
            searchDTO.setParentId(null);
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.select((Object[])new SFunction[]{DataRoomMapEntity::getParentId});
        List list = this.list((Wrapper)queryWrapper);
        Set parentIds = list.stream().map(DataRoomMapEntity::getParentId).collect(Collectors.toSet());
        LambdaQueryWrapper wrapper = QueryWrapperUtils.wrapperLike((LambdaQueryWrapper)new LambdaQueryWrapper(), (String)searchDTO.getSearchKey(), (SFunction[])new SFunction[]{DataRoomMapEntity::getName, DataRoomMapEntity::getMapCode});
        wrapper.eq(searchDTO.getLevel() != null, DataRoomMapEntity::getLevel, (Object)searchDTO.getLevel());
        wrapper.eq(StringUtils.isNotBlank((CharSequence)searchDTO.getParentId()), DataRoomMapEntity::getParentId, (Object)searchDTO.getParentId());
        wrapper.eq(searchDTO.getUploadedGeoJson() != null, DataRoomMapEntity::getUploadedGeoJson, (Object)searchDTO.getUploadedGeoJson());
        wrapper.orderByDesc(SuperEntity::getCreateDate);
        List entityList = this.list((Wrapper)wrapper);
        List idList = entityList.stream().map(SuperEntity::getId).collect(Collectors.toList());
        ArrayList voList = Lists.newArrayList();
        for (DataRoomMapEntity entity : entityList) {
            if (idList.contains(entity.getParentId())) continue;
            DataRoomMapVO mapVO = (DataRoomMapVO)BeanConvertUtils.convert((Object)((Object)entity), DataRoomMapVO.class);
            mapVO.setHasChildren(parentIds.contains(entity.getId()));
            voList.add(mapVO);
        }
        return voList;
    }

    @Override
    public List<DataRoomMapVO> getAvailableTree(Integer level) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.select((Object[])new SFunction[]{SuperEntity::getId, DataRoomMapEntity::getLevel, DataRoomMapEntity::getParentId, DataRoomMapEntity::getMapCode, DataRoomMapEntity::getName, DataRoomMapEntity::getUploadedGeoJson});
        queryWrapper.le(DataRoomMapEntity::getLevel, (Object)level);
        List list = this.list((Wrapper)queryWrapper);
        return this.convertToTree(list, level);
    }

    private List<DataRoomMapVO> convertToTree(List<DataRoomMapEntity> list, Integer targetLevel) {
        DataRoomMapVO parent;
        List voList = BeanConvertUtils.convert(list, DataRoomMapVO.class);
        ArrayList rootList = Lists.newArrayList();
        HashMap<String, DataRoomMapVO> map = new HashMap<String, DataRoomMapVO>();
        voList.forEach(vo -> map.put(vo.getId(), (DataRoomMapVO)vo));
        List targetLevelList = voList.stream().filter(vo -> vo.getLevel().equals(targetLevel)).collect(Collectors.toList());
        ArrayList match = Lists.newArrayList(targetLevelList);
        Iterator<Object> iterator = targetLevelList.iterator();
        while (iterator.hasNext()) {
            DataRoomMapVO mapVO;
            mapVO.setDisabled(!(mapVO = (DataRoomMapVO)iterator.next()).getUploadedGeoJson().equals(1));
            if (mapVO.getLevel().equals(0) || (parent = (DataRoomMapVO)map.get(mapVO.getParentId())) == null) continue;
            this.getParentMap(parent, map, match);
        }
        for (DataRoomMapVO vo2 : match) {
            if (vo2.getParentId().equals("0")) {
                rootList.add(vo2);
                continue;
            }
            parent = (DataRoomMapVO)map.get(vo2.getParentId());
            if (parent == null) continue;
            if (parent.getChildren() == null) {
                parent.setChildren(Lists.newArrayList());
            }
            parent.getChildren().add(vo2);
        }
        return rootList;
    }

    private void getParentMap(DataRoomMapVO parentMap, Map<String, DataRoomMapVO> mapIdMap, List<DataRoomMapVO> match) {
        if (parentMap == null) {
            return;
        }
        if (match.contains(parentMap)) {
            return;
        }
        match.add(parentMap);
        if (parentMap.getLevel().equals(0)) {
            return;
        }
        DataRoomMapVO parent = mapIdMap.get(parentMap.getParentId());
        this.getParentMap(parent, mapIdMap, match);
    }

    @Override
    public String add(DataRoomMapDTO mapDTO) {
        if (StringUtils.isBlank((CharSequence)mapDTO.getParentId())) {
            mapDTO.setParentId("0");
        }
        if (StringUtils.isBlank((CharSequence)mapDTO.getMapCode())) {
            throw new GlobalException("\u5730\u56fe\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DataRoomMapEntity mapEntity = (DataRoomMapEntity)((Object)BeanConvertUtils.convert((Object)mapDTO, DataRoomMapEntity.class));
        if (StringUtils.isNotBlank((CharSequence)mapEntity.getGeoJson())) {
            mapEntity.setUploadedGeoJson(1);
        } else {
            mapEntity.setUploadedGeoJson(0);
        }
        this.save((Object)mapEntity);
        if (mapDTO.getAutoParseNextLevel().equals(1) && mapEntity.getUploadedGeoJson().equals(1)) {
            this.parseNextLevelAndSave(mapEntity, mapEntity.getGeoJson());
        }
        return mapEntity.getId();
    }

    @Override
    public void update(DataRoomMapDTO mapDTO) {
        if (StringUtils.isBlank((CharSequence)mapDTO.getId())) {
            throw new GlobalException("\u5730\u56feid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DataRoomMapEntity old = (DataRoomMapEntity)((Object)this.getById((Serializable)((Object)mapDTO.getId())));
        if (old == null) {
            throw new GlobalException("\u5730\u56fe\u4e0d\u5b58\u5728");
        }
        Integer uploadedGeoJson = old.getUploadedGeoJson();
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(SuperEntity::getId, (Object)mapDTO.getId());
        updateWrapper.set(DataRoomMapEntity::getName, (Object)mapDTO.getName());
        updateWrapper.set(!old.getMapCode().equals(mapDTO.getMapCode()), DataRoomMapEntity::getMapCode, (Object)mapDTO.getMapCode());
        if (!uploadedGeoJson.equals(1) && StringUtils.isNotBlank((CharSequence)mapDTO.getGeoJson())) {
            if (mapDTO.getAutoParseNextLevel().equals(1)) {
                this.parseNextLevelAndSave(old, mapDTO.getGeoJson());
            }
            updateWrapper.set(DataRoomMapEntity::getGeoJson, (Object)mapDTO.getGeoJson());
            updateWrapper.set(DataRoomMapEntity::getUploadedGeoJson, (Object)1);
        }
        this.update((Wrapper)updateWrapper);
        if (!old.getMapCode().equals(mapDTO.getMapCode())) {
            this.updateParentJson(old.getParentId(), old.getMapCode(), mapDTO.getMapCode());
        }
    }

    private void parseNextLevelAndSave(DataRoomMapEntity mapEntity, String geoJson) {
        JSONObject jsonObject = new JSONObject(geoJson);
        if (!jsonObject.has("features")) {
            throw new GlobalException("GeoJson\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u81ea\u52a8\u89e3\u6790\u5931\u8d25");
        }
        JSONArray features = jsonObject.getJSONArray("features");
        if (features == null || features.length() == 0) {
            throw new GlobalException("GeoJson\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u81ea\u52a8\u89e3\u6790\u5931\u8d25");
        }
        ArrayList mapEntityList = Lists.newArrayList();
        for (int i = 0; i < features.length(); ++i) {
            JSONObject feature = features.getJSONObject(i);
            JSONObject properties = feature.getJSONObject("properties");
            if (properties == null) continue;
            DataRoomMapEntity childMapEntity = new DataRoomMapEntity();
            childMapEntity.setParentId(mapEntity.getId());
            childMapEntity.setLevel(mapEntity.getLevel() + 1);
            childMapEntity.setMapCode(properties.getString("name"));
            childMapEntity.setName(properties.getString("name"));
            childMapEntity.setUploadedGeoJson(0);
            mapEntityList.add(childMapEntity);
        }
        if (mapEntityList.size() > 0) {
            this.saveBatch(mapEntityList);
        }
    }

    private void updateParentJson(String parentId, String oldCode, String newMapCode) {
        if (StringUtils.isBlank((CharSequence)parentId) || parentId.equals("0")) {
            return;
        }
        DataRoomMapEntity parent = (DataRoomMapEntity)((Object)this.getById((Serializable)((Object)parentId)));
        String geoJson = parent.getGeoJson();
        if (StringUtils.isBlank((CharSequence)geoJson)) {
            return;
        }
        JSONObject jsonObject = new JSONObject(geoJson);
        JSONArray features = jsonObject.getJSONArray("features");
        if (features == null || features.length() == 0) {
            return;
        }
        for (int i = 0; i < features.length(); ++i) {
            String name;
            JSONObject feature = features.getJSONObject(i);
            JSONObject properties = feature.getJSONObject("properties");
            if (properties == null || !oldCode.equals(name = properties.getString("name"))) continue;
            properties.put("name", (Object)newMapCode);
            break;
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(SuperEntity::getId, (Object)parentId);
        updateWrapper.set(DataRoomMapEntity::getGeoJson, (Object)jsonObject.toString());
        this.update((Wrapper)updateWrapper);
    }

    @Override
    public boolean delete(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return true;
        }
        DataRoomMapEntity mapEntity = (DataRoomMapEntity)((Object)this.getById((Serializable)((Object)id)));
        if (mapEntity == null) {
            return true;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DataRoomMapEntity::getParentId, (Object)mapEntity.getId());
        List list = this.list((Wrapper)queryWrapper);
        if (list != null && list.size() > 0) {
            return false;
        }
        this.removeById((Serializable)((Object)id));
        return true;
    }

    @Override
    public void cascadingDelete(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return;
        }
        DataRoomMapEntity mapEntity = (DataRoomMapEntity)((Object)this.getById((Serializable)((Object)id)));
        if (mapEntity == null) {
            return;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DataRoomMapEntity::getParentId, (Object)mapEntity.getId());
        List list = this.list((Wrapper)queryWrapper);
        if (list != null && list.size() > 0) {
            for (DataRoomMapEntity entity : list) {
                this.cascadingDelete(entity.getId());
            }
        }
        this.removeById((Serializable)((Object)id));
    }

    @Override
    public DataRoomMapEntity info(String id) {
        DataRoomMapEntity mapEntity = (DataRoomMapEntity)((Object)this.getById((Serializable)((Object)id)));
        if (mapEntity == null) {
            throw new GlobalException("\u5730\u56fe\u4e0d\u5b58\u5728");
        }
        return mapEntity;
    }

    @Override
    public DataRoomMapEntity getByParentIdAndCode(String parentId, String code) {
        if (StringUtils.isBlank((CharSequence)parentId)) {
            parentId = "0";
        }
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new GlobalException("\u5730\u56fe\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DataRoomMapEntity::getParentId, (Object)parentId);
        queryWrapper.eq(DataRoomMapEntity::getMapCode, (Object)code);
        List list = this.list((Wrapper)queryWrapper);
        if (list == null || list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            throw new GlobalException("\u5730\u56fe\u7f16\u7801\u91cd\u590d");
        }
        return (DataRoomMapEntity)((Object)list.get(0));
    }

    @Override
    public DataRoomMapEntity infoByMapCode(String mapCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DataRoomMapEntity::getMapCode, (Object)mapCode);
        List list = this.list((Wrapper)queryWrapper);
        if (list == null || list.size() == 0) {
            throw new GlobalException("\u5730\u56fe\u4e0d\u5b58\u5728");
        }
        if (list.size() > 1) {
            throw new GlobalException("\u5730\u56fe\u7f16\u7801\u91cd\u590d");
        }
        return (DataRoomMapEntity)((Object)list.get(0));
    }

    @Override
    public List<MapChildVO> getChildFromGeo(String id) {
        DataRoomMapEntity mapEntity = (DataRoomMapEntity)((Object)this.getById((Serializable)((Object)id)));
        if (mapEntity.getUploadedGeoJson().equals(0)) {
            return Lists.newArrayList();
        }
        String geoJson = mapEntity.getGeoJson();
        if (StringUtils.isBlank((CharSequence)geoJson)) {
            return Lists.newArrayList();
        }
        JSONObject geoObj = JSON.parseObject((String)geoJson);
        if (!geoObj.has("features")) {
            throw new GlobalException("geoJson\u683c\u5f0f\u9519\u8bef\uff0c\u7f3a\u5c11features");
        }
        JSONArray features = geoObj.getJSONArray("features");
        if (features == null || features.length() == 0) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.select((Object[])new SFunction[]{DataRoomMapEntity::getMapCode, SuperEntity::getId});
        queryWrapper.eq(DataRoomMapEntity::getParentId, (Object)id);
        List list = this.list((Wrapper)queryWrapper);
        Map<String, String> codeIdMap = list.stream().collect(Collectors.toMap(DataRoomMapEntity::getMapCode, SuperEntity::getId));
        ArrayList childList = Lists.newArrayList();
        for (int i = 0; i < features.length(); ++i) {
            JSONObject feature = features.getJSONObject(i);
            JSONObject properties = feature.getJSONObject("properties");
            if (!properties.has("name")) continue;
            String name = properties.getString("name");
            MapChildVO childVO = new MapChildVO();
            childVO.setName(name);
            childVO.setExist(codeIdMap.containsKey(name));
            if (childVO.getExist().booleanValue()) {
                childVO.setExistId(codeIdMap.get(name));
            }
            childList.add(childVO);
        }
        return childList;
    }

    @Override
    public void uploadGeoJson(String id, String geoJson) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new GlobalException("\u5730\u56feid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)geoJson)) {
            throw new GlobalException("geoJson\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DataRoomMapEntity mapEntity = (DataRoomMapEntity)((Object)this.getById((Serializable)((Object)id)));
        if (mapEntity == null) {
            throw new GlobalException("\u5730\u56fe\u4e0d\u5b58\u5728");
        }
        if (mapEntity.getUploadedGeoJson().equals(1)) {
            throw new GlobalException("\u8be5\u5730\u56fe\u5df2\u4e0a\u4f20\u8fc7geoJson\uff0c\u4e0d\u80fd\u91cd\u590d\u4e0a\u4f20");
        }
        mapEntity.setGeoJson(geoJson);
        mapEntity.setUploadedGeoJson(1);
        this.updateById((Object)mapEntity);
    }

    @Override
    public boolean codeRepeatCheck(DataRoomMapRepeatDTO mapDTO) {
        List list;
        if (StringUtils.isBlank((CharSequence)mapDTO.getMapCode())) {
            throw new GlobalException("\u5730\u56fe\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)mapDTO.getParentId())) {
            throw new GlobalException("\u4e0a\u7ea7\u5730\u56fe\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DataRoomMapEntity::getMapCode, (Object)mapDTO.getMapCode());
        queryWrapper.eq(DataRoomMapEntity::getParentId, (Object)mapDTO.getParentId());
        if (StringUtils.isNotBlank((CharSequence)mapDTO.getId())) {
            queryWrapper.ne(SuperEntity::getId, (Object)mapDTO.getId());
        }
        return (list = this.list((Wrapper)queryWrapper)) != null && list.size() > 0;
    }

    @Override
    public boolean nameRepeatCheck(DataRoomMapRepeatDTO mapDTO) {
        List list;
        if (StringUtils.isBlank((CharSequence)mapDTO.getMapName())) {
            throw new GlobalException("\u5730\u56fe\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)mapDTO.getParentId())) {
            throw new GlobalException("\u4e0a\u7ea7\u5730\u56fe\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DataRoomMapEntity::getName, (Object)mapDTO.getMapName());
        queryWrapper.eq(DataRoomMapEntity::getParentId, (Object)mapDTO.getParentId());
        if (StringUtils.isNotBlank((CharSequence)mapDTO.getId())) {
            queryWrapper.ne(SuperEntity::getId, (Object)mapDTO.getId());
        }
        return (list = this.list((Wrapper)queryWrapper)) != null && list.size() > 0;
    }
}

