/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataroom.core.module.map.controller;

import com.gccloud.common.permission.ApiPermission;
import com.gccloud.common.utils.BeanConvertUtils;
import com.gccloud.common.vo.R;
import com.gccloud.dataroom.core.module.map.dto.DataRoomMapDTO;
import com.gccloud.dataroom.core.module.map.dto.DataRoomMapRepeatDTO;
import com.gccloud.dataroom.core.module.map.dto.MapSearchDTO;
import com.gccloud.dataroom.core.module.map.entity.DataRoomMapEntity;
import com.gccloud.dataroom.core.module.map.service.IDataRoomMapService;
import com.gccloud.dataroom.core.module.map.vo.DataRoomMapDataVO;
import com.gccloud.dataroom.core.module.map.vo.DataRoomMapVO;
import com.gccloud.dataroom.core.module.map.vo.MapChildVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiSort;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bigScreen/map"})
@Api(tags={"\u5730\u56fe\u6570\u636e\u7ba1\u7406"})
@ApiSort(value=110)
public class DataRoomMapController {
    private static final Logger log = LoggerFactory.getLogger(DataRoomMapController.class);
    @Resource
    private IDataRoomMapService dataRoomMapService;

    @ApiPermission(permissions={"map:view"})
    @GetMapping(value={"/list"})
    @ApiOperation(value="\u5217\u8868", position=10, notes="\u5730\u56fe\u6570\u636e\u5217\u8868\u67e5\u8be2", produces="application/json")
    public R<List<DataRoomMapVO>> list(MapSearchDTO searchDTO) {
        List<DataRoomMapVO> list = this.dataRoomMapService.getList(searchDTO);
        return R.success(list);
    }

    @ApiPermission(permissions={"map:add"})
    @PostMapping(value={"/add"})
    @ApiOperation(value="\u6dfb\u52a0", position=20, notes="\u6dfb\u52a0\u5730\u56fe\u6570\u636e", produces="application/json")
    public R<String> add(@RequestBody DataRoomMapDTO mapDTO) {
        String id = this.dataRoomMapService.add(mapDTO);
        return R.success((Object)id);
    }

    @ApiPermission(permissions={"map:update"})
    @PostMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539", position=30, notes="\u4fee\u6539\u5730\u56fe\u6570\u636e", produces="application/json")
    public R<Void> update(@RequestBody DataRoomMapDTO mapDTO) {
        this.dataRoomMapService.update(mapDTO);
        return R.success();
    }

    @ApiPermission(permissions={"map:delete"})
    @PostMapping(value={"/delete/{id}"})
    @ApiOperation(value="\u5220\u9664", position=40, notes="\u5220\u9664\u5730\u56fe\u6570\u636e", produces="application/json")
    public R<Boolean> delete(@PathVariable String id) {
        boolean delete = this.dataRoomMapService.delete(id);
        return R.success((Object)delete);
    }

    @ApiPermission(permissions={"map:delete"})
    @PostMapping(value={"/cascadingDelete/{id}"})
    @ApiOperation(value="\u7ea7\u8054\u5220\u9664", position=50, notes="\u7ea7\u8054\u5220\u9664\u5730\u56fe\u6570\u636e", produces="application/json")
    public R<Void> cascadingDelete(@PathVariable String id) {
        this.dataRoomMapService.cascadingDelete(id);
        return R.success();
    }

    @ApiPermission(permissions={"map:view"})
    @GetMapping(value={"/getMapChildFromGeoJson/{id}"})
    @ApiOperation(value="\u6839\u636e\u5730\u56feid\u89e3\u6790json\u4e2d\u7684\u5b50\u7ea7", position=60, notes="\u6839\u636e\u5730\u56feid\u89e3\u6790json\u4e2d\u7684\u5b50\u7ea7", produces="application/json")
    public R<List<MapChildVO>> getMapChildFromGeoJson(@PathVariable String id) {
        List<MapChildVO> list = this.dataRoomMapService.getChildFromGeo(id);
        return R.success(list);
    }

    @ApiPermission(permissions={"map:view"})
    @GetMapping(value={"/info/{id}"})
    @ApiOperation(value="\u8be6\u60c5", position=70, notes="\u5730\u56fe\u6570\u636e\u8be6\u60c5", produces="application/json")
    public R<DataRoomMapVO> info(@PathVariable String id) {
        DataRoomMapEntity info = this.dataRoomMapService.info(id);
        DataRoomMapVO vo = (DataRoomMapVO)BeanConvertUtils.convert((Object)((Object)info), DataRoomMapVO.class);
        return R.success((Object)vo);
    }

    @ApiPermission(permissions={"map:view"})
    @GetMapping(value={"/data/{parentId}/{code}"})
    @ApiOperation(value="\u6570\u636e", position=80, notes="\u5730\u56fe\u6570\u636e\u6570\u636e", produces="application/json")
    public R<DataRoomMapDataVO> data(@PathVariable String parentId, @PathVariable String code) {
        DataRoomMapEntity info = this.dataRoomMapService.getByParentIdAndCode(parentId, code);
        DataRoomMapDataVO vo = new DataRoomMapDataVO();
        if (info == null) {
            vo.setAvailable(0);
            return R.success((Object)vo);
        }
        vo.setAvailable(0);
        if (info.getUploadedGeoJson().equals(1)) {
            vo.setAvailable(1);
        }
        vo.setGeoJson(info.getGeoJson());
        vo.setId(info.getId());
        return R.success((Object)vo);
    }

    @ApiPermission(permissions={"map:update"})
    @PostMapping(value={"/upload"})
    @ApiOperation(value="\u4e0a\u4f20", position=90, notes="\u4e0a\u4f20\u5730\u56fe\u6570\u636e", produces="application/json")
    public R<Void> upload(@RequestBody DataRoomMapDTO mapDTO) {
        this.dataRoomMapService.uploadGeoJson(mapDTO.getId(), mapDTO.getGeoJson());
        return R.success();
    }

    @ApiPermission(permissions={"map:view"})
    @PostMapping(value={"/repeat/code"})
    @ApiOperation(value="\u7f16\u7801\u91cd\u590d\u6821\u9a8c", position=100, notes="\u5730\u56fe\u6570\u636e\u91cd\u590d\u6821\u9a8c", produces="application/json")
    public R<Boolean> repeat(@RequestBody DataRoomMapRepeatDTO mapDTO) {
        Boolean repeat = this.dataRoomMapService.codeRepeatCheck(mapDTO);
        return R.success((Object)repeat);
    }

    @ApiPermission(permissions={"map:view"})
    @PostMapping(value={"/repeat/name"})
    @ApiOperation(value="\u540d\u79f0\u91cd\u590d\u6821\u9a8c", position=110, notes="\u5730\u56fe\u6570\u636e\u91cd\u590d\u6821\u9a8c", produces="application/json")
    public R<Boolean> repeatName(@RequestBody DataRoomMapRepeatDTO mapDTO) {
        Boolean repeat = this.dataRoomMapService.nameRepeatCheck(mapDTO);
        return R.success((Object)repeat);
    }

    @ApiPermission(permissions={"map:view"})
    @GetMapping(value={"/tree/{level}"})
    @ApiOperation(value="\u6811", position=120, notes="\u5730\u56fe\u6570\u636e\u6811", produces="application/json")
    public R<List<DataRoomMapVO>> tree(@PathVariable String level) {
        int levelInt = 0;
        try {
            levelInt = Integer.parseInt(level);
        }
        catch (NumberFormatException e) {
            return R.error((String)"\u5730\u56fe\u5c42\u7ea7\u53c2\u6570\u9519\u8bef");
        }
        List<DataRoomMapVO> list = this.dataRoomMapService.getAvailableTree(levelInt);
        return R.success(list);
    }

    @ApiPermission(permissions={"map:view"})
    @GetMapping(value={"/default/{path}/{name}"})
    @ApiOperation(value="\u9ed8\u8ba4\u5730\u56fe", position=130, notes="\u4ece\u9759\u6001\u8d44\u6e90\u8bfb\u53d6\u9ed8\u8ba4\u5730\u56fe\u6570\u636e", produces="application/json")
    public String defaultMap(@PathVariable String path, @PathVariable String name) {
        String json;
        if (path.contains(".")) {
            path = path.replaceAll("\\.", "/");
        }
        String filePath = "static/" + path + "/" + name + ".json";
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            int n;
            org.springframework.core.io.Resource[] resources = resolver.getResources(filePath);
            org.springframework.core.io.Resource resource = resources[0];
            if (!resource.exists()) {
                return "";
            }
            InputStream stream = resource.getInputStream();
            StringBuilder buffer = new StringBuilder();
            byte[] bytes = new byte[1024];
            while ((n = stream.read(bytes)) != -1) {
                buffer.append(new String(bytes, 0, n));
            }
            json = buffer.toString();
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return "";
        }
        return json;
    }
}

