/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataroom.core.module.file.service.pool.sftp;

import com.gccloud.dataroom.core.config.bean.DataRoomSftpConfig;
import com.gccloud.dataroom.core.module.file.service.pool.sftp.SftpClientFactory;
import com.jcraft.jsch.ChannelSftp;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="gc.starter.file", name={"type"}, havingValue="sftp")
public class SftpPoolService {
    private static final Logger log = LoggerFactory.getLogger(SftpPoolService.class);
    private GenericObjectPool<ChannelSftp> pool;
    @Resource
    private DataRoomSftpConfig config;
    @Resource
    private SftpClientFactory factory;

    @PostConstruct
    private void initPool() {
        log.info("\u521d\u59cb\u5316SFTP\u8fde\u63a5\u6c60");
        this.pool = new GenericObjectPool((PooledObjectFactory)this.factory, (GenericObjectPoolConfig)this.config);
    }

    public ChannelSftp borrowObject() {
        if (this.pool != null) {
            try {
                return (ChannelSftp)this.pool.borrowObject();
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6 ChannelSftp \u5931\u8d25", (Throwable)e);
                e.printStackTrace();
            }
        }
        return null;
    }

    public void returnObject(ChannelSftp channelSftp) {
        if (this.pool != null && channelSftp != null) {
            this.pool.returnObject((Object)channelSftp);
        }
    }
}

