/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataroom.core.module.file.service.pool.ftp;

import com.gccloud.dataroom.core.config.bean.DataRoomFtpConfig;
import com.gccloud.dataroom.core.module.file.service.pool.ftp.FtpClientFactory;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="gc.starter.file", name={"type"}, havingValue="ftp")
public class FtpPoolServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(FtpPoolServiceImpl.class);
    private GenericObjectPool<FTPClient> pool;
    @Resource
    private DataRoomFtpConfig config;
    @Resource
    private FtpClientFactory factory;

    @PostConstruct
    private void initPool() {
        log.info("\u521d\u59cb\u5316FTP\u8fde\u63a5\u6c60");
        this.pool = new GenericObjectPool((PooledObjectFactory)this.factory, (GenericObjectPoolConfig)this.config);
    }

    public FTPClient borrowObject() {
        log.info("\u83b7\u53d6 FTPClient");
        if (this.pool != null) {
            try {
                return (FTPClient)this.pool.borrowObject();
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6 FTPClient \u5931\u8d25 ", (Throwable)e);
            }
        }
        return null;
    }

    public void returnObject(FTPClient ftpClient) {
        if (this.pool == null || ftpClient == null) {
            return;
        }
        try {
            ftpClient.changeWorkingDirectory("/");
        }
        catch (Exception e) {
            log.error("FTPClient \u91cd\u7f6e\u76ee\u5f55\u5931\u8d25 ", (Throwable)e);
        }
        this.pool.returnObject((Object)ftpClient);
    }
}

