/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataroom.core.module.file.service.pool.ftp;

import com.gccloud.dataroom.core.config.DataRoomConfig;
import com.gccloud.dataroom.core.config.bean.DataRoomFtpConfig;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="gc.starter.file", name={"type"}, havingValue="ftp")
public class FtpClientFactory
implements PooledObjectFactory<FTPClient> {
    private static final Logger log = LoggerFactory.getLogger(FtpClientFactory.class);
    @Resource
    private DataRoomConfig config;

    public PooledObject<FTPClient> makeObject() throws Exception {
        log.info("\u521b\u5efaftp\u8fde\u63a5");
        DataRoomFtpConfig ftp = this.config.getFile().getFtp();
        FTPClient ftpClient = new FTPClient();
        ftpClient.setConnectTimeout(ftp.getClientTimeout());
        ftpClient.connect(ftp.getHost(), ftp.getPort().intValue());
        int reply = ftpClient.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            ftpClient.disconnect();
            return null;
        }
        boolean success = StringUtils.isBlank((CharSequence)ftp.getUsername()) ? ftpClient.login("anonymous", "anonymous") : ftpClient.login(ftp.getUsername(), ftp.getPassword());
        if (!success) {
            return null;
        }
        ftpClient.setFileType(ftp.getTransferFileType());
        ftpClient.setBufferSize(1024);
        ftpClient.setControlEncoding(ftp.getEncoding());
        if (ftp.isPassiveMode()) {
            ftpClient.enterLocalPassiveMode();
        }
        log.debug("\u521b\u5efaftp\u8fde\u63a5");
        return new DefaultPooledObject((Object)ftpClient);
    }

    public boolean validateObject(PooledObject<FTPClient> pool) {
        FTPClient ftpClient = (FTPClient)pool.getObject();
        try {
            return ftpClient != null && ftpClient.sendNoOp();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void destroyObject(PooledObject<FTPClient> pool) throws Exception {
        FTPClient ftpClient = (FTPClient)pool.getObject();
        if (ftpClient != null) {
            try {
                ftpClient.disconnect();
                log.debug("\u9500\u6bc1ftp\u8fde\u63a5");
            }
            catch (Exception e) {
                log.error("\u9500\u6bc1FtpClient\u5f02\u5e38");
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    public void passivateObject(PooledObject<FTPClient> p) throws Exception {
        FTPClient ftpClient = (FTPClient)p.getObject();
        try {
            ftpClient.changeWorkingDirectory(this.config.getFile().getBasePath());
        }
        catch (Exception e) {
            log.error("\u949d\u5316FtpClient\u5f02\u5e38");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void activateObject(PooledObject<FTPClient> pool) throws Exception {
        DataRoomFtpConfig ftp = this.config.getFile().getFtp();
        FTPClient ftpClient = (FTPClient)pool.getObject();
        if (!ftpClient.isConnected()) {
            log.info("ftp\u8fde\u63a5\u5df2\u5173\u95ed\uff0c\u91cd\u65b0\u8fde\u63a5");
            ftpClient.connect(ftp.getHost(), ftp.getPort().intValue());
            ftpClient.login(ftp.getUsername(), ftp.getPassword());
        }
        ftpClient.setControlEncoding(ftp.getEncoding());
        ftpClient.changeWorkingDirectory(this.config.getFile().getBasePath());
        ftpClient.setFileType(2);
    }
}

