/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataroom.core.module.file.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.gccloud.common.exception.GlobalException;
import com.gccloud.dataroom.core.config.DataRoomConfig;
import com.gccloud.dataroom.core.config.bean.DataRoomMinioConfig;
import com.gccloud.dataroom.core.config.bean.FileConfig;
import com.gccloud.dataroom.core.module.file.entity.DataRoomFileEntity;
import com.gccloud.dataroom.core.module.file.service.IDataRoomFileService;
import com.gccloud.dataroom.core.module.file.service.IDataRoomOssService;
import com.gccloud.dataroom.core.utils.MinioFileInterface;
import com.gccloud.dataroom.core.utils.PathUtils;
import io.minio.CopyObjectArgs;
import io.minio.CopySource;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@ConditionalOnProperty(prefix="gc.starter.file", name={"type"}, havingValue="minio")
public class DataRoomMinioServiceImpl
implements IDataRoomOssService {
    private static final Logger log = LoggerFactory.getLogger(DataRoomMinioServiceImpl.class);
    @Resource
    private MinioClient minioclient;
    @Resource
    private DataRoomConfig bigScreenConfig;
    @Resource
    private IDataRoomFileService sysFileService;
    @Resource
    private MinioFileInterface minioFileInterface;

    @Override
    public DataRoomFileEntity upload(MultipartFile file, DataRoomFileEntity fileEntity, HttpServletResponse response, HttpServletRequest request) {
        String originalFilename = file.getOriginalFilename();
        String extension = FilenameUtils.getExtension((String)originalFilename);
        FileConfig fileConfig = this.bigScreenConfig.getFile();
        if (!fileConfig.getAllowedFileExtensionName().contains("*") && !fileConfig.getAllowedFileExtensionName().contains(extension)) {
            log.error("\u4e0d\u652f\u6301 {} \u6587\u4ef6\u7c7b\u578b", (Object)extension);
            throw new GlobalException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b");
        }
        String module = request.getParameter("module");
        if (StringUtils.isBlank((CharSequence)module)) {
            fileEntity.setModule("other");
        }
        String newFileName = IdWorker.getIdStr() + "." + extension;
        String basePath = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy/MM/dd"));
        String filePath = basePath + "/" + newFileName;
        DataRoomMinioConfig minioConfig = this.bigScreenConfig.getFile().getMinio();
        try (InputStream inputStream = file.getInputStream();){
            PutObjectArgs args = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(minioConfig.getBucketName())).object(filePath)).stream(inputStream, file.getSize(), -1L).contentType(file.getContentType()).build();
            this.minioclient.putObject(args);
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5230Minio\u5931\u8d25");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new GlobalException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25");
        }
        String url = "/" + minioConfig.getBucketName() + "/" + filePath;
        fileEntity.setOriginalName(originalFilename);
        fileEntity.setNewName(newFileName);
        fileEntity.setPath(filePath);
        fileEntity.setSize(file.getSize());
        fileEntity.setExtension(extension);
        fileEntity.setUrl(url);
        fileEntity.setModule(module);
        fileEntity.setBucket(minioConfig.getBucketName());
        return fileEntity;
    }

    @Override
    public DataRoomFileEntity upload(InputStream inputStream, String fileName, long size, DataRoomFileEntity entity) {
        fileName = PathUtils.normalizePath(fileName);
        String extension = FilenameUtils.getExtension((String)fileName);
        DataRoomMinioConfig minioConfig = this.bigScreenConfig.getFile().getMinio();
        long fileSize = size == 0L ? -1L : size;
        long partSize = fileSize == -1L ? 0x500000L : -1L;
        try {
            PutObjectArgs args = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(minioConfig.getBucketName())).object(fileName)).stream(inputStream, fileSize, partSize).contentType("image/png").build();
            this.minioclient.putObject(args);
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5230Minio\u5931\u8d25");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new GlobalException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25");
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        String url = "/" + minioConfig.getBucketName() + "/" + fileName;
        entity.setOriginalName(fileName);
        entity.setNewName(fileName);
        entity.setPath(fileName);
        entity.setSize(fileSize);
        entity.setExtension(extension);
        entity.setUrl(url);
        entity.setBucket(minioConfig.getBucketName());
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void download(String fileId, HttpServletResponse response, HttpServletRequest request) {
        DataRoomFileEntity fileEntity = (DataRoomFileEntity)this.sysFileService.getById((Serializable)((Object)fileId));
        if (fileEntity == null) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
            log.error("\u4e0b\u8f7d\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
            return;
        }
        response.setContentType("application/x-msdownload");
        response.setContentType("multipart/form-data");
        response.setHeader("Access-Control-Expose-Headers", "filename");
        try {
            response.setHeader("filename", URLEncoder.encode(fileEntity.getOriginalName(), "UTF-8"));
            response.setHeader("Content-Disposition", "attachment;fileName=" + URLEncoder.encode(fileEntity.getOriginalName(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error("\u6587\u4ef6\u540d\u7f16\u7801\u5931\u8d25");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        try {
            InputStream is = this.minioFileInterface.download(fileEntity.getPath());
            IOUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
            is.close();
            response.getOutputStream().close();
        }
        catch (Exception e) {
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            log.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25: {}", (Object)fileEntity.getPath());
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            this.sysFileService.updateDownloadCount(1, fileId);
        }
    }

    @Override
    public void delete(String fileId) {
        DataRoomFileEntity fileEntity = (DataRoomFileEntity)this.sysFileService.getById((Serializable)((Object)fileId));
        if (fileEntity == null) {
            log.error("\u5220\u9664\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
            return;
        }
        this.sysFileService.removeById((Serializable)((Object)fileId));
        String path = fileEntity.getPath();
        try {
            this.minioFileInterface.deleteObject(path);
        }
        catch (Exception e) {
            log.error("\u5220\u9664Minio\u6587\u4ef6\u5931\u8d25: {}", (Object)path);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public String copy(String sourcePath, String targetPath) {
        DataRoomMinioConfig minioConfig = this.bigScreenConfig.getFile().getMinio();
        CopySource source = (CopySource)((CopySource.Builder)((CopySource.Builder)CopySource.builder().bucket(minioConfig.getBucketName())).object(sourcePath)).build();
        CopyObjectArgs args = (CopyObjectArgs)((CopyObjectArgs.Builder)((CopyObjectArgs.Builder)CopyObjectArgs.builder().bucket(minioConfig.getBucketName())).object(PathUtils.normalizePath(targetPath))).source(source).build();
        try {
            this.minioclient.copyObject(args);
        }
        catch (Exception e) {
            log.error("\u590d\u5236Minio\u6587\u4ef6\u5931\u8d25: {}", (Object)sourcePath);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return "";
        }
        return minioConfig.getBucketName() + "/" + targetPath;
    }
}

