/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataroom.core.module.file.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.gccloud.common.exception.GlobalException;
import com.gccloud.dataroom.core.config.DataRoomConfig;
import com.gccloud.dataroom.core.config.bean.FileConfig;
import com.gccloud.dataroom.core.module.file.entity.DataRoomFileEntity;
import com.gccloud.dataroom.core.module.file.service.IDataRoomFileService;
import com.gccloud.dataroom.core.module.file.service.IDataRoomOssService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@ConditionalOnProperty(prefix="gc.starter.file", name={"type"}, havingValue="local", matchIfMissing=true)
public class DataRoomLocalFileServiceImpl
implements IDataRoomOssService {
    private static final Logger log = LoggerFactory.getLogger(DataRoomLocalFileServiceImpl.class);
    @Resource
    private DataRoomConfig bigScreenConfig;
    @Resource
    private IDataRoomFileService sysFileService;

    @Override
    public DataRoomFileEntity upload(MultipartFile file, DataRoomFileEntity fileEntity, HttpServletResponse response, HttpServletRequest request) {
        String originalFilename = file.getOriginalFilename();
        String extension = FilenameUtils.getExtension((String)originalFilename);
        FileConfig fileConfig = this.bigScreenConfig.getFile();
        if (!fileConfig.getAllowedFileExtensionName().contains("*") && !fileConfig.getAllowedFileExtensionName().contains(extension)) {
            log.error("\u4e0d\u652f\u6301 {} \u6587\u4ef6\u7c7b\u578b", (Object)extension);
            throw new GlobalException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b");
        }
        String id = IdWorker.getIdStr();
        String newFileName = id + "." + extension;
        String basePath = this.bigScreenConfig.getFile().getBasePath();
        String destPath = basePath + File.separator + newFileName;
        long size = file.getSize();
        try {
            File dest = new File(destPath);
            file.transferTo(dest);
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            log.error(String.format("\u6587\u4ef6 %s \u5b58\u50a8\u5230 %s \u5931\u8d25", originalFilename, destPath));
            throw new GlobalException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
        }
        fileEntity.setOriginalName(originalFilename);
        fileEntity.setNewName(newFileName);
        fileEntity.setPath(basePath);
        fileEntity.setSize(size);
        fileEntity.setExtension(extension);
        fileEntity.setUrl("/" + newFileName);
        return fileEntity;
    }

    @Override
    public DataRoomFileEntity upload(InputStream inputStream, String fileName, long size, DataRoomFileEntity fileEntity) {
        String basePath = this.bigScreenConfig.getFile().getBasePath();
        String extension = FilenameUtils.getExtension((String)fileName);
        String destPath = basePath + File.separator + fileName;
        try {
            int length;
            File dest = new File(destPath);
            String parent = dest.getParent();
            File parentFile = new File(parent);
            if (!parentFile.exists()) {
                FileUtils.forceMkdir((File)parentFile);
            }
            FileOutputStream outputStream = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, length);
            }
            outputStream.close();
            inputStream.close();
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            log.error(String.format("\u6587\u4ef6 %s \u5b58\u50a8\u5230 %s \u5931\u8d25", fileName, destPath));
            throw new GlobalException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
        }
        fileEntity.setOriginalName(fileName);
        fileEntity.setNewName(fileName);
        fileEntity.setPath(basePath);
        fileEntity.setSize(size);
        fileEntity.setExtension(extension);
        fileEntity.setUrl("/" + fileName);
        return fileEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void download(String fileId, HttpServletResponse response, HttpServletRequest request) {
        DataRoomFileEntity fileEntity = (DataRoomFileEntity)this.sysFileService.getById((Serializable)((Object)fileId));
        if (fileEntity == null) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
            log.error("\u4e0b\u8f7d\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
            return;
        }
        response.setContentType("application/x-msdownload");
        response.setContentType("multipart/form-data");
        response.setHeader("Access-Control-Expose-Headers", "filename");
        try {
            response.setHeader("filename", URLEncoder.encode(fileEntity.getOriginalName(), "UTF-8"));
            response.setHeader("Content-Disposition", "attachment;fileName=" + URLEncoder.encode(fileEntity.getOriginalName(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        String filePath = fileEntity.getPath() + File.separator + fileEntity.getNewName();
        File file = new File(filePath);
        if (!file.exists()) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
            log.error("\u4e0b\u8f7d\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
            return;
        }
        try {
            FileInputStream is = new FileInputStream(file);
            IOUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
            ((InputStream)is).close();
            response.getOutputStream().close();
        }
        catch (Exception e) {
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            log.error(String.format("\u4e0b\u8f7d\u6587\u4ef6%s\u5931\u8d25", fileEntity.getOriginalName()));
        }
        finally {
            this.sysFileService.updateDownloadCount(1, fileId);
        }
    }

    @Override
    public void delete(String fileId) {
        DataRoomFileEntity fileEntity = (DataRoomFileEntity)this.sysFileService.getById((Serializable)((Object)fileId));
        this.sysFileService.removeById((Serializable)((Object)fileId));
        if (fileEntity == null) {
            log.error("\u5220\u9664\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
            return;
        }
        String filePath = fileEntity.getPath() + File.separator + fileEntity.getNewName();
        File file = new File(filePath);
        if (!file.exists()) {
            log.error("\u5220\u9664\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
            return;
        }
        file.delete();
    }

    @Override
    public String copy(String sourcePath, String targetPath) {
        String basePath = this.bigScreenConfig.getFile().getBasePath() + File.separator;
        File sourceFile = new File(basePath + sourcePath);
        File targetFile = new File(basePath + targetPath);
        if (!sourceFile.exists()) {
            log.error("\u590d\u5236\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728:{}", (Object)sourcePath);
            return "";
        }
        if (sourceFile.isDirectory()) {
            log.error("\u6e90\u6587\u4ef6\u4e3a\u6587\u4ef6\u5939:{}\uff0c\u65e0\u6cd5\u590d\u5236", (Object)sourcePath);
            return "";
        }
        try {
            FileUtils.copyFile((File)sourceFile, (File)targetFile);
        }
        catch (IOException e) {
            log.error(String.format("\u6587\u4ef6 %s \u590d\u5236\u5230 %s \u5931\u8d25", sourcePath, targetPath));
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return "";
        }
        return targetPath;
    }
}

