/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataroom.core.module.basic.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.gccloud.common.entity.SuperEntity;
import com.gccloud.common.service.ISuperService;
import com.gccloud.common.utils.AssertUtils;
import com.gccloud.dataroom.core.module.basic.entity.PageEntity;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public interface IBasePageService
extends ISuperService<PageEntity> {
    public static final Cache<String, PageEntity> PAGE_ENTITY_CACHE = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();

    default public Set<String> getAllName(String type) {
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)type), (String)"type\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PageEntity::getType, (Object)type);
        queryWrapper.select((Object[])new SFunction[]{PageEntity::getName});
        List list = this.getBaseMapper().selectList((Wrapper)queryWrapper);
        Set<String> allName = list.stream().map(PageEntity::getName).collect(Collectors.toSet());
        return allName;
    }

    default public PageEntity getByCode(String code) {
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)code), (String)"\u9875\u9762\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        PageEntity ifPresent = (PageEntity)PAGE_ENTITY_CACHE.getIfPresent((Object)code);
        if (ifPresent != null) {
            return ifPresent;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PageEntity::getCode, (Object)code);
        PageEntity pageEntity = (PageEntity)this.getBaseMapper().selectOne((Wrapper)queryWrapper);
        if (pageEntity != null) {
            PAGE_ENTITY_CACHE.put((Object)code, (Object)pageEntity);
        }
        return pageEntity;
    }

    default public boolean checkNameRepeat(PageEntity entity) {
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)entity.getName()), (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.select((Object[])new SFunction[]{SuperEntity::getId});
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(StringUtils.isNotBlank((CharSequence)entity.getAppCode()), PageEntity::getAppCode, (Object)entity.getAppCode())).eq(PageEntity::getName, (Object)entity.getName())).eq(PageEntity::getType, (Object)entity.getType())).ne(StringUtils.isNotBlank((CharSequence)entity.getId()), SuperEntity::getId, (Object)entity.getId());
        return this.getBaseMapper().selectList((Wrapper)queryWrapper).size() > 0;
    }

    default public boolean checkNameRepeat(String appCode, String name, String id, String type) {
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)name), (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.select((Object[])new SFunction[]{SuperEntity::getId});
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(StringUtils.isNotBlank((CharSequence)appCode), PageEntity::getAppCode, (Object)appCode)).eq(PageEntity::getName, (Object)name)).eq(PageEntity::getType, (Object)type)).ne(StringUtils.isNotBlank((CharSequence)id), SuperEntity::getId, (Object)id);
        return this.getBaseMapper().selectList((Wrapper)queryWrapper).size() > 0;
    }

    default public boolean checkCodeRepeat(PageEntity entity) {
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)entity.getCode()), (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.select((Object[])new SFunction[]{SuperEntity::getId});
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(StringUtils.isNotBlank((CharSequence)entity.getAppCode()), PageEntity::getAppCode, (Object)entity.getAppCode())).eq(PageEntity::getCode, (Object)entity.getCode())).eq(PageEntity::getType, (Object)entity.getType())).ne(StringUtils.isNotBlank((CharSequence)entity.getId()), SuperEntity::getId, (Object)entity.getId());
        return this.getBaseMapper().selectList((Wrapper)queryWrapper).size() > 0;
    }
}

