/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataroom.core.config;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsonorg.JSONArraySerializer;
import com.fasterxml.jackson.datatype.jsonorg.JsonOrgModule;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnMissingClass(value={"com.gccloud.dashboard.core.config.ObjectMapperConfiguration"})
@ConditionalOnProperty(prefix="gc.starter.dataroom.component", name={"ObjectMapperConfiguration"}, havingValue="ObjectMapperConfiguration", matchIfMissing=true)
public class DataRoomObjectMapperConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DataRoomObjectMapperConfiguration.class);
    @Resource
    private ObjectMapper objectMapper;

    @PostConstruct
    public void init() {
        log.info("----------------------------------------");
        log.info("\u6ce8\u518c Jackson JsonOrgModule \u6a21\u5757");
        JsonOrgModule jsonOrgModule = new JsonOrgModule();
        this.objectMapper.registerModule((Module)jsonOrgModule);
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(JSONArray.class, (JsonSerializer)JSONArraySerializer.instance);
        this.objectMapper.registerModule((Module)simpleModule);
        log.info("----------------------------------------");
    }
}

