/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;

public class SqlIntervalDayTime {
    private static final long MILLIS_IN_SECOND = 1000L;
    private static final long MILLIS_IN_MINUTE = 60000L;
    private static final long MILLIS_IN_HOUR = 3600000L;
    private static final long MILLIS_IN_DAY = 86400000L;
    private final long milliSeconds;

    public SqlIntervalDayTime(long milliSeconds) {
        this.milliSeconds = milliSeconds;
    }

    public SqlIntervalDayTime(int day, int hour, int minute, int second, int millis) {
        this.milliSeconds = SqlIntervalDayTime.toMillis(day, hour, minute, second, millis);
    }

    public int hashCode() {
        return Objects.hash(this.milliSeconds);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlIntervalDayTime other = (SqlIntervalDayTime)obj;
        return Objects.equals(this.milliSeconds, other.milliSeconds);
    }

    @JsonValue
    public String toString() {
        return SqlIntervalDayTime.formatMillis(this.milliSeconds);
    }

    public static long toMillis(int day, int hour, int minute, int second, int millis) {
        return (long)day * 86400000L + (long)hour * 3600000L + (long)minute * 60000L + (long)second * 1000L + (long)millis;
    }

    public static String formatMillis(long millis) {
        long day = millis / 86400000L;
        long hour = (millis %= 86400000L) / 3600000L;
        long minute = (millis %= 3600000L) / 60000L;
        long second = (millis %= 60000L) / 1000L;
        return String.format("%d %02d:%02d:%02d.%03d", day, hour, minute, second, millis %= 1000L);
    }
}

