/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.classloader;

import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorIndexHandle;
import com.facebook.presto.spi.ConnectorIndexResolver;
import com.facebook.presto.spi.ConnectorResolvedIndex;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.Index;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class ClassLoaderSafeConnectorIndexResolver
implements ConnectorIndexResolver {
    private final ConnectorIndexResolver delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeConnectorIndexResolver(ConnectorIndexResolver delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    @Override
    public ConnectorResolvedIndex resolveIndex(ConnectorTableHandle tableHandle, Set<ConnectorColumnHandle> indexableColumns, TupleDomain<ConnectorColumnHandle> tupleDomain) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorResolvedIndex connectorResolvedIndex = this.delegate.resolveIndex(tableHandle, indexableColumns, tupleDomain);
            return connectorResolvedIndex;
        }
    }

    @Override
    public Index getIndex(ConnectorIndexHandle indexHandle, List<ConnectorColumnHandle> lookupSchema, List<ConnectorColumnHandle> outputSchema) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Index index = this.delegate.getIndex(indexHandle, lookupSchema, outputSchema);
            return index;
        }
    }
}

