/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.AbstractFixedWidthBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingFactory;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.block.FixedWidthBlock;
import com.facebook.presto.spi.type.TypeManager;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;

public class FixedWidthBlockEncoding
implements BlockEncoding {
    public static final BlockEncodingFactory<FixedWidthBlockEncoding> FACTORY = new FixedWidthBlockEncodingFactory();
    private static final String NAME = "FIXED_WIDTH";
    private final int fixedSize;

    public FixedWidthBlockEncoding(int fixedSize) {
        if (fixedSize < 0) {
            throw new IllegalArgumentException("fixedSize is negative");
        }
        this.fixedSize = fixedSize;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public int getFixedSize() {
        return this.fixedSize;
    }

    @Override
    public void writeBlock(SliceOutput sliceOutput, Block block) {
        AbstractFixedWidthBlock fixedWidthBlock = (AbstractFixedWidthBlock)block;
        int positionCount = fixedWidthBlock.getPositionCount();
        sliceOutput.appendInt(positionCount);
        for (int position = 0; position < (positionCount & 0xFFFFFFF8); position += 8) {
            int value = 0;
            value = (byte)(value | (fixedWidthBlock.isNull(position) ? 128 : 0));
            value = (byte)(value | (fixedWidthBlock.isNull(position + 1) ? 64 : 0));
            value = (byte)(value | (fixedWidthBlock.isNull(position + 2) ? 32 : 0));
            value = (byte)(value | (fixedWidthBlock.isNull(position + 3) ? 16 : 0));
            value = (byte)(value | (fixedWidthBlock.isNull(position + 4) ? 8 : 0));
            value = (byte)(value | (fixedWidthBlock.isNull(position + 5) ? 4 : 0));
            value = (byte)(value | (fixedWidthBlock.isNull(position + 6) ? 2 : 0));
            value = (byte)(value | (fixedWidthBlock.isNull(position + 7) ? 1 : 0));
            sliceOutput.appendByte(value);
        }
        if ((positionCount & 7) > 0) {
            int value = 0;
            int mask = 128;
            for (int position = positionCount & 0xFFFFFFF8; position < positionCount; ++position) {
                value = (byte)(value | (fixedWidthBlock.isNull(position) ? mask : 0));
                mask >>>= 1;
            }
            sliceOutput.appendByte(value);
        }
        Slice slice = fixedWidthBlock.getRawSlice();
        sliceOutput.appendInt(slice.length()).writeBytes(slice);
    }

    @Override
    public Block readBlock(SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        boolean[] valueIsNull = new boolean[positionCount];
        for (int position = 0; position < (positionCount & 0xFFFFFFF8); position += 8) {
            byte value = sliceInput.readByte();
            valueIsNull[position] = (value & 0x80) != 0;
            valueIsNull[position + 1] = (value & 0x40) != 0;
            valueIsNull[position + 2] = (value & 0x20) != 0;
            valueIsNull[position + 3] = (value & 0x10) != 0;
            valueIsNull[position + 4] = (value & 8) != 0;
            valueIsNull[position + 5] = (value & 4) != 0;
            valueIsNull[position + 6] = (value & 2) != 0;
            valueIsNull[position + 7] = (value & 1) != 0;
        }
        if ((positionCount & 7) > 0) {
            byte value = sliceInput.readByte();
            int mask = 128;
            for (int position = positionCount & 0xFFFFFFF8; position < positionCount; ++position) {
                valueIsNull[position] = (value & mask) != 0;
                mask >>>= 1;
            }
        }
        int blockSize = sliceInput.readInt();
        Slice slice = sliceInput.readSlice(blockSize);
        return new FixedWidthBlock(this.fixedSize, positionCount, slice, valueIsNull);
    }

    public static class FixedWidthBlockEncodingFactory
    implements BlockEncodingFactory<FixedWidthBlockEncoding> {
        @Override
        public String getName() {
            return FixedWidthBlockEncoding.NAME;
        }

        @Override
        public FixedWidthBlockEncoding readEncoding(TypeManager manager, BlockEncodingSerde serde, SliceInput input) {
            int entrySize = input.readInt();
            return new FixedWidthBlockEncoding(entrySize);
        }

        @Override
        public void writeEncoding(BlockEncodingSerde serde, SliceOutput output, FixedWidthBlockEncoding blockEncoding) {
            output.writeInt(blockEncoding.getFixedSize());
        }
    }
}

