/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.notification.channel;

import com.aliyun.dysmsapi20170525.Client;
import com.aliyun.dysmsapi20170525.models.SendSmsRequest;
import com.aliyun.dysmsapi20170525.models.SendSmsResponse;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.diboot.core.entity.AbstractEntity;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.JSON;
import com.diboot.notification.channel.MessageChannel;
import com.diboot.notification.config.Cons;
import com.diboot.notification.entity.Message;
import com.diboot.notification.service.MessageService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;

public class AliyunSmsChannel
implements MessageChannel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AliyunSmsChannel.class);

    @Override
    public String type() {
        return Cons.MESSAGE_CHANNEL.SMS.name();
    }

    @Override
    @Async
    public void send(Message message) {
        log.debug("[\u5f00\u59cb\u53d1\u9001\u77ed\u4fe1]\uff1a\u77ed\u4fe1\u5185\u5bb9\uff1a{}", (Object)JSON.stringify((Object)((Object)message)));
        Client client = (Client)ContextHolder.getBean(Client.class);
        SendSmsRequest sendSmsRequest = new SendSmsRequest().setSignName(message.getSender()).setTemplateCode(message.getTemplateCode()).setPhoneNumbers(message.getReceiver()).setTemplateParam(message.getVariables());
        Object result = "success";
        String status = Cons.MESSAGE_STATUS.DELIVERY.name();
        try {
            SendSmsResponse sendSmsResponse = client.sendSms(sendSmsRequest);
            if (!"OK".equals(sendSmsResponse.getBody().getCode())) {
                result = sendSmsResponse.getBody().getCode() + "\uff1a" + sendSmsResponse.getBody().message;
            }
        }
        catch (Exception e) {
            log.error("[\u53d1\u9001\u77ed\u4fe1\u5931\u8d25]\uff1a\u4fe1\u606f\u4e3a\uff1a {} , \u5f02\u5e38", (Object)message, (Object)e);
            result = e.getMessage();
            status = Cons.MESSAGE_STATUS.FAILED.name();
        }
        ((MessageService)ContextHolder.getBean(MessageService.class)).updateEntity((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(Message::getResult, result)).set(Message::getStatus, (Object)status)).eq(AbstractEntity::getId, (Object)message.getId()));
    }
}

