/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.starter;

import com.diboot.core.cache.BaseCacheManager;
import com.diboot.core.cache.DynamicMemoryCacheManager;
import com.diboot.core.config.Cons;
import com.diboot.core.util.V;
import com.diboot.iam.cache.SystemConfigCacheManager;
import com.diboot.iam.config.IamProperties;
import com.diboot.iam.init.IamRedisAutoConfig;
import com.diboot.iam.shiro.IamAuthorizingRealm;
import com.diboot.iam.shiro.ShiroContextTaskDecorator;
import com.diboot.iam.shiro.StatelessAccessControlFilter;
import com.diboot.iam.shiro.StatelessSubjectFactory;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.MemoryConstrainedCacheManager;
import org.apache.shiro.event.EventBus;
import org.apache.shiro.event.support.DefaultEventBus;
import org.apache.shiro.mgt.DefaultSessionStorageEvaluator;
import org.apache.shiro.mgt.DefaultSubjectDAO;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SessionStorageEvaluator;
import org.apache.shiro.mgt.SessionsSecurityManager;
import org.apache.shiro.mgt.SubjectFactory;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.spring.web.config.DefaultShiroFilterChainDefinition;
import org.apache.shiro.spring.web.config.ShiroFilterChainDefinition;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.mgt.DefaultWebSubjectFactory;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.apache.shiro.web.session.mgt.WebSessionManager;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Role;
import org.springframework.core.annotation.Order;
import org.springframework.core.task.TaskDecorator;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Order(value=912)
@Configuration
@AutoConfigureAfter(value={IamRedisAutoConfig.class})
@EnableConfigurationProperties(value={IamProperties.class})
@ComponentScan(basePackages={"com.diboot.iam"})
@MapperScan(basePackages={"com.diboot.iam.mapper"})
@Role(value=2)
public class IamAutoConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IamAutoConfig.class);
    @Autowired
    private IamProperties iamProperties;

    public IamAutoConfig() {
        log.info("\u521d\u59cb\u5316 IAM \u7ec4\u4ef6 \u81ea\u52a8\u914d\u7f6e");
    }

    @Bean(name={"shiroCacheManager"})
    @ConditionalOnMissingBean
    @Role(value=2)
    public CacheManager shiroCacheManager() {
        return new MemoryConstrainedCacheManager();
    }

    @Bean
    @ConditionalOnMissingBean
    @DependsOn(value={"shiroCacheManager"})
    @Role(value=2)
    public Realm realm() {
        IamAuthorizingRealm realm = new IamAuthorizingRealm();
        CacheManager cacheManager = this.shiroCacheManager();
        if (cacheManager != null) {
            realm.setCachingEnabled(true);
            realm.setAuthenticationCachingEnabled(true);
            realm.setCacheManager(cacheManager);
        }
        return realm;
    }

    @Bean(name={"shiroSecurityManager"})
    @ConditionalOnMissingBean
    @Role(value=2)
    public DefaultWebSecurityManager shiroSecurityManager() {
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setSubjectFactory((SubjectFactory)this.subjectFactory());
        securityManager.setSessionManager((SessionManager)this.sessionManager());
        securityManager.setRealm(this.realm());
        securityManager.setCacheManager(this.shiroCacheManager());
        ((DefaultSubjectDAO)securityManager.getSubjectDAO()).setSessionStorageEvaluator(this.sessionStorageEvaluator());
        return securityManager;
    }

    @Bean
    @ConditionalOnMissingBean
    @Role(value=2)
    protected SessionStorageEvaluator sessionStorageEvaluator() {
        DefaultSessionStorageEvaluator sessionStorageEvaluator = new DefaultSessionStorageEvaluator();
        sessionStorageEvaluator.setSessionStorageEnabled(false);
        return sessionStorageEvaluator;
    }

    @Bean
    @ConditionalOnMissingBean
    @Role(value=2)
    public DefaultWebSubjectFactory subjectFactory() {
        StatelessSubjectFactory subjectFactory = new StatelessSubjectFactory();
        return subjectFactory;
    }

    @Bean
    @ConditionalOnMissingBean
    @Role(value=2)
    public WebSessionManager sessionManager() {
        DefaultWebSessionManager sessionManager = new DefaultWebSessionManager();
        sessionManager.setSessionValidationSchedulerEnabled(false);
        return sessionManager;
    }

    public AccessControlFilter shiroFilter() {
        return new StatelessAccessControlFilter();
    }

    @Bean
    @ConditionalOnMissingBean
    @Role(value=2)
    public AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor(@Lazy SecurityManager securityManager) {
        AuthorizationAttributeSourceAdvisor advisor = new AuthorizationAttributeSourceAdvisor();
        advisor.setSecurityManager(securityManager);
        return advisor;
    }

    @Bean
    @ConditionalOnMissingBean
    @Role(value=2)
    protected ShiroFilterFactoryBean shiroFilterFactoryBean(SessionsSecurityManager securityManager) {
        ShiroFilterFactoryBean shiroFilterFactoryBean = new ShiroFilterFactoryBean();
        LinkedHashMap<String, AccessControlFilter> filters = new LinkedHashMap<String, AccessControlFilter>();
        filters.put("accessControlFilter", this.shiroFilter());
        shiroFilterFactoryBean.setFilters(filters);
        shiroFilterFactoryBean.setSecurityManager((SecurityManager)securityManager);
        shiroFilterFactoryBean.setUnauthorizedUrl("/error");
        shiroFilterFactoryBean.setFilterChainDefinitionMap(this.shiroFilterChainDefinition().getFilterChainMap());
        return shiroFilterFactoryBean;
    }

    @Bean
    @ConditionalOnMissingBean
    @Role(value=2)
    protected ShiroFilterChainDefinition shiroFilterChainDefinition() {
        LinkedHashMap<String, String> filterChainMap = new LinkedHashMap<String, String>();
        filterChainMap.put("/static/**", "anon");
        filterChainMap.put("/error/**", "anon");
        filterChainMap.put("/auth/captcha", "anon");
        filterChainMap.put("/auth/login", "anon");
        filterChainMap.put("/auth/token", "anon");
        filterChainMap.put("/client/login", "anon");
        Set<String> anonUrls = this.iamProperties.getAnonUrls();
        if (V.notEmpty(anonUrls)) {
            for (String url : anonUrls) {
                filterChainMap.put(url, "anon");
            }
        }
        filterChainMap.put("/login", "authc");
        if (V.notEmpty(anonUrls) && anonUrls.contains("/**") && !this.iamProperties.isEnablePermissionCheck()) {
            log.warn("\u6743\u9650\u68c0\u67e5\u5df2\u505c\u7528\uff0c\u8be5\u914d\u7f6e\u4ec5\u7528\u4e8e\u5f00\u53d1\u73af\u5883 !");
            filterChainMap.put("/**", "anon");
        } else {
            filterChainMap.put("/**", "accessControlFilter");
        }
        DefaultShiroFilterChainDefinition chainDefinition = new DefaultShiroFilterChainDefinition();
        chainDefinition.addPathDefinitions(filterChainMap);
        return chainDefinition;
    }

    @Bean
    @Role(value=2)
    @ConditionalOnMissingBean
    public EventBus eventBus() {
        return new DefaultEventBus();
    }

    @Bean(name={"iamCacheManager"})
    @ConditionalOnMissingBean(name={"iamCacheManager"})
    public BaseCacheManager iamCacheManager() {
        log.info("\u521d\u59cb\u5316 IAM \u5185\u5b58\u7f13\u5b58: DynamicMemoryCacheManager");
        HashMap<String, Integer> cacheName2ExpireMap = new HashMap<String, Integer>(){
            {
                this.put("token-userinfo", IamAutoConfig.this.iamProperties.getTokenExpiresMinutes());
                this.put("token-refresh", 10);
                this.put("CAPTCHA", 5);
            }
        };
        return new DynamicMemoryCacheManager((Map)cacheName2ExpireMap);
    }

    @Bean
    @ConditionalOnMissingBean
    public SystemConfigCacheManager systemConfigCacheManager() {
        log.info("\u521d\u59cb\u5316 SystemConfig \u5185\u5b58\u7f13\u5b58: DynamicMemoryCacheManager");
        HashMap<String, Integer> cacheName2ExpireMap = new HashMap<String, Integer>(){
            {
                this.put(Cons.CACHE_NAME_SYSTEM_CONFIG, 1440);
            }
        };
        DynamicMemoryCacheManager memoryCacheManager = new DynamicMemoryCacheManager((Map)cacheName2ExpireMap);
        return new SystemConfigCacheManager((BaseCacheManager)memoryCacheManager);
    }

    @Configuration
    private class ThreadPoolTaskExecutorConfig {
        public ThreadPoolTaskExecutorConfig(ObjectProvider<ThreadPoolTaskExecutor> taskExecutorObjectProvider) {
            log.info("\u521d\u59cb\u5316: ThreadPoolTaskExecutor \u6307\u5b9a\u5b50\u7ebf\u7a0b\u4f20\u9012\u7528\u6237\u4fe1\u606f");
            taskExecutorObjectProvider.ifAvailable(taskExecutor -> taskExecutor.setTaskDecorator((TaskDecorator)new ShiroContextTaskDecorator()));
        }
    }
}

