/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.vo;

import com.diboot.core.binding.annotation.BindEntityList;
import com.diboot.core.binding.annotation.BindField;
import com.diboot.core.util.V;
import com.diboot.iam.config.Cons;
import com.diboot.iam.entity.IamResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class IamResourceVO
extends IamResource {
    private static final long serialVersionUID = 6643651522844488124L;
    @BindField(entity=IamResource.class, field="displayName", condition="this.parent_id=id")
    private String parentDisplayName;
    @JsonIgnore
    @BindEntityList(entity=IamResource.class, condition="this.id=parent_id")
    private List<IamResource> childrenList;

    public List<IamResource> getChildren() {
        if (V.isEmpty(this.childrenList)) {
            return Collections.emptyList();
        }
        return this.childrenList.stream().filter(item -> Cons.MENU_CATEGORY_LIST.contains(item.getDisplayType())).collect(Collectors.toList());
    }

    public List<IamResource> getPermissionList() {
        if (V.isEmpty(this.childrenList)) {
            return Collections.emptyList();
        }
        return this.childrenList.stream().filter(item -> Cons.RESOURCE_PERMISSION_DISPLAY_TYPE.PERMISSION.name().equals(item.getDisplayType())).collect(Collectors.toList());
    }

    @Generated
    public String getParentDisplayName() {
        return this.parentDisplayName;
    }

    @Generated
    public List<IamResource> getChildrenList() {
        return this.childrenList;
    }

    @Generated
    public IamResourceVO setParentDisplayName(String parentDisplayName) {
        this.parentDisplayName = parentDisplayName;
        return this;
    }

    @JsonIgnore
    @Generated
    public IamResourceVO setChildrenList(List<IamResource> childrenList) {
        this.childrenList = childrenList;
        return this;
    }
}

