/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.vo;

import com.diboot.core.binding.annotation.BindDict;
import com.diboot.core.binding.annotation.BindField;
import com.diboot.core.util.V;
import com.diboot.core.vo.LabelValue;
import com.diboot.iam.entity.IamLoginTrace;
import com.diboot.iam.entity.IamUser;
import java.time.LocalDateTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public class IamLoginTraceVO
extends IamLoginTrace {
    private static final long serialVersionUID = -753084580143028183L;
    private static final String USER_AGENT_BROWSER_REGEX = "((?:MSIE |Trident/.*?rv:|Edge/|Edg/|Firefox/|Chrome/|Safari/|Opera/|OPR/|YaBrowser/)([\\d\\.]+))";
    private static final String USER_AGENT_OS_REGEX = "\\(([^;]*?);";
    @BindDict(type="AUTH_TYPE", field="authType")
    private LabelValue authTypeLabel;
    private String onlineStatus;
    @BindField(entity=IamUser.class, field="realname", condition="this.user_type='IamUser' AND this.user_id=id")
    private String userIdLabel;

    public String getBrowserInfo() {
        String userAgent = this.getUserAgent();
        if (V.isEmpty((String)userAgent)) {
            return "";
        }
        Pattern pattern = Pattern.compile(USER_AGENT_BROWSER_REGEX, 2);
        Matcher matcher = pattern.matcher(userAgent);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "Unknown";
    }

    public String getOsInfo() {
        String userAgent = this.getUserAgent();
        if (V.isEmpty((String)userAgent)) {
            return "";
        }
        Pattern pattern = Pattern.compile(USER_AGENT_OS_REGEX);
        Matcher matcher = pattern.matcher(userAgent);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "Unknown";
    }

    public boolean isExpired(int expiresInMinutes) {
        LocalDateTime expirationTime = this.getCreateTime().plusMinutes(expiresInMinutes);
        LocalDateTime now = LocalDateTime.now();
        return expirationTime.isBefore(now);
    }

    @Generated
    public LabelValue getAuthTypeLabel() {
        return this.authTypeLabel;
    }

    @Generated
    public String getOnlineStatus() {
        return this.onlineStatus;
    }

    @Generated
    public String getUserIdLabel() {
        return this.userIdLabel;
    }

    @Generated
    public IamLoginTraceVO setAuthTypeLabel(LabelValue authTypeLabel) {
        this.authTypeLabel = authTypeLabel;
        return this;
    }

    @Generated
    public IamLoginTraceVO setOnlineStatus(String onlineStatus) {
        this.onlineStatus = onlineStatus;
        return this;
    }

    @Generated
    public IamLoginTraceVO setUserIdLabel(String userIdLabel) {
        this.userIdLabel = userIdLabel;
        return this;
    }

    public static enum ONLINE_STATUS {
        ONLINE,
        LOGOUT,
        UNKNOWN,
        INVALID;

    }
}

