/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.util;

import com.diboot.core.cache.BaseCacheManager;
import com.diboot.core.config.BaseConfig;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.iam.util.IamSecurityUtils;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenUtils {
    private static final Logger log = LoggerFactory.getLogger(TokenUtils.class);
    private static final String AUTH_HEADER = TokenUtils.getConfigValue("diboot.iam.token-header-key", "Authorization");
    public static final int EXPIRES_IN_MINUTES = TokenUtils.getConfigIntValue("diboot.iam.token-expires-minutes", 60);
    private static final int EXPIRES_MINUTES_INDEX = 4;
    private static final int ISSUED_AT_INDEX = 5;
    private static BaseCacheManager iamCacheManager;

    public static String getRequestToken(HttpServletRequest request) {
        String[] values;
        String authtoken = request.getHeader(AUTH_HEADER);
        if (authtoken == null && (values = request.getParameterValues(AUTH_HEADER)) != null && values.length > 0) {
            authtoken = URLDecoder.decode(values[0], StandardCharsets.UTF_8);
        }
        if (authtoken != null) {
            if (authtoken.startsWith("Bearer")) {
                authtoken = authtoken.substring("Bearer".length());
            }
            authtoken = authtoken.trim();
        }
        if (V.isEmpty((String)authtoken)) {
            log.warn("\u8bf7\u6c42\u672a\u6307\u5b9atoken: {}", (Object)authtoken);
            return null;
        }
        if (!TokenUtils.isActiveAccessToken(authtoken)) {
            return null;
        }
        return authtoken;
    }

    public static String generateToken() {
        return S.newUuid();
    }

    public static synchronized String responseNewTokenIfRequired(ServletResponse response, String currentToken, String cachedUserInfo) {
        if (TokenUtils.isCloseToExpired(cachedUserInfo)) {
            String refreshToken = TokenUtils.getRefreshToken(currentToken, cachedUserInfo);
            ((HttpServletResponse)response).setHeader(AUTH_HEADER, refreshToken);
            log.debug("\u5199\u56de\u5237\u65b0token :{}", (Object)refreshToken);
            return refreshToken;
        }
        return null;
    }

    public static void cacheAccessToken(String accessToken, String userInfoStr) {
        TokenUtils.getIamCacheManager().putCacheObj("token-userinfo", (Object)accessToken, (Object)userInfoStr);
    }

    public static void removeAccessTokens(String accessToken) {
        TokenUtils.getIamCacheManager().removeCacheObj("token-userinfo", (Object)accessToken);
    }

    public static String getCachedUserInfoStr(String accessToken) {
        String userInfoStr = TokenUtils.getIamCacheManager().getCacheString("token-userinfo", (Object)accessToken);
        if (userInfoStr == null) {
            log.debug("token {} \u7f13\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u5df2\u8fc7\u671f\u6216\u65e0\u6548", (Object)accessToken);
        }
        return userInfoStr;
    }

    public static boolean isActiveAccessToken(String accessToken) {
        String userInfoStr = TokenUtils.getCachedUserInfoStr(accessToken);
        if (V.isEmpty((String)userInfoStr)) {
            log.warn("\u65e0\u6548\u7684token: {}", (Object)accessToken);
            return false;
        }
        if (TokenUtils.isExpired(userInfoStr)) {
            log.warn("token\u5df2\u8fc7\u671f: {}\uff0c\u7528\u6237: {} \u9700\u91cd\u65b0\u767b\u5f55\u540e\u65b9\u53ef\u64cd\u4f5c", (Object)accessToken, (Object)userInfoStr);
            IamSecurityUtils.logoutByToken(accessToken);
            return false;
        }
        return true;
    }

    public static synchronized String getRefreshToken(String accessToken, String userInfoStr) {
        String refreshToken = TokenUtils.getIamCacheManager().getCacheString("token-refresh", (Object)accessToken);
        if (refreshToken == null) {
            refreshToken = TokenUtils.generateToken();
            TokenUtils.cacheRefreshToken(refreshToken, userInfoStr);
            TokenUtils.getIamCacheManager().putCacheObj("token-refresh", (Object)accessToken, (Object)refreshToken);
            log.debug("\u751f\u6210 token: {} \u7684 refresh-token: {}", (Object)accessToken, (Object)refreshToken);
        } else {
            log.debug("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6 token: {} \u7684 refresh-token: {}", (Object)accessToken, (Object)refreshToken);
        }
        return refreshToken;
    }

    public static synchronized void cacheRefreshToken(String refreshToken, String userInfoStr) {
        String prefixTemp = S.substringBeforeLast((String)userInfoStr, (String)",");
        userInfoStr = prefixTemp + "," + System.currentTimeMillis();
        TokenUtils.cacheAccessToken(refreshToken, (String)userInfoStr);
    }

    public static boolean isExpired(String userInfoStr) {
        if (V.isEmpty((String)userInfoStr)) {
            return false;
        }
        String[] userFields = S.split((String)userInfoStr);
        int expiresInMinutes = Integer.parseInt(userFields[4]);
        long issuedAt = Long.parseLong(userFields[5]);
        long expiredBefore = issuedAt + (long)expiresInMinutes * 60000L;
        return System.currentTimeMillis() > expiredBefore;
    }

    public static boolean isCloseToExpired(String userInfoStr) {
        if (V.isEmpty((String)userInfoStr)) {
            return false;
        }
        String[] userFields = S.split((String)userInfoStr);
        int expiresInMinutes = Integer.parseInt(userFields[4]);
        long current = System.currentTimeMillis();
        long issuedAt = Long.parseLong(userFields[5]);
        long expiration = issuedAt + (long)expiresInMinutes * 60000L;
        long remaining = expiration - current;
        if (remaining > 0L) {
            long elapsed = current - issuedAt;
            double past = (double)elapsed / (double)remaining;
            return past > 3.0;
        }
        return false;
    }

    private static BaseCacheManager getIamCacheManager() {
        if (iamCacheManager == null) {
            iamCacheManager = (BaseCacheManager)ContextHolder.getBean((String)"iamCacheManager");
        }
        return iamCacheManager;
    }

    private static String getConfigValue(String key, String defaultValue) {
        String value = BaseConfig.getProperty((String)key);
        return value != null ? value : defaultValue;
    }

    private static int getConfigIntValue(String key, int defaultValue) {
        String value = BaseConfig.getProperty((String)key);
        return value != null ? Integer.parseInt(value) : defaultValue;
    }
}

