/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.util;

import com.diboot.core.exception.InvalidUsageException;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.S;
import com.diboot.iam.config.Cons;
import com.diboot.iam.entity.BaseLoginUser;
import com.diboot.iam.entity.IamAccount;
import com.diboot.iam.service.IamLoginTraceService;
import com.diboot.iam.util.TokenUtils;
import java.util.Collection;
import lombok.Generated;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.crypto.hash.SimpleHash;
import org.apache.shiro.lang.util.ByteSource;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IamSecurityUtils
extends SecurityUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IamSecurityUtils.class);
    private static final String ALGORITHM = "md5";
    private static final int ITERATIONS = 2;

    public static <T> T getCurrentUser() {
        Subject subject = IamSecurityUtils.getSubject();
        if (subject != null) {
            return (T)subject.getPrincipal();
        }
        return null;
    }

    public static BaseLoginUser getLoginUserByToken(String accessToken) {
        CacheManager cacheManager = (CacheManager)ContextHolder.getBean(CacheManager.class);
        if (cacheManager != null && cacheManager.getCache(Cons.AUTHENTICATION_CAHCE_NAME) != null) {
            SimpleAuthenticationInfo authInfo = (SimpleAuthenticationInfo)cacheManager.getCache(Cons.AUTHENTICATION_CAHCE_NAME).get((Object)accessToken);
            if (authInfo != null) {
                SimplePrincipalCollection principalCollection = (SimplePrincipalCollection)authInfo.getPrincipals();
                return (BaseLoginUser)((Object)principalCollection.getPrimaryPrincipal());
            }
        } else {
            throw new InvalidUsageException("\u65e0\u6cd5\u83b7\u53d6\u767b\u5f55\u7528\u6237\u7f13\u5b58\uff0c\u8bf7\u68c0\u67e5\u4f9d\u8d56\u73af\u5883\uff01", new Object[0]);
        }
        log.warn("\u7f13\u5b58\u4e2d\u4e0d\u5b58\u5728\u7684\u65e0\u6548token: {}", (Object)accessToken);
        return null;
    }

    public static void logout() {
        Subject subject;
        BaseLoginUser user = (BaseLoginUser)((Object)IamSecurityUtils.getCurrentUser());
        if (user != null) {
            try {
                ((IamLoginTraceService)ContextHolder.getBean(IamLoginTraceService.class)).updateLogoutInfo(user.getAuthToken(), ((Object)((Object)user)).getClass().getSimpleName(), (String)((Object)user.getId()));
            }
            catch (Exception e) {
                log.warn("\u66f4\u65b0\u7528\u6237\u9000\u51fa\u65f6\u95f4\u5f02\u5e38: {}", (Object)e.getMessage());
            }
        }
        if ((subject = IamSecurityUtils.getSubject()).isAuthenticated() || subject.getPrincipals() != null) {
            subject.logout();
        }
    }

    public static void logout(String userTypeAndId) {
        CacheManager cacheManager = (CacheManager)ContextHolder.getBean(CacheManager.class);
        if (cacheManager == null || cacheManager.getCache(Cons.AUTHENTICATION_CAHCE_NAME) == null) {
            log.warn("cacheManager \u5b9e\u4f8b\u5f02\u5e38");
            return;
        }
        IamLoginTraceService iamLoginTraceService = (IamLoginTraceService)ContextHolder.getBean(IamLoginTraceService.class);
        Collection cacheVals = cacheManager.getCache(Cons.AUTHENTICATION_CAHCE_NAME).values();
        for (Object obj : cacheVals) {
            SimpleAuthenticationInfo authInfo = (SimpleAuthenticationInfo)obj;
            SimplePrincipalCollection principalCollection = (SimplePrincipalCollection)authInfo.getPrincipals();
            BaseLoginUser user = (BaseLoginUser)((Object)principalCollection.getPrimaryPrincipal());
            if (!userTypeAndId.equals(user.getUserTypeAndId())) continue;
            cacheManager.getCache(Cons.AUTHENTICATION_CAHCE_NAME).remove(authInfo.getCredentials());
            TokenUtils.removeAccessTokens(principalCollection.toString());
            log.info("\u5f3a\u5236\u9000\u51fa\u7528\u6237: {} \uff0ctoken: {} \u5931\u6548", (Object)userTypeAndId, (Object)principalCollection);
            try {
                iamLoginTraceService.updateLogoutInfo(user.getAuthToken(), ((Object)((Object)user)).getClass().getSimpleName(), (String)((Object)user.getId()));
            }
            catch (Exception e) {
                log.warn("\u66f4\u65b0\u7528\u6237 {} \u9000\u51fa\u65f6\u95f4\u5f02\u5e38: {}", (Object)userTypeAndId, (Object)e.getMessage());
            }
        }
    }

    public static void logoutByToken(String accessToken) {
        IamSecurityUtils.logout();
        CacheManager cacheManager = (CacheManager)ContextHolder.getBean(CacheManager.class);
        if (cacheManager != null && cacheManager.getCache(Cons.AUTHENTICATION_CAHCE_NAME) != null) {
            cacheManager.getCache(Cons.AUTHENTICATION_CAHCE_NAME).remove((Object)accessToken);
        }
        TokenUtils.removeAccessTokens(accessToken);
        log.debug("token \u5df2\u8fc7\u671f\u6ce8\u9500: {}", (Object)accessToken);
    }

    public static String getCurrentUserId() {
        BaseLoginUser user = (BaseLoginUser)((Object)IamSecurityUtils.getCurrentUser());
        return user != null ? (String)((Object)user.getId()) : null;
    }

    public static String getCurrentTenantId() {
        try {
            BaseLoginUser user = (BaseLoginUser)((Object)IamSecurityUtils.getCurrentUser());
            if (user != null) {
                return user.getTenantId();
            }
        }
        catch (Exception e) {
            log.debug("\u5f53\u524d\u8c03\u7528\u94fe\u8def\u65e0\u767b\u5f55\u7528\u6237\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
        }
        return "0";
    }

    public static String getUserTypeAndId() {
        BaseLoginUser user = (BaseLoginUser)((Object)IamSecurityUtils.getCurrentUser());
        if (user == null) {
            return null;
        }
        return S.join((Object[])new String[]{((Object)((Object)user)).getClass().getSimpleName(), ":", (String)((Object)user.getId())});
    }

    public static void clearAuthorizationCache(String userType, String userId) {
        CacheManager cacheManager = (CacheManager)ContextHolder.getBean(CacheManager.class);
        if (cacheManager == null || cacheManager.getCache(Cons.AUTHORIZATION_CAHCE_NAME) == null) {
            log.warn("cacheManager \u5b9e\u4f8b\u5f02\u5e38");
            return;
        }
        String userTypeAndId = userType + ":" + userId;
        Cache authenticationCache = cacheManager.getCache(Cons.AUTHENTICATION_CAHCE_NAME);
        for (Object obj : authenticationCache.values()) {
            SimpleAuthenticationInfo authInfo = (SimpleAuthenticationInfo)obj;
            SimplePrincipalCollection principalCollection = (SimplePrincipalCollection)authInfo.getPrincipals();
            BaseLoginUser user = (BaseLoginUser)((Object)principalCollection.getPrimaryPrincipal());
            if (!userTypeAndId.equals(user.getUserTypeAndId())) continue;
            String accessToken = principalCollection.toString();
            Cache authorizationCache = cacheManager.getCache(Cons.AUTHORIZATION_CAHCE_NAME);
            authorizationCache.remove((Object)accessToken);
            log.info("\u6e05\u7a7a\u7528\u6237\u6743\u9650\u7f13\u5b58\uff0c\u4f7f\u65b0\u6743\u9650\u751f\u6548: {}", (Object)userTypeAndId);
            return;
        }
    }

    public static void clearAllAuthorizationCache() {
        CacheManager cacheManager = (CacheManager)ContextHolder.getBean(CacheManager.class);
        if (cacheManager == null || cacheManager.getCache(Cons.AUTHORIZATION_CAHCE_NAME) == null) {
            log.warn("cacheManager \u5b9e\u4f8b\u5f02\u5e38");
            return;
        }
        Cache cache = cacheManager.getCache(Cons.AUTHORIZATION_CAHCE_NAME);
        if (cache != null) {
            cache.clear();
            log.debug("\u5df2\u6e05\u7a7a\u5168\u90e8\u767b\u5f55\u7528\u6237\u7684\u6743\u9650\u7f13\u5b58\uff0c\u4ee5\u4fbf\u65b0\u6743\u9650\u751f\u6548.");
        }
    }

    public static void encryptPwd(IamAccount iamAccount) {
        if (Cons.DICTCODE_AUTH_TYPE.PWD.name().equals(iamAccount.getAuthType())) {
            if (iamAccount.getSecretSalt() == null) {
                String salt = S.cut((String)S.newUuid(), (int)8);
                iamAccount.setSecretSalt(salt);
            }
            String encryptedPwd = IamSecurityUtils.encryptPwd(iamAccount.getAuthSecret(), iamAccount.getSecretSalt());
            iamAccount.setAuthSecret(encryptedPwd);
        }
    }

    public static String encryptPwd(String password, String salt) {
        return new SimpleHash(ALGORITHM, (Object)password, (Object)ByteSource.Util.bytes((String)salt), 2).toHex();
    }

    public static boolean isSuperAdmin() {
        Subject subject = IamSecurityUtils.getSubject();
        if (subject != null) {
            return subject.hasRole("SUPER_ADMIN");
        }
        return false;
    }
}

