/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.util;

import com.diboot.core.util.S;
import com.diboot.core.util.V;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHelper
extends com.diboot.core.util.HttpHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpHelper.class);

    public static String callGet(String url, Map<String, String> headerMap) {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        if (S.startsWithIgnoreCase((CharSequence)url, (CharSequence)"https://")) {
            HttpHelper.withHttps(clientBuilder);
        }
        Request.Builder builder = new Request.Builder().url(url);
        if (V.notEmpty(headerMap)) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
        }
        Call call = clientBuilder.build().newCall(builder.build());
        return HttpHelper.executeCall(call, url);
    }

    public static Response callPostResponse(String url, Map<String, String> formBody) {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        if (S.startsWithIgnoreCase((CharSequence)url, (CharSequence)"https://")) {
            HttpHelper.withHttps(clientBuilder);
        }
        FormBody.Builder bodyBuilder = new FormBody.Builder();
        if (V.notEmpty(formBody)) {
            for (Map.Entry<String, String> entry : formBody.entrySet()) {
                bodyBuilder.add(entry.getKey(), entry.getValue());
            }
        }
        Request request = new Request.Builder().url(url).post((RequestBody)bodyBuilder.build()).build();
        Call call = clientBuilder.build().newCall(request);
        try {
            Response response = call.execute();
            if (response.code() >= 400) {
                log.warn("\u8bf7\u6c42\u8c03\u7528\u5f02\u5e38 : {}", (Object)url);
                return null;
            }
            return response;
        }
        catch (IOException e) {
            log.warn("\u8bf7\u6c42\u8c03\u7528\u89e3\u6790\u5f02\u5e38 : {}", (Object)url, (Object)e);
            return null;
        }
    }

    public static String callPost(String url, Map<String, String> formBody) {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        if (S.startsWithIgnoreCase((CharSequence)url, (CharSequence)"https://")) {
            HttpHelper.withHttps(clientBuilder);
        }
        FormBody.Builder bodyBuilder = new FormBody.Builder();
        if (V.notEmpty(formBody)) {
            for (Map.Entry<String, String> entry : formBody.entrySet()) {
                bodyBuilder.add(entry.getKey(), entry.getValue());
            }
        }
        Request request = new Request.Builder().url(url).post((RequestBody)bodyBuilder.build()).build();
        Call call = clientBuilder.build().newCall(request);
        return HttpHelper.executeCall(call, url);
    }

    private static String executeCall(Call call, String url) {
        try {
            Response response = call.execute();
            if (response.code() >= 400) {
                log.warn("\u8bf7\u6c42\u8c03\u7528\u5f02\u5e38 : {}", (Object)url);
                return null;
            }
            return response.body().string();
        }
        catch (Exception e) {
            log.warn("\u8bf7\u6c42\u8c03\u7528\u89e3\u6790\u5f02\u5e38 : {}", (Object)url, (Object)e);
            return null;
        }
    }

    public static void withHttps(OkHttpClient.Builder builder) {
        try {
            TrustManager[] trustManagers = HttpHelper.buildTrustManagers();
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustManagers, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            builder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustManagers[0]);
            builder.hostnameVerifier((hostname, session) -> true);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            log.warn("\u6784\u5efahttps\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
        }
    }

    private static TrustManager[] buildTrustManagers() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
    }
}

