/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.sso.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.diboot.core.exception.BusinessException;
import com.diboot.core.util.JSON;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.iam.auth.AuthServiceFactory;
import com.diboot.iam.config.Cons;
import com.diboot.iam.dto.SsoAuthorizeInfo;
import com.diboot.iam.entity.IamAccount;
import com.diboot.iam.entity.IamUser;
import com.diboot.iam.service.IamAccountService;
import com.diboot.iam.service.IamUserService;
import com.diboot.iam.sso.SSOManager;
import com.diboot.iam.sso.credential.OAuth2Credential;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Random;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
@ConditionalOnProperty(prefix="diboot.iam.oauth2", name={"client-id", "client-secret", "auth-center-url", "access-token-uri", "user-info-uri", "callback"})
public class OAuthSSOManager
implements SSOManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAuthSSOManager.class);
    private static final String CODE_KEY = "code";
    private static final String STATE_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String TOKEN_TYPE = "token_type";
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private IamUserService iamUserService;
    @Autowired
    private IamAccountService iamAccountService;
    @Value(value="${diboot.iam.oauth2.client-id}")
    private String clientId;
    @Value(value="${diboot.iam.oauth2.client-secret}")
    private String clientSecret;
    @Value(value="${diboot.iam.oauth2.auth-center-url}")
    private String authCenterUrl;
    @Value(value="${diboot.iam.oauth2.access-token-uri}")
    private String accessTokenUri;
    @Value(value="${diboot.iam.oauth2.user-info-uri}")
    private String userInfoUri;
    @Value(value="${diboot.iam.oauth2.callback}")
    private String callback;

    @Override
    public String getAuthType() {
        return Cons.DICTCODE_AUTH_TYPE.OAuth2.name();
    }

    @Override
    public SsoAuthorizeInfo getAuthorizeInfo(String callback) {
        if (V.isEmpty((String)callback)) {
            callback = this.callback;
        }
        if (V.isEmpty((String)callback)) {
            throw new BusinessException("exception.business.SSOManager.nullCallback", new Object[0]);
        }
        try {
            callback = URLEncoder.encode(callback, "UTF-8");
        }
        catch (Exception e) {
            log.error("URL\u7f16\u7801\u51fa\u9519", (Throwable)e);
        }
        String state = this.getState();
        String url = this.authCenterUrl + "/oauth2/authorize?client_id=" + this.clientId + "&redirect_uri=" + callback + "&response_type=code&state=" + state;
        SsoAuthorizeInfo authorizeInfo = new SsoAuthorizeInfo(url, state);
        return authorizeInfo;
    }

    @Override
    public String getToken(Map<String, Object> paramsMap) {
        if (V.isEmpty(paramsMap) || paramsMap.get(CODE_KEY) == null) {
            return null;
        }
        String code = String.valueOf(paramsMap.get(CODE_KEY));
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"grant_type", (Object)"authorization_code");
        param.add((Object)CODE_KEY, (Object)code);
        param.add((Object)"redirect_uri", (Object)this.callback);
        Map accessTokenMap = this.getAccessToken((MultiValueMap<String, String>)param, this.clientId);
        Map userInfoMap = this.getUserInfo(accessTokenMap);
        IamUser iamUser = this.syncUserInfo(userInfoMap);
        OAuth2Credential credential = new OAuth2Credential();
        credential.setAuthAccount(iamUser.getUserNum()).setUserType(IamUser.class.getSimpleName()).setAuthType(Cons.DICTCODE_AUTH_TYPE.OAuth2.name());
        return AuthServiceFactory.getAuthService(Cons.DICTCODE_AUTH_TYPE.OAuth2.name()).applyToken(credential);
    }

    protected String getState() {
        StringBuilder state = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < 6; ++i) {
            int randomIndex = random.nextInt(52);
            state.append(STATE_CHARS.charAt(randomIndex));
        }
        return state.toString();
    }

    protected Map getAccessToken(MultiValueMap<String, String> param, String clientId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        if (S.isBlank((CharSequence)this.clientSecret)) {
            throw new BusinessException("exception.business.oauthSSOManager.nonConfigClientSecret", new Object[]{clientId});
        }
        byte[] authorization = (clientId + ":" + this.clientSecret).getBytes(StandardCharsets.UTF_8);
        String base64Auth = Base64.encodeBase64String((byte[])authorization);
        headers.add("Authorization", "Basic " + base64Auth);
        HttpEntity request = new HttpEntity(param, (MultiValueMap)headers);
        this.restTemplate.getMessageConverters().add(new FormHttpMessageConverter());
        ResponseEntity response = this.restTemplate.postForEntity(this.accessTokenUri, (Object)request, Map.class, new Object[0]);
        return (Map)response.getBody();
    }

    protected Map getUserInfo(Map accessTokenMap) {
        String accessToken = String.valueOf(accessTokenMap.get(ACCESS_TOKEN));
        String tokenType = String.valueOf(accessTokenMap.get(TOKEN_TYPE));
        HttpHeaders headers = new HttpHeaders();
        if (S.isBlank((CharSequence)accessToken)) {
            throw new BusinessException("exception.business.oauthSSOManager.nullAccessToken", new Object[0]);
        }
        headers.add("Authorization", tokenType + " " + accessToken);
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(this.userInfoUri, HttpMethod.GET, request, Map.class, new Object[0]);
        Map responseBody = (Map)response.getBody();
        if (responseBody.get(CODE_KEY) != null) {
            if (V.equals((Object)String.valueOf(responseBody.get(CODE_KEY)), (Object)"0") && responseBody.get("data") != null) {
                return JSON.toMap((String)JSON.stringify(responseBody.get("data")));
            }
            throw new BusinessException("exception.business.oauthSSOManager.ssoLoginFailed", new Object[0]);
        }
        return (Map)response.getBody();
    }

    protected IamUser syncUserInfo(Map userInfoMap) {
        if (V.isEmpty((Map)userInfoMap)) {
            throw new BusinessException("exception.business.oauthSSOManager.fetchUserInfoFailed", new Object[0]);
        }
        IamUser userInfo = (IamUser)((Object)JSON.parseObject((String)JSON.toJSONString((Object)userInfoMap), IamUser.class));
        IamUser oldIamUser = (IamUser)((Object)this.iamUserService.getSingleEntity((Wrapper)Wrappers.lambdaQuery().eq(IamUser::getUserNum, (Object)userInfo.getUserNum())));
        if (oldIamUser == null) {
            this.iamUserService.createEntity((Object)userInfo);
        } else {
            userInfo.setId((Serializable)((Object)((String)((Object)oldIamUser.getId()))));
            this.iamUserService.updateEntity((Object)userInfo);
        }
        IamAccount iamAccount = (IamAccount)((Object)this.iamAccountService.getSingleEntity((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(IamAccount::getTenantId, (Object)userInfo.getTenantId())).eq(IamAccount::getUserType, (Object)IamUser.class.getSimpleName())).eq(IamAccount::getUserId, (Object)userInfo.getId())).eq(IamAccount::getAuthType, (Object)this.getAuthType())).eq(IamAccount::getAuthAccount, (Object)userInfo.getUserNum())));
        if (iamAccount == null) {
            iamAccount = new IamAccount();
            iamAccount.setUserType(IamUser.class.getSimpleName()).setTenantId(userInfo.getTenantId()).setUserId((String)((Object)userInfo.getId())).setAuthType(this.getAuthType()).setAuthAccount(userInfo.getUserNum());
            this.iamAccountService.createEntity(iamAccount);
        }
        return userInfo;
    }
}

