/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.shiro;

import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.JSON;
import com.diboot.core.util.V;
import com.diboot.core.vo.JsonResult;
import com.diboot.core.vo.Status;
import com.diboot.iam.service.IamLoginTraceService;
import com.diboot.iam.shiro.IamAuthToken;
import com.diboot.iam.util.IamSecurityUtils;
import com.diboot.iam.util.TokenUtils;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import lombok.Generated;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.web.filter.authc.BasicHttpAuthenticationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class StatelessAccessControlFilter
extends BasicHttpAuthenticationFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatelessAccessControlFilter.class);

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        IamLoginTraceService iamLoginTraceService;
        String refreshToken;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String currentToken = TokenUtils.getRequestToken(httpRequest);
        if (V.isEmpty((String)currentToken)) {
            log.debug("token: {} \u9a8c\u8bc1\u5931\u8d25, uri={}", (Object)currentToken, (Object)httpRequest.getRequestURI());
            return false;
        }
        log.debug("token: {} \u9a8c\u8bc1\u901a\u8fc7", (Object)currentToken);
        String cachedUserInfo = TokenUtils.getCachedUserInfoStr(currentToken);
        if (!IamSecurityUtils.getSubject().isAuthenticated() && cachedUserInfo != null) {
            IamAuthToken authToken = new IamAuthToken(cachedUserInfo);
            authToken.setAuthtoken(currentToken);
            authToken.setValidPassword(false);
            IamSecurityUtils.getSubject().login((AuthenticationToken)authToken);
            log.debug("token: {} \u4fdd\u6d3b\u5b8c\u6210, uri={}", (Object)currentToken, (Object)httpRequest.getRequestURI());
        }
        if (V.notEmpty((String)(refreshToken = TokenUtils.responseNewTokenIfRequired(response, currentToken, cachedUserInfo))) && (iamLoginTraceService = (IamLoginTraceService)ContextHolder.getBean(IamLoginTraceService.class)) != null) {
            iamLoginTraceService.saveTokenRefreshTrace(refreshToken, currentToken);
        }
        return true;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        log.debug("Token\u8ba4\u8bc1\u5931\u8d25\uff1a onAccessDenied");
        JsonResult jsonResult = new JsonResult(Status.FAIL_INVALID_TOKEN);
        this.responseJson((HttpServletResponse)response, jsonResult);
        return false;
    }

    protected void responseJson(HttpServletResponse response, JsonResult jsonResult) {
        response.setStatus(HttpStatus.OK.value());
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        try (PrintWriter pw = response.getWriter();){
            pw.write(JSON.stringify((Object)jsonResult));
            pw.flush();
        }
        catch (IOException e) {
            log.error("\u5904\u7406\u5f02\u6b65\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
        }
    }
}

