/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.shiro;

import com.diboot.core.service.BaseService;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.core.vo.LabelValue;
import com.diboot.iam.auth.AuthService;
import com.diboot.iam.auth.AuthServiceFactory;
import com.diboot.iam.auth.IamExtensible;
import com.diboot.iam.auth.IamTenantPermission;
import com.diboot.iam.config.Cons;
import com.diboot.iam.entity.BaseLoginUser;
import com.diboot.iam.entity.Client;
import com.diboot.iam.entity.IamAccount;
import com.diboot.iam.entity.IamRole;
import com.diboot.iam.service.IamRoleResourceService;
import com.diboot.iam.service.IamUserRoleService;
import com.diboot.iam.shiro.CustomSimpleByteSource;
import com.diboot.iam.shiro.IamAuthToken;
import com.diboot.iam.util.IamSecurityUtils;
import com.diboot.iam.vo.PositionDataScope;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import lombok.Generated;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.lang.util.ByteSource;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IamAuthorizingRealm
extends AuthorizingRealm {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IamAuthorizingRealm.class);
    private IamUserRoleService iamUserRoleService;
    private IamRoleResourceService iamRoleResourceService;
    private IamTenantPermission iamTenantPermission;

    public boolean supports(AuthenticationToken token) {
        return token != null && token instanceof IamAuthToken;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        LabelValue extensionObj;
        IamAuthToken iamAuthToken = (IamAuthToken)token;
        String authAccount = (String)iamAuthToken.getPrincipal();
        if (V.isEmpty((String)authAccount)) {
            throw new AuthenticationException("\u65e0\u6548\u7684\u7528\u6237\u6807\u8bc6");
        }
        AuthService authService = AuthServiceFactory.getAuthService(iamAuthToken.getAuthType());
        if (authService == null) {
            iamAuthToken.clearAuthtoken();
            throw new AuthenticationException("\u8ba4\u8bc1\u7c7b\u578b: " + iamAuthToken.getAuthType() + " \u7684AccountAuthService\u672a\u5b9e\u73b0\uff01");
        }
        IamAccount account = authService.getAccount(iamAuthToken);
        if (account == null) {
            iamAuthToken.clearAuthtoken();
            throw new AuthenticationException("\u7528\u6237\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef\uff01");
        }
        BaseService userService = ContextHolder.getBaseServiceByEntity((Class)iamAuthToken.getUserTypeClass());
        if (userService == null) {
            throw new AuthenticationException("\u7528\u6237 " + iamAuthToken.getUserTypeClass().getName() + " \u76f8\u5173\u7684Service\u672a\u5b9a\u4e49\uff01");
        }
        BaseLoginUser loginUser = (BaseLoginUser)((Object)userService.getEntity((Serializable)((Object)account.getUserId())));
        if (loginUser == null) {
            throw new AuthenticationException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        loginUser.setAuthToken(iamAuthToken.getAuthtoken());
        IamExtensible iamExtensible = this.getIamUserRoleService().getIamExtensible();
        if (iamExtensible != null && (extensionObj = iamExtensible.getUserExtensionObj(iamAuthToken.getUserTypeClass().getSimpleName(), account.getUserId(), iamAuthToken.getExtObj())) != null) {
            loginUser.setExtensionObj(extensionObj);
        }
        this.clearCachedAuthorizationInfo(IamSecurityUtils.getSubject().getPrincipals());
        log.debug("\u83b7\u53d6\u7528\u6237\u8ba4\u8bc1\u4fe1\u606f\u5b8c\u6210 : {}", iamAuthToken.getCredentials());
        return new SimpleAuthenticationInfo((Object)loginUser, iamAuthToken.getCredentials(), (ByteSource)new CustomSimpleByteSource(), this.getName());
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        List<IamRole> roleList;
        SimpleAuthorizationInfo authorizationInfo = new SimpleAuthorizationInfo();
        BaseLoginUser currentUser = (BaseLoginUser)((Object)principals.getPrimaryPrincipal());
        if (currentUser instanceof Client) {
            authorizationInfo.setStringPermissions(((Client)currentUser).getPermissions());
            log.debug("\u83b7\u53d6\u6388\u6743\u4fe1\u606f\u5b8c\u6210 : {}", (Object)currentUser.getDisplayName());
            return authorizationInfo;
        }
        String extensionObjId = null;
        LabelValue extensionObj = currentUser.getExtensionObj();
        if (extensionObj != null && extensionObj.getExt() != null && extensionObj.getExt() instanceof PositionDataScope) {
            extensionObjId = ((PositionDataScope)extensionObj.getExt()).getPositionId();
        }
        if (V.isEmpty(roleList = this.getIamUserRoleService().getUserRoleList(currentUser.getTenantId(), ((Object)((Object)currentUser)).getClass().getSimpleName(), (String)((Object)currentUser.getId()), extensionObjId))) {
            return authorizationInfo;
        }
        HashSet allRoleCodes = new HashSet();
        ArrayList<String> roleIds = new ArrayList<String>(roleList.size());
        roleList.stream().forEach(role -> {
            allRoleCodes.add(role.getCode());
            roleIds.add((String)((Object)role.getId()));
        });
        authorizationInfo.setRoles(allRoleCodes);
        List<String> allPermissionCodes = allRoleCodes.contains("TENANT_ADMIN") ? this.getIamTenantPermission().findAllPermissionCodes(currentUser.getTenantId()) : this.getIamRoleResourceService().getPermissionCodeList(Cons.APPLICATION, roleIds);
        HashSet permissionCodesSet = new HashSet();
        if (V.notEmpty(allPermissionCodes)) {
            allPermissionCodes.forEach(permCodeStr -> {
                if (!permCodeStr.contains(",")) {
                    permissionCodesSet.add(permCodeStr);
                } else {
                    permissionCodesSet.addAll(S.splitToList((String)permCodeStr));
                }
            });
        }
        authorizationInfo.setStringPermissions(permissionCodesSet);
        log.debug("\u83b7\u53d6\u7528\u6237\u6388\u6743\u4fe1\u606f\u5b8c\u6210 : {}", (Object)currentUser.getDisplayName());
        return authorizationInfo;
    }

    private IamUserRoleService getIamUserRoleService() {
        if (this.iamUserRoleService == null) {
            this.iamUserRoleService = (IamUserRoleService)ContextHolder.getBean(IamUserRoleService.class);
        }
        return this.iamUserRoleService;
    }

    private IamRoleResourceService getIamRoleResourceService() {
        if (this.iamRoleResourceService == null) {
            this.iamRoleResourceService = (IamRoleResourceService)ContextHolder.getBean(IamRoleResourceService.class);
        }
        return this.iamRoleResourceService;
    }

    private IamTenantPermission getIamTenantPermission() {
        if (this.iamTenantPermission == null) {
            this.iamTenantPermission = (IamTenantPermission)ContextHolder.getBean(IamTenantPermission.class);
        }
        return this.iamTenantPermission;
    }
}

