/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.shiro;

import com.diboot.core.util.S;
import com.diboot.iam.entity.IamUser;
import com.diboot.iam.util.TokenUtils;
import java.util.Map;
import lombok.Generated;
import org.apache.shiro.authc.RememberMeAuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IamAuthToken
implements RememberMeAuthenticationToken {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IamAuthToken.class);
    private static final long serialVersionUID = -5518501153334708409L;
    private Class userTypeClass = IamUser.class;
    private String authType;
    private String authAccount;
    private String authSecret;
    private boolean rememberMe;
    private Map<String, Object> extObj;
    private String authtoken;
    private String tenantId;
    private boolean validPassword = true;
    private Object principal;
    private Object credentials;
    private int expiresInMinutes;

    public IamAuthToken() {
    }

    public IamAuthToken(String authType, Class userTypeClass) {
        this.authType = authType;
        this.userTypeClass = userTypeClass;
    }

    public IamAuthToken(String userInfoStr) {
        String[] fields = userInfoStr.split(",");
        this.tenantId = fields[0];
        this.authAccount = fields[1];
        if (!IamUser.class.getSimpleName().equals(fields[2])) {
            try {
                this.userTypeClass = Class.forName(fields[2]);
            }
            catch (ClassNotFoundException e) {
                log.debug("Token\u9a8c\u8bc1\u5931\u8d25\uff01\u7528\u6237\u7c7b\u578b{}\u4e0d\u5b58\u5728", (Object)fields[2]);
            }
        }
        this.authType = fields[3];
        this.expiresInMinutes = Integer.parseInt(fields[4]);
    }

    public void clearAuthtoken() {
        this.authtoken = null;
    }

    public Object getPrincipal() {
        return this.authtoken;
    }

    public Object getCredentials() {
        return this.authtoken;
    }

    public String getUserType() {
        return this.userTypeClass.getSimpleName();
    }

    public IamAuthToken generateAuthtoken() {
        this.authtoken = TokenUtils.generateToken();
        return this;
    }

    public boolean isRememberMe() {
        return this.rememberMe;
    }

    public String buildUserInfoStr() {
        return S.joinWith((String)",", (Object[])new Object[]{this.getTenantId(), this.getAuthAccount(), this.getUserTypeClass().getName(), this.getAuthType(), this.expiresInMinutes, System.currentTimeMillis()});
    }

    @Generated
    public Class getUserTypeClass() {
        return this.userTypeClass;
    }

    @Generated
    public String getAuthType() {
        return this.authType;
    }

    @Generated
    public String getAuthAccount() {
        return this.authAccount;
    }

    @Generated
    public String getAuthSecret() {
        return this.authSecret;
    }

    @Generated
    public Map<String, Object> getExtObj() {
        return this.extObj;
    }

    @Generated
    public String getAuthtoken() {
        return this.authtoken;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public boolean isValidPassword() {
        return this.validPassword;
    }

    @Generated
    public int getExpiresInMinutes() {
        return this.expiresInMinutes;
    }

    @Generated
    public void setUserTypeClass(Class userTypeClass) {
        this.userTypeClass = userTypeClass;
    }

    @Generated
    public void setAuthType(String authType) {
        this.authType = authType;
    }

    @Generated
    public void setAuthAccount(String authAccount) {
        this.authAccount = authAccount;
    }

    @Generated
    public void setAuthSecret(String authSecret) {
        this.authSecret = authSecret;
    }

    @Generated
    public void setRememberMe(boolean rememberMe) {
        this.rememberMe = rememberMe;
    }

    @Generated
    public void setExtObj(Map<String, Object> extObj) {
        this.extObj = extObj;
    }

    @Generated
    public void setAuthtoken(String authtoken) {
        this.authtoken = authtoken;
    }

    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setValidPassword(boolean validPassword) {
        this.validPassword = validPassword;
    }

    @Generated
    public void setPrincipal(Object principal) {
        this.principal = principal;
    }

    @Generated
    public void setCredentials(Object credentials) {
        this.credentials = credentials;
    }

    @Generated
    public void setExpiresInMinutes(int expiresInMinutes) {
        this.expiresInMinutes = expiresInMinutes;
    }
}

