/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.shiro;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.shiro.lang.codec.Base64;
import org.apache.shiro.lang.codec.CodecSupport;
import org.apache.shiro.lang.codec.Hex;
import org.apache.shiro.lang.util.ByteSource;

public class CustomSimpleByteSource
implements ByteSource,
Serializable {
    private static final long serialVersionUID = 5175082362119580768L;
    private byte[] bytes;
    private String cachedHex;
    private String cachedBase64;

    public CustomSimpleByteSource() {
    }

    public CustomSimpleByteSource(byte[] bytes) {
        this.bytes = bytes;
    }

    public CustomSimpleByteSource(char[] chars) {
        this.bytes = CodecSupport.toBytes((char[])chars);
    }

    public CustomSimpleByteSource(String string) {
        this.bytes = CodecSupport.toBytes((String)string);
    }

    public CustomSimpleByteSource(ByteSource source) {
        this.bytes = source.getBytes();
    }

    public CustomSimpleByteSource(File file) {
        this.bytes = new BytesHelper().getBytes(file);
    }

    public CustomSimpleByteSource(InputStream stream) {
        this.bytes = new BytesHelper().getBytes(stream);
    }

    public static boolean isCompatible(Object o) {
        return o instanceof byte[] || o instanceof char[] || o instanceof String || o instanceof ByteSource || o instanceof File || o instanceof InputStream;
    }

    public byte[] getBytes() {
        return this.bytes != null ? Arrays.copyOf(this.bytes, this.bytes.length) : new byte[]{};
    }

    public String toHex() {
        if (this.cachedHex == null) {
            this.cachedHex = Hex.encodeToString((byte[])this.getBytes());
        }
        return this.cachedHex;
    }

    public String toBase64() {
        if (this.cachedBase64 == null) {
            this.cachedBase64 = Base64.encodeToString((byte[])this.getBytes());
        }
        return this.cachedBase64;
    }

    public boolean isEmpty() {
        return this.bytes == null || this.bytes.length == 0;
    }

    public String toString() {
        return this.toBase64();
    }

    public int hashCode() {
        return this.bytes != null && this.bytes.length != 0 ? Arrays.hashCode(this.bytes) : 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ByteSource) {
            ByteSource bs = (ByteSource)o;
            return Arrays.equals(this.getBytes(), bs.getBytes());
        }
        return false;
    }

    private static final class BytesHelper
    extends CodecSupport {
        private BytesHelper() {
        }

        public byte[] getBytes(File file) {
            return this.toBytes(file);
        }

        public byte[] getBytes(InputStream stream) {
            return this.toBytes(stream);
        }
    }
}

