/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.iam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.diboot.core.entity.AbstractEntity;
import com.diboot.core.service.impl.BaseServiceImpl;
import com.diboot.core.util.V;
import com.diboot.iam.cache.SystemConfigCacheManager;
import com.diboot.iam.entity.SystemConfig;
import com.diboot.iam.mapper.SystemConfigMapper;
import com.diboot.iam.service.SystemConfigService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SystemConfigServiceImpl
extends BaseServiceImpl<SystemConfigMapper, SystemConfig>
implements SystemConfigService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SystemConfigServiceImpl.class);
    @Autowired
    private SystemConfigCacheManager cacheManager;

    @Override
    public <T> T findConfigValue(String category, String propKey) {
        return (T)this.getConfigMapByCategory(category).get(propKey);
    }

    @Override
    public Map<String, Object> getConfigMapByCategory(String category) {
        List list;
        Map<String, SystemConfig> languageCached = this.cacheManager.getCachedConfig(category);
        if (V.notEmpty(languageCached)) {
            list = languageCached.values();
        } else {
            list = this.getEntityList((Wrapper)this.buildQueryWrapper(category).select(new SFunction[]{SystemConfig::getPropKey, SystemConfig::getPropValue, SystemConfig::getDataType}));
            this.cacheManager.cacheConfig(category, list);
        }
        return list.stream().collect(Collectors.toMap(SystemConfig::getPropKey, this::value4Type));
    }

    protected LambdaQueryWrapper<SystemConfig> buildQueryWrapper(String category) {
        return (LambdaQueryWrapper)Wrappers.lambdaQuery().and(query -> {
            if (V.isEmpty((String)category)) {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)query.eq(SystemConfig::getCategory, (Object)"")).or()).isNull(SystemConfig::getCategory);
            } else {
                query.eq(SystemConfig::getCategory, (Object)category);
            }
        });
    }

    protected Object value4Type(SystemConfig systemConfig) {
        String propValue = systemConfig.getPropValue();
        if (V.isEmpty((String)propValue)) {
            return propValue;
        }
        if ("boolean".equals(systemConfig.getDataType())) {
            return V.isTrue((String)propValue);
        }
        if ("number".equals(systemConfig.getDataType())) {
            return new BigDecimal(propValue);
        }
        return propValue;
    }

    protected void beforeCreate(SystemConfig entity) {
        this.cacheManager.removeCachedItems(entity.getCategory());
    }

    protected void beforeUpdate(SystemConfig entity) {
        this.cacheManager.removeCachedItems(entity.getCategory());
    }

    protected void beforeDelete(Object entityIds) {
        List<Object> ids = entityIds instanceof Collection ? (List<Object>)entityIds : List.of(entityIds);
        Wrapper query = (Wrapper)Wrappers.lambdaQuery().select(new SFunction[]{SystemConfig::getCategory}).in(AbstractEntity::getId, ids);
        this.getEntityList(query).stream().map(e -> e == null ? null : e.getCategory()).distinct().forEach(this.cacheManager::removeCachedItems);
    }
}

